<?php
if ( ! class_exists( 'NISHIKI_GB_EXTENSITON' ) ) {
	class NISHIKI_GB_EXTENSITON{
		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'nishiki_gb_extension_menu' ), 100 );

			// CSS追加
			add_action( 'admin_head', array( $this, 'nishiki_gb_admin_css' ), 20 );
		}

		/**
		 * サブメニュー追加
		 */
		public function nishiki_gb_extension_menu() {
			add_submenu_page(
				'nishiki-gb.php',
				'拡張プラグイン',
				'拡張プラグイン',
				'manage_options',
				'nishiki-gb-extension.php',
				array( $this, 'nishiki_gb_extension_page' )
			);
		}

		/**
		 * オプションページの内容
		 */
		public function nishiki_gb_extension_page() {
			// ユーザーが必要な権限を持つか確認する必要がある
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __('このページを表示する権限がありません。') );
			}

			// データベースから既存のオプション値を取得
			$remote_response = new NISHIKI_GB_PLUGIN_REMOTE_CHECK();
			$product = 'nishiki_gb';
			$nishiki_gb_hidden_field_name = 'nishiki_gb_submit_hidden';
			$extensions = array(
				'share',
				'social',
				'analytics',
				'meta',
				'content'
			);
			$extensions_meta = array(
				'share' => array( 'title' => 'シェアボタン', 'desc' => '投稿ページや固定ページにTwitter,Facebook,Google+,LINE,はてなブックマークなど、各種シェアボタンを設置する機能を追加します。ページごとに表示・非表示の設定も可能です。', 'icon' => 'share' ),
				'social' => array( 'title' => 'ソーシャルアカウント', 'desc' => 'フッター部分に各種ソーシャルアカウントへのリンクを表示する機能を追加します。ウェブサイトを訪れた方にソーシャルアカウントをフォローしてもらい、ファンを増やしましょう。RSSフィードの表示も可能です。', 'icon' => 'social' ),
				'analytics' => array( 'title' => 'アクセス解析', 'desc' => 'Google Analytics（グーグルアナリティクス）の解析タグを簡単に入れられる機能を追加します。ウェブサイトのPV（ページビュー）数・直帰率・滞在率・ページの表示速度などのアクセス解析を行い、パフォーマンス改善や分析に役立てましょう。', 'icon' => 'analytics' ),
				'meta' => array( 'title' => 'メタ情報', 'desc' => 'Schema.org（構造化データ）とOGP（Open Graph Protocol）の2つのメタ情報の設定ができる機能を追加します。Twitter,Facebookにウェブサイトをシェアした場合や、検索結果に表示される内容をカスタマイズできます。', 'icon' => 'meta' ),
				'content' => array( 'title' => 'コンテンツ', 'desc' => 'ウェブサイトを訪れた方に対してアクションを促すコンテンツの作成・管理ができるようになります。ウェブサイトで広告収入を得たい方、特定のページへの誘導や商品の購入を促したい方が使用すると便利なプラグインです。', 'icon' => 'flag' )
			);

			?>
			<div class="wrap">
			<?php
			// ユーザーが何か情報を POST したかどうかを確認
		  if ( isset( $_POST[ $nishiki_gb_hidden_field_name ] ) && sanitize_text_field( $_POST[ $nishiki_gb_hidden_field_name ] ) === 'Y' ) {

			  // POST されたデータを取得
			  $nishiki_gb_reg_keys_update = $_POST['nishiki_gb_reg_key'];
			  foreach ( $nishiki_gb_reg_keys_update as $extension => $data ) {

				  $new_data = array_map( 'sanitize_text_field',
					  wp_unslash( $data ) );
				  $new_key  = $new_data['reg_key'];

				  //保存されているキーと比べる
				  $old_data = get_option( $product . '_' . $extension );
				  if ( isset( $old_data['reg_key'] )
				       && $old_data !== false
				  ) {
					  $old_key = $old_data['reg_key'];
				  } else {
					  $old_key = '';
				  }

				  //新しいキーが入力された時
				  if ( $old_key !== $new_key ) {

					  $args = array(
						  'product'   => $product,
						  'extension' => $extension,
						  'site_url'  => get_option( 'home' ),
						  'key'       => $new_data['reg_key'],
					  );

					  $response = $remote_response->remote_check( $args );

					  if ( $response ) {
						  $new_data['activate'] = true;
						  update_option( $product . '_' . $extension,
							  $new_data );
					  } else {
						  update_option( $product . '_' . $extension,
							  array() );
					  }
				  }
			  }

			  // 画面に「設定は保存されました」メッセージを表示
			  echo '<div id="setting-error-settings_updated" class="updated settings-error notice is-dismissible"> 
	<p><strong>設定を保存しました。</strong></p><button type="button" class="notice-dismiss"><span class="screen-reader-text">この通知を非表示にする</span></button></div>';
			}
			?>
			<h1>Nishiki Growing Beauty</h1>
			<h2>拡張プラグイン</h2>
			<p>Nishiki テーマを使ったウェブサイト運営・管理がとても便利になる拡張プラグインを提供しています。ぜひご利用ください！</p>
			<form name="nishiki_gb_admin_form" method="post" action="">
				<input type="hidden" name="<?php echo $nishiki_gb_hidden_field_name; ?>" value="Y">
		  <?php wp_nonce_field( "nishiki_gb_submit_post",
			  "nishiki_gb_submit_wpnonce" ); ?>
				<div class="nishiki_gb_admin_page">
			<?php
			//現在の設定を取得
			foreach ( $extensions as $extension ) {
				$reg_key_data = get_option( $product . '_' . $extension );
				if ( isset( $reg_key_data ) && $reg_key_data !== false ) {
					if ( isset( $reg_key_data['reg_key'] )
					     && $reg_key_data['reg_key'] !== ''
					) {

						//アクティベートチェック
						if ( ! isset( $_POST[ $nishiki_gb_hidden_field_name ] ) ) {

							$args = array(
								'product'   => $product,
								'extension' => $extension,
								'site_url'  => get_option( 'home' ),
								'key'       => $reg_key_data['reg_key'],
							);

							$response
								= $remote_response->remote_check( $args );
							if ( $response ) {
								if ( $reg_key_data['activate'] == false ) {
									$reg_key_data['activate'] = true;
									update_option( $product . '_'
									               . $extension,
										$reg_key_data );
									$reg_key_data = get_option( $product
									                            . '_'
									                            . $extension );
								}
							} else {
								if ( $reg_key_data['activate'] == true ) {
									$reg_key_data['activate'] = false;
									update_option( $product . '_'
									               . $extension,
										$reg_key_data );
									$reg_key_data = get_option( $product
									                            . '_'
									                            . $extension );
								}
							}
						}

						${$product . '_' . $extension . '_reg_key'}
							= $reg_key_data['reg_key'];
						if ( $reg_key_data['activate'] === true ) {
							${$product . '_' . $extension . '_activate'}
								= 'true';
						} else {
							${$product . '_' . $extension . '_activate'}
								= 'false';
						}

					} else {
						${$product . '_' . $extension . '_reg_key'} = '';
						${$product . '_' . $extension . '_activate'}
						                                            = 'false';
					}
				} else {
					${$product . '_' . $extension . '_reg_key'}  = '';
					${$product . '_' . $extension . '_activate'} = 'false';
				}

				// delete_option( $product . '_' . $extension );

				$args = array(
					'title'     => $extensions_meta[ $extension ]['title'],
					'desc'      => $extensions_meta[ $extension ]['desc'],
					'icon'      => $extensions_meta[ $extension ]['icon'],
					'product'   => $product,
					'extension' => $extension,
					'reg_key'   => ${$product . '_' . $extension
					                 . '_reg_key'},
					'activate'  => ${$product . '_' . $extension
					                 . '_activate'}
				);

				$this->nishiki_gb_admin_create_form( $args );
			}
			?>

				</div>

		  <?php submit_button(); ?>
			</form>
				<p class="nishiki_gb_reg_key_text">
					<span class="dashicons dashicons-info"></span>Nishiki Growing Beauty 拡張プラグインのサポート・アップデートサービスを受けるには製品登録が必要です。製品登録の方法は<a target="_blank" href="https://support.animagate.com/manual/wp-nishiki-gb-extension-regist/">こちら</a>をご参考ください。
				</p>

			</div>
			<?php
		}

	  // Create Admin Form
	  public function nishiki_gb_admin_create_form( $args ) {
		  if ( empty( $args ) ) {
			  return false;
		  }
		  ?>
				<dl>
					<dt><h2><?php echo esc_html( $args['title'] ); ?></h2></dt>
					<dd><?php echo esc_html( $args['desc'] ); ?><?php
			  if ( $args['activate'] == 'false' ) {
				  echo '<p class="activate">※登録キーを購入し、入力してください。</p>';
			  }
			  ?>
					</dd>
			<?php if ( is_plugin_active( "nishiki-gb-{$args['extension']}/nishiki-gb-{$args['extension']}.php" ) ) { ?>
							<dd class="regist_key dashicons-before dashicons-admin-network <?php echo esc_attr( $args['activate'] ); ?>">
								<input type="text" name="<?php echo esc_attr( $args['product'] ); ?>_reg_key[<?php echo esc_attr( $args['extension'] ); ?>][reg_key]" value="<?php echo esc_attr( $args['reg_key'] ); ?>">
								<input type="hidden" name="<?php echo esc_attr( $args['product'] ); ?>_reg_key[<?php echo esc_attr( $args['extension'] ); ?>][activate]" value="<?php echo esc_attr( $args['activate'] ); ?>">
							</dd>
			<?php } else { ?>
							<dd>
								<a target="_blank" class="button" href="https://support.animagate.com/product/nishiki-gb-<?php echo $args['extension']; ?>/">製品登録する</a>
							</dd>
			<?php } ?>
					<img src="<?php echo nishiki_gb_plugin_dir_root()
		                       . 'customizer/assets/admin/'
		                       . esc_attr( $args['icon'] ) . '.svg'; ?>">
				</dl>

		  <?php
	  }

	  // CSS 追加
	  public function nishiki_gb_admin_css() {
		  $output
			  = <<< EOT
					.nishiki_gb_reg_key_text{
						background: #f9f5bf;
						border: 1px solid #efd30f;
						border-radius: 3px;
						padding:0.5rem;
					}
					.nishiki_gb_admin_page{
						display:inline-flex;
						flex-wrap: wrap;
						max-width:1000px;
						justify-content: space-between;
					}
					.nishiki_gb_admin_page dl{
						flex-basis:49%;			
						flex-direction:column;
						border:1px solid #ddd;
						border-radius:6px;
						padding:1rem;
						box-sizing:border-box;
						background:#fff;
						position:relative;
					}
					.nishiki_gb_admin_page dd{
						margin:0.5rem 0;
					}
					.nishiki_gb_admin_page dd a.button{
						margin:0.5rem 0 0;
					}
					.nishiki_gb_admin_page dd.regist_key{
						margin:2rem 0 0;
					}
					.nishiki_gb_admin_page dd.regist_key:before{
						color: #ddd;
						margin-right:0.3rem;
						vertical-align: text-top;
					}
					.nishiki_gb_admin_page dd.regist_key.true:before{
						color: #67cc00;
					}
					.nishiki_gb_admin_page dl img{
						vertical-align: text-top;
						right: 1rem;
						bottom: 1rem;
						position:absolute;
						width: 3rem;
						height: auto;
					}
					.nishiki_gb_admin_page .activate{
						color:#418000;
						font-weight:bold;
					}	
				
					@media screen and (max-width: 782px) {
						.nishiki_gb_admin_page{
						}
						.nishiki_gb_admin_page dl{
							flex-basis:100%;			
						}
					}
EOT;

		  echo '<style>' . esc_html( $output ) . '</style>';
	  }

  }

	if ( is_admin() ) {
		$output = new NISHIKI_GB_EXTENSITON();
	}
}
