<?php
if ( ! class_exists( 'NISHIKI_GB_OPTIMIZE' ) ) {
	/**
	 * Create OPTIMIZE.
	 */
	class NISHIKI_GB_OPTIMIZE extends NISHIKI_GB_GENERAL_UTILITY {
		/**
		 * 初期設定
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_gb_register_settings' ), 20 );

			// スクリプトを読み込む
			if ( $this->is_nishiki_gb_optimize_script() ) {
				add_action( 'wp_enqueue_scripts', array( $this, 'nishiki_gb_optimize_scripts' ) );
			}
		}

		/**
		 * フォームの登録
		 */
		public function nishiki_gb_register_settings() {
			$page_name = $this->plugin_name . '_optimize';

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				__( '', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_general_cb' ),
				$page_name
			);

			add_settings_field(
				'enable',
				__( 'jQuery の読み込みを最適化', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_checkbox_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '有効にする',
					'label' => 'enable',
					'page_name' => $page_name,
					'description' => '読み込みを最適化することによって、影響を受けるページやプラグインがあるかもしれません。その場合はチェックを外してください。また、Nishiki GB「スクリプト追加」で独自の JavaScript を挿入している場合は、出力の優先順位を変更して読み込み順を調整してください。',
				)
			);
		}

		/**
		 *
		 * 表示設定チェック
		 */
		public function is_nishiki_gb_optimize_script() {
			$page_name = $this->plugin_name . '_optimize';

			$options = get_option( $page_name );

			if ( empty( $options ) || empty( $options['enable'] ) )
				return false;

			return $options;
		}


		/**
		 * 最適化実行
		 */
		public function nishiki_gb_optimize_scripts() {
			if ( ! is_admin() ) {
				wp_deregister_script( 'jquery' );
				wp_register_script( 'jquery', '/wp-includes/js/jquery/jquery.js', array(), null, true );
				wp_enqueue_script( 'jquery' );
			}
		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			// チェックボックス
			if ( isset( $input['enable'] ) ) {
				$new_input['enable'] = absint( $input['enable'] );
			}

			return $new_input;
		}

	}
}

$output = new NISHIKI_GB_OPTIMIZE();
