<?php
// Init Customizer
if ( ! function_exists( 'nishiki_gb_init_customizer_support' ) ) {
	add_action( "customize_register", "nishiki_gb_init_customizer_support" );
	function nishiki_gb_init_customizer_support( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_GB_PREFIX_SUPPORT, array(
				'title'     => __( 'Nishiki Pro', 'nishiki_gb' ),
				'priority'  => 600,
				'panel'     => 'panel_' . NISHIKI_GB_PREFIX,
			)
		);

		// Nishiki Pro Support.
		$wp_customize->add_setting( 'setting_' . NISHIKI_GB_PREFIX_SUPPORT . '_wp_nishiki_pro', array(
			'sanitize_callback' => 'nishiki_sanitize_text',
		));

		$wp_customize->add_control(
			new Nishiki_GB_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_GB_PREFIX_SUPPORT . '_wp_nishiki_pro',
				array(
					'label'         =>  '',
					'start_content' =>  '--- Nishiki Pro 新登場 ---',
					'content'       =>  '<p>Nishiki テーマに「ウェブサイト運営に欠かせない機能」を搭載したプロフェッショナル版「Nishiki Pro」が出ました！ Nishiki テーマに WordPress プラグインを入れて機能を追加したいんだけど、そもそもどのプラグインがいいのかわからない・・・検証するのも手間だし、セキュリティも気になるし、知識や経験が必要で困っている・・・という方に強くおすすめします。</p><ul class="nishiki_theme_support"><li><a class="orange" target="_blank" href="https://support.animagate.com/product/wp-nishiki-pro/">テーマ専用ページ</a></li><li><a class="red" target="_blank" href="https://demo.animagate.com/site/">デモサイト</a></li></ul>',
					'end_content'   =>  '',
					'section'       =>  'section_' . NISHIKI_GB_PREFIX_SUPPORT,
					'settings'      =>  'setting_' . NISHIKI_GB_PREFIX_SUPPORT . '_wp_nishiki_pro',
				)
			)
		);


	}
}
