<?php
if ( ! class_exists( 'NISHIKI_GB_GENERAL_UTILITY' ) ) {
	class NISHIKI_GB_GENERAL_UTILITY extends NISHIKI_GB_GENERAL_UTILITY_FORM{
		/**
		 * Holds plugin name
		 *
		 * @var 0.0.1
		 */
		public $options;

		public $plugin_name = 'nishiki_gb_general';

		/**
		 * フォームの出力（全ページ）
		 */
		public function nishiki_gb_general_cb() {
			$nonce = wp_create_nonce( $this->plugin_name );
			echo '<input type="hidden" name="' . $this->plugin_name . '" value="' . esc_attr( $nonce ) . '" />';
		}

		/**
		 * フォーム作成（単数チェック）
		 */
		public function nishiki_gb_checkbox_cb( $args ) {
			$this->options = get_option( $args['page_name'] );

			$this->create_form_checkbox( $args['title'], $args['label'], $args['page_name'] );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 * フォーム作成（複数チェック）
		 */
		public function nishiki_gb_checkbox_multiple_cb( $args ) {
			$this->options = get_option( $args['page_name'] );

			$this->create_form_checkbox_multiple( $args['title'], $args['label'], $args['page_name'], $args['script'] );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 * フォーム作成（テキスト）
		 */
		public function nishiki_gb_text_cb( $args ) {
			$this->options = get_option( $args['page_name'] );

			$this->create_form_text( $args['title'], $args['label'], $args['page_name'], '' );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 * フォーム作成（テキストエリア）
		 */
		public function nishiki_gb_textarea_cb( $args ) {
			$this->options = get_option( $args['page_name'] );

			//delete_option( $args['page_name'] );

			$this->create_form_textarea( $args['title'], $args['label'], $args['page_name'] );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 *
		 * カスタム投稿タイプかどうかチェック
		 */
		public function is_custom_post_type() {
			$post_obj = get_post_type_object( get_post_type() );
			if ( ! empty( $post_obj ) && $post_obj->_builtin === false ) {
				return $post_obj;
			} else {
				return false;
			}
		}
	}
}
