<?php
// Add CSS
function nishiki_gb_css(){
	$output = '';

	/*****************
	 * Profile
	 ******************/

	$nishiki_gb_user_profile_options = get_option( 'nishiki_gb_general_profile' );
	if ( ! empty( $nishiki_gb_user_profile_options ) ) {
		$output .= "
			#nishiki-gb-user-profile-wrapper{text-align: center;}
			#nishiki-gb-user-profile-wrapper a{display:inline-block;margin: 0 0.5rem 0.5rem;}
			#nishiki-gb-user-profile-wrapper i{font-size:1.5rem;}
		";
	}

	/*****************
	 * Breadcrumbs
	 ******************/

	$nishiki_gb_breadcrumbs = get_option( 'nishiki_gb_general_breadcrumbs' );
	if ( ! empty( $nishiki_gb_breadcrumbs['enable'] ) ) {
		$output .= "
			.nishiki-gb-breadcrumbs{font-size:0.85rem;padding: 0.8rem 0;}
			.nishiki-gb-breadcrumbs .container{white-space: nowrap;overflow: hidden;text-overflow: ellipsis;}
		";
	}

	$breadcrumbs_background_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_background_color', '' ) );

	// Background Color
	if ( ! empty( $breadcrumbs_background_color ) ) {
		$output .= "
			.nishiki-gb-breadcrumbs{background-color:{$breadcrumbs_background_color};}
		";
	}

	$breadcrumbs_text_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_text_color', '#333333' ) );

	// Text Color
	if ( ! empty( $breadcrumbs_text_color ) ) {
		$output .= "
			.nishiki-gb-breadcrumbs{color:{$breadcrumbs_text_color};}
		";
	}

	// Text Link Color
	$breadcrumbs_link_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_link_color', '#0a88cc' ) );

	if ( ! empty( $breadcrumbs_link_color ) ) {
		$output .= "
			.nishiki-gb-breadcrumbs a{color:{$breadcrumbs_link_color};}
		";
	}

	// Text Link Hover Color
	$breadcrumbs_link_hover_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_link_hover_color', '#0044a3' ) );

	if ( ! empty( $breadcrumbs_link_hover_color ) ) {
		$output .= "
			.nishiki-gb-breadcrumbs a:hover{color:{$breadcrumbs_link_hover_color};}
		";
	}

	/*****************
	 * Social Button
	 ******************/

	if ( get_theme_mod( 'setting_' . NISHIKI_GB_PREFIX_SOCIAL . '_button_css', true ) === true ) {
		$output .= "
			#nishiki_gb_social_wrapper{padding:3rem 1rem;text-align: center;}
			#nishiki_gb_social_wrapper p{margin:0;font-size:0.9rem;}
			#nishiki_gb_social_wrapper > div{margin:0 auto;}
			#nishiki_gb_social_wrapper > div a{display: inline-block;margin:1.5rem 1rem;padding:0.8rem;}
			#nishiki_gb_social_wrapper > div a i{font-size:1.6rem;vertical-align: middle;}
		";

		// Text Color
		$nishiki_gb_social_text_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_GB_PREFIX_SOCIAL . '_text_color', '#fff' ) );
		$output .= "
		#nishiki_gb_social_wrapper{color:{$nishiki_gb_social_text_color};}
		#nishiki_gb_social_wrapper a{color:{$nishiki_gb_social_text_color};}
		#nishiki_gb_social_wrapper > div a{border:1px solid {$nishiki_gb_social_text_color};}
		";

		// Background Color
		$nishiki_gb_social_background_color = esc_html( get_theme_mod( 'setting_' . NISHIKI_GB_PREFIX_SOCIAL . '_background_color', '#142746' ) );
		$output .= "
		#nishiki_gb_social_wrapper{background:{$nishiki_gb_social_background_color};}
		#nishiki_gb_social_wrapper a:hover{color:{$nishiki_gb_social_background_color};background:{$nishiki_gb_social_text_color};}
		";

	}


	/*****************
	 * Share Button
	 ******************/

	if( get_theme_mod( 'setting_' . NISHIKI_GB_PREFIX_SHARE . '_button_css', true ) === true ) {
		$output .= "
			.nishiki_share_button_wrapper{margin:1.5rem auto;letter-spacing:normal;}
			.nishiki_share_button_wrapper .before_text{margin:0 0 .5rem;text-align:center}
			.nishiki_share_button_wrapper .after_text{margin:.5rem 0 0;text-align:center}
			.nishiki_share_button_wrapper>div{text-align:center;display:-webkit-inline-box;display:-webkit-inline-flex;display:-ms-inline-flexbox;display:inline-flex;width:100%;-webkit-box-pack:justify;-webkit-justify-content:space-between;-ms-flex-pack:justify;justify-content:space-between}
			.nishiki_share_button_wrapper>div a{-webkit-box-flex:1;-webkit-flex:1;-ms-flex:1;flex:1;display:inline-block;padding:.5rem 0;width:100%;color:#fff;font-size:1.3rem}
			.nishiki_share_button_wrapper>div a i{vertical-align:middle}
			.nishiki_share_button_wrapper>div a.line{background:#00b900}.nishiki_share_button_wrapper>div a.line:hover{background:#008f00}
			.nishiki_share_button_wrapper>div a.tw{background:#1B95E0}.nishiki_share_button_wrapper>div a.tw:hover{background:#1772ab}
			.nishiki_share_button_wrapper>div a.fb{background:#3D659D}.nishiki_share_button_wrapper>div a.fb:hover{background:#385184}
			.nishiki_share_button_wrapper>div a.gplus{background:#CE3D2B}.nishiki_share_button_wrapper>div a.gplus:hover{background:#a43124}
			.nishiki_share_button_wrapper>div a.hb{background:#00a4de}.nishiki_share_button_wrapper>div a.hb:hover{background:#0086b5}
		";

	}

	// Output
	if( $output === '' ) return false;
	$str = array( "\t", "\r\n", "\r", "\n" );
	$output = str_replace( $str, '', $output );

	return $output;
}
