<?php

// Text
function nishiki_gb_sanitize_text( $text ) {
	return sanitize_text_field( $text );
}

// Sidebar
function nishiki_gb_sanitize_choices( $input ) {
	$valid = array( 'top', 'bottom', 'both', 'none' );
	if ( in_array( $input, $valid, true ) ) {
		return $input;
	}
	return 'bottom';
}

// Checkbox
function nishiki_gb_sanitize_checkbox( $checked ) {
	return ( ( isset( $checked ) && true === $checked ) ? true : false );
}

// Image
function nishiki_gb_sanitize_image( $image, $setting ) {
	$mimes = array(
		'jpg|jpeg|jpe' => 'image/jpeg',
		'gif'          => 'image/gif',
		'png'          => 'image/png',
		'bmp'          => 'image/bmp',
		'tif|tiff'     => 'image/tiff',
		'ico'          => 'image/x-icon'
	);
	$file = wp_check_filetype( $image, $mimes );
	return ( $file['ext'] ? $image : $setting->default );
}

// Meta Catd Type
function nishiki_gb_sanitize_choices_meta_cards_type( $input ) {
	$valid = array( 'summary', 'summary_large_image' );
	if ( in_array( $input, $valid, true ) ) {
		return $input;
	}
	return 'summary';
}

function nishiki_gb_sanitize_choices_meta_json_ld_type( $input ) {
	$valid = array( 'BlogPosting', 'Article' );
	if ( in_array( $input, $valid, true ) ) {
		return $input;
	}
	return 'BlogPosting';
}

// Website Type
function nishiki_gb_sanitize_choices_meta_json_ld_website_type( $input ) {
	$valid = array( '', 'Organization', 'Person' );
	if ( in_array( $input, $valid, true ) ) {
		return $input;
	}
	return '';
}

// Website Type
function nishiki_gb_sanitize_choices_meta_json_ld_contactpoint_contactoption( $input ) {
	$valid = array( '', 'TollFree', 'HearingImpairedSupported' );
	if ( in_array( $input, $valid, true ) ) {
		return $input;
	}
	return '';
}

// contactPoint contactType
function nishiki_gb_sanitize_choices_meta_json_ld_contactpoint_contacttype( $input ) {
	$valid = array(
		'',
		'customer service',
		'technical support',
		'billing support',
		'bill payment',
		'sales',
		'reservations',
		'credit card_support',
		'emergency',
		'baggage tracking',
		'roadside assistance',
		'package tracking',
	);
	if ( in_array( $input, $valid, true ) ) {
		return $input;
	}
	return '';
}


