/**
 * Scripts within the customizer controls window.
 *
 * Contextually shows the color hue control and informs the preview
 * when users open or close the front page sections section.
 */

(function() {
	wp.customize.bind( 'ready', function() {

		var nishiki_gb_meta_json_ld_website_type = jQuery("[id^='customize-control-ctrl_nishiki_gb_meta_json_ld_website_type']");
		var nishiki_gb_meta_json_ld_website_type_count = nishiki_gb_meta_json_ld_website_type.length;

		jQuery("[id^='customize-control-ctrl_nishiki_gb_support_']").find('.nishiki_theme_support a').css({'font-weight':'normal','color':'#333','background':'#fff','border-radius': '4px','padding': '0.6rem 0.8rem','display': 'block','text-decoration': 'none', 'border':'1px solid #ccc'});

		jQuery("[id^='customize-control-ctrl_nishiki_gb_support_']").find('.orange').css({'color':'#fff','background':'#ff6f13'});
		jQuery("[id^='customize-control-ctrl_nishiki_gb_support_']").find('.red').css({'color':'#fff','background':'#e61643'});

		if( nishiki_gb_meta_json_ld_website_type_count > 0 ){
			wp.customize( 'setting_nishiki_gb_meta_json_ld_website_type', function( setting ) {

				// Organization logo url
				wp.customize.control( 'ctrl_nishiki_gb_meta_json_ld_organization_logo_url', function( control ) {
					var visibility = function() {
						if ( 'Organization' === setting.get() ) {
							control.container.slideDown( 180 );
						} else {
							control.container.slideUp( 180 );
						}
					};

					visibility();
					setting.bind( visibility );
				});


			});
		}

		// Detect when the front page sections section is expanded (or closed) so we can adjust the preview accordingly.
		// wp.customize.section( 'section_front_page', function( section ) {
		// 	section.expanded.bind( function( isExpanding ) {
		// 		console.log(isExpanding);
		//
		// 		// Value of isExpanding will = true if you're entering the section, false if you're leaving it.
		// 		wp.customize.previewer.send( 'section-highlight', { expanded: isExpanding });
		// 	} );
		// } );
	});
})( jQuery );
