<?php
if ( ! class_exists( 'NISHIKI_GB_BREADCRUMBS' ) ) {
	/**
	 * Create Code.
	 */
	class NISHIKI_GB_BREADCRUMBS extends NISHIKI_GB_GENERAL_UTILITY {

		/**
		 * Constructor.
		 *
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_gb_register_settings' ), 20 );
			add_action( 'template_redirect', function() {
				$this->output();
			});

			//add_filter( 'nishiki_before_site_footer', array( $this, 'output' ), 30 );
			//add_filter( 'nishiki_before_site_footer', array( $this, 'get_hansel_and_gretel_breadcrumbs' ), 30 );
		}

		/**
		 * フォーム追加
		 */
		public function nishiki_gb_register_settings(){
			$page_name = $this->plugin_name . '_breadcrumbs';

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				__( '', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_general_cb' ),
				$page_name
			);

			add_settings_field(
				'enable',
				__( 'パンくずリストを表示する', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_checkbox_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '有効化',
					'label' => 'enable',
					'page_name' => $page_name,
					'description' => '有効にする場合はチェックを入れてください。',
				)
			);

			add_settings_field(
				'display',
				__( '表示箇所', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_checkbox_multiple_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '',
					'label' => 'display',
					'page_name' => $page_name,
					'description' => '表示する箇所にチェックを入れてください。',
					'script' => array(
						'header' => 'ヘッダー',
						'footer' => 'フッター',
					),
				)
			);

			add_settings_field(
				'post_type',
				__( '表示する投稿・固定ページ', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_checkbox_multiple_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '',
					'label' => 'post_type',
					'page_name' => $page_name,
					'description' => '有効にする場合はチェックを入れてください。',
					'script' => $this->post_types(),
				)
			);

			add_settings_field(
				'archive',
				__( '表示するアーカイブページ', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_checkbox_multiple_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '',
					'label' => 'archive',
					'page_name' => $page_name,
					'description' => '有効にする場合はチェックを入れてください。「年」「月」「日」のアーカイブページでパンくずリストを表示する場合は、パーマリンク設定を「基本」以外に設定してください。',
					'script' => $this->archives(),
				)
			);

			add_settings_field(
				'other',
				__( 'その他のページ', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_checkbox_multiple_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '',
					'label' => 'other',
					'page_name' => $page_name,
					'description' => '有効にする場合はチェックを入れてください。',
					'script' => $this->other(),
				)
			);

			add_settings_field(
				'separater',
				__( 'セパレーター', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_text_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '',
					'label' => 'separater',
					'page_name' => $page_name,
					'description' => '階層を区切る文字列を入れてください。',
				)
			);
		}

		/**
		 * 投稿タイプの配列取得
		 */
		public function post_types(){
			$pt_args = array(
				'public'   => true,
			);
			$output = 'objects';
			$operator = 'and';
			$pts = get_post_types( $pt_args, $output, $operator );

			$pt_array = array();

			foreach ( $pts as $pt ) {
				if ( $pt->name !== 'attachment' ) {
					$pt_array[ $pt->name ] = $pt->label;
				}
			}

			return $pt_array;
		}


		/**
		 * タクソノミーの配列取得
		 */
		public function taxonomy_archives() {
			$args = array(
				'public'   => true,
			);
			$output = 'objects';
			$operator = 'and';
			$taxonomies = get_taxonomies( $args, $output, $operator );

			$tax_array = array();

			foreach ( $taxonomies as $taxonomy ) {
				if ( $taxonomy->name !== 'post_format' ) {
					$tax_array[ $taxonomy->name ] = $taxonomy->label;
				}
			}

			return $tax_array;
		}

		/**
		 * 投稿タイプのアーカイブページ
		 */
		public function post_type_archives(){
			$args = array(
				'public'   => true,
				'_builtin' => false
			);

			$output = 'objects';
			$operator = 'and';

			$post_types = get_post_types( $args, $output, $operator );

			$post_types_array = array();

			foreach ( $post_types as $post_type ) {
				$post_types_array[ $post_type->name ] = $post_type->label;
			}

			return $post_types_array;
		}

		/**
		 * その他のアーカイブページ
		 */
		public function other_archives(){
			$archive_array = array(
				'author'    => '著者',
				'paged'     => '複数ページ',
				'year'      => '年',
				'month'     => '月',
				'day'       => '日',
			);

			return $archive_array;
		}

		/**
		 * アーカイブページの配列
		 */
		public function archives(){
			$taxonomy_archives = $this->taxonomy_archives();
			$post_type_archives = $this->post_type_archives();
			$other_archives = $this->other_archives();

			$archives = array_merge( $taxonomy_archives, $post_type_archives );
			$archives = array_merge( $archives, $other_archives );

			return $archives;
		}


		/**
		 * その他のページ配列取得
		 */
		public function other() {
			$other_array = array(
				'404'   => '404',
				'search'    => '検索',
			);

			return $other_array;
		}

		/**
		 * 出力
		 */
		public function output() {
			$page_name = $this->plugin_name . '_breadcrumbs';
			$options = get_option( $page_name );

			echo $this->create_breadcrumbs( $options );
		}


		/**
		 * パンくずリスト作成
		 */
		public function create_breadcrumbs( $options ){

			global $wp_query;

			$queried_object     = get_queried_object();
			$separater          = wp_kses_post( $options['separater'] );
			$home_link          = get_bloginfo( 'url' );
			$home_text          = __( 'Home' );
			$link_before        = '<span typeof="v:Breadcrumb">';
			$link_after         = '</span>';
			$link_attr          = ' rel="v:url" property="v:title"';
			$link               = $link_before . '<a' . $link_attr . ' href="%1$s">%2$s</a>' . $link_after;
			$before             = '<span class="current">';
			$after              = '</span>';
			$breadcrumbs        = '';
			$parent_string      = '';

			if ( is_singular() && ! is_front_page() ) {
				$post_type  = $queried_object->post_type;
				$post_id    = $queried_object->ID;
				$parent     = $queried_object->post_parent;
				$post_link  = $before . esc_html( get_the_title() ) . $after;

				// if parent exist.
				if ( 0 !== $parent ) {
					$parent_links = array();
					while ( $parent ) {
						$post_parent = get_post( $parent );

						$parent_links[] = sprintf( $link, esc_url( get_permalink( $post_parent->ID ) ), esc_html( get_the_title( $post_parent->ID ) ) );

						$parent = $post_parent->post_parent;
					}

					$parent_links = array_reverse( $parent_links );

					$parent_string = implode( $separater, $parent_links );
				}

				if ( $parent_string ) {
					$breadcrumbs = $parent_string . $separater . $post_link;
				} else {
					$breadcrumbs = $post_link;
				}

				if ( $this->is_custom_post_type() ) {
					$post_type_object = get_post_type_object( $post_type );
					$post_type_link = get_post_type_archive_link( $post_type );
					$breadcrumbs = sprintf( $link, esc_url( $post_type_link ), esc_html( $post_type_object->label ) ) . $separater . $post_link;
				} elseif ( $post_type === 'post' ) {
					$categories = get_the_terms( $post_id, 'category' );
					$breadcrumbs = sprintf( $link, esc_url( get_term_link( $categories[0]->term_id ) ), esc_html( $categories[0]->name ) ) . $separater . $post_link;
				}

			}

			if ( is_archive() ) {
				$term_object = get_queried_object();

				if ( is_post_type_archive() ) {
					$breadcrumbs = $before . esc_html( $term_object->labels->singular_name ) . $after;
				}

				if ( is_category() || is_tag() || is_tax() ) {
					// Set the variables for this section
					$term_object        = get_term( $queried_object );
					$taxonomy           = $term_object->taxonomy;
					$term_name          = $term_object->name;
					$term_parent        = $term_object->parent;
					$taxonomy_object    = get_taxonomy( $taxonomy );
					$current_term_link  = $before . $term_name . $after;
					$parent_term_string = '';

					if ( 0 !== $term_parent )
					{
						// Get all the current term ancestors
						$parent_term_links = array();
						while ( $term_parent ) {
							$term = get_term( $term_parent, $taxonomy );

							$parent_term_links[] = sprintf( $link, esc_url( get_term_link( $term ) ), $term->name );

							$term_parent = $term->parent;
						}

						$parent_term_links  = array_reverse( $parent_term_links );
						$parent_term_string = implode( $separater, $parent_term_links );
					}

					if ( $parent_term_string ) {
						$breadcrumbs = $parent_term_string . $separater . $current_term_link;
					} else {
						$breadcrumbs = $current_term_link;
					}

					//$breadcrumbs = $before . esc_html( $term_object->name ) . $after;
				}

				if ( is_date() ) {
					$year     = $wp_query->query_vars['year'];
					$month = $wp_query->query_vars['monthnum'];
					$day      = $wp_query->query_vars['day'];

					if ( is_year() ) {
						$breadcrumbs = sprintf( esc_html__( '%s year' ), $year );

					} elseif( is_month() ) {

						$year_link = sprintf( $link, esc_url( get_year_link( $year ) ), sprintf( esc_html__( '%s year' ), $year ) );
						$month_text = $month . __( 'Month' );

						$breadcrumbs = $year_link . $separater . $month_text;

					} elseif( is_day() ) {

						$year_link = sprintf( $link, esc_url( get_year_link( $year ) ), sprintf( esc_html__( '%s year' ), $year ) );
						$month_text = $month . __( 'Month' );
						$month_link = sprintf( $link, esc_url( get_month_link( $year, $month ) ), $month_text );
						$day_text = $day . __( 'Day' );

						$breadcrumbs = $year_link . $separater . $month_link . $separater . $day_text;
					}
				}

				if ( is_author() ) {
					$breadcrumbs = $before . esc_html( $queried_object->data->display_name ) . $after;
				}
			}

			if ( is_404() ) {
				$breadcrumbs = __( 'Page not found' );
			}

			if ( is_search() ) {
				$breadcrumbs = '検索：' . get_search_query();
			}

			if ( is_front_page() || is_home() ) {
				if ( is_paged() ) {
					$current_page = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : get_query_var( 'page' );
					$breadcrumbs = $before . sprintf( __( 'Page %s' ), number_format_i18n( $current_page ) ) . $after;
				}
			}

			if ( $breadcrumbs === '' ) {
				return false;
			}

			$output = '<div class="nishiki-gb-breadcrumbs"><div class="container">';
			$output .= '<a rel="v:url" property="v:title" href="' . $home_link . '">' . $home_text . '</a>' . $separater;
			$output .= $breadcrumbs;
			$output .= '</div></div>';

			if ( isset( $options['enable'] ) ) {
				// Header
				if ( isset( $options['display']['header'] ) ) {
					if( is_singular() && ! is_front_page() ){
						$post_type  = $queried_object->post_type;

						if ( isset( $options['post_type'][ $post_type ] ) ) {
							add_filter( 'nishiki_after_singular_header', function() use ( $options, $output ) { echo $output; }, 10 );
						}
					}

					if ( is_archive() ) {
						$term_object = get_queried_object();

						if( is_category() || is_tag() || is_tax() ){
							$taxonomy = $term_object->taxonomy;

							if( isset( $options['archive'][ $taxonomy ] ) ) {
								add_filter( 'nishiki_after_archive_header', function() use ( $options, $output ) { echo $output; }, 10 );
							}
						}

						if ( is_post_type_archive() ) {
							$post_type_archive = $term_object->name;

							if( isset( $options['archive'][ $post_type_archive ] ) ) {
								add_filter( 'nishiki_after_archive_header', function() use ( $options, $output ) { echo $output; }, 10 );
							}
						}

						if ( is_date() ) {
							$permalink_structure = get_option( 'permalink_structure' );

							if ( isset( $permalink_structure ) && $permalink_structure !== '' ) {
								if( is_year() ){
									if( isset( $options['archive']['year'] ) ) {
										add_filter( 'nishiki_after_archive_header', function() use ( $options, $output ) { echo $output; }, 10 );
									}
								}
								if( is_month() ){
									if( isset( $options['archive']['month'] ) ) {
										add_filter( 'nishiki_after_archive_header', function() use ( $options, $output ) { echo $output; }, 10 );
									}
								}
								if( is_day() ){
									if( isset( $options['archive']['day'] ) ) {
										add_filter( 'nishiki_after_archive_header', function() use ( $options, $output ) { echo $output; }, 10 );
									}
								}
							}
						}

						if ( is_author() ) {
							if( isset( $options['archive']['author'] ) ) {
								add_filter( 'nishiki_after_archive_header', function() use ( $options, $output ) { echo $output; }, 10 );
							}
						}
					}

					if ( is_404() ) {
						if( isset( $options['other']['404'] ) ) {
							add_filter( 'nishiki_after_404_header', function() use ( $options, $output ) { echo $output; }, 10 );
						}
					}

					if ( is_search() ) {
						if( isset( $options['other']['search'] ) ) {
							add_filter( 'nishiki_after_search_header', function() use ( $options, $output ) { echo $output; }, 10 );
						}
					}

					if ( is_front_page() || is_home() ) {
						if ( is_paged() ) {
							if( isset( $options['archive']['paged'] ) ) {
								add_filter( 'nishiki_after_archive_header', function() use ( $options, $output ) { echo $output; }, 10 );
							}
						}
					}

				}


				// Footer
				if ( isset( $options['display']['footer'] ) ) {
					if( is_singular() && ! is_front_page() ){
						$post_type  = $queried_object->post_type;

						if ( isset( $options['post_type'][ $post_type ] ) ) {
							add_filter( 'nishiki_before_site_footer', function() use ( $options, $output ) { echo $output; }, 10 );
						}
					}

					if ( is_archive() ) {
						$term_object = get_queried_object();

						if( is_category() || is_tag() || is_tax() ){
							$taxonomy = $term_object->taxonomy;

							if( isset( $options['archive'][ $taxonomy ] ) ) {
								add_filter( 'nishiki_before_site_footer', function() use ( $options, $output ) { echo $output; }, 10 );
							}
						}

						if ( is_post_type_archive() ) {
							$post_type_archive = $term_object->name;

							if( isset( $options['archive'][ $post_type_archive ] ) ) {
								add_filter( 'nishiki_before_site_footer', function() use ( $options, $output ) { echo $output; }, 10 );
							}
						}

						if ( is_date() ) {
							$permalink_structure = get_option( 'permalink_structure' );

							if ( isset( $permalink_structure ) && $permalink_structure !== '' ) {
								if( is_year() ){
									if( isset( $options['archive']['year'] ) ) {
										add_filter( 'nishiki_before_site_footer', function() use ( $options, $output ) { echo $output; }, 10 );
									}
								}
								if( is_month() ){
									if( isset( $options['archive']['month'] ) ) {
										add_filter( 'nishiki_before_site_footer', function() use ( $options, $output ) { echo $output; }, 10 );
									}
								}
								if( is_day() ){
									if( isset( $options['archive']['day'] ) ) {
										add_filter( 'nishiki_before_site_footer', function() use ( $options, $output ) { echo $output; }, 10 );
									}
								}
							}
						}

						if ( is_author() ) {
							if( isset( $options['archive']['author'] ) ) {
								add_filter( 'nishiki_before_site_footer', function() use ( $options, $output ) { echo $output; }, 10 );
							}
						}
					}

					if ( is_404() ) {
						if( isset( $options['other']['404'] ) ) {
							add_filter( 'nishiki_before_site_footer', function() use ( $options, $output ) { echo $output; }, 10 );
						}
					}

					if ( is_search() ) {
						if( isset( $options['other']['search'] ) ) {
							add_filter( 'nishiki_before_site_footer', function() use ( $options, $output ) { echo $output; }, 10 );
						}
					}

					if ( is_front_page() || is_home() ) {
						if ( is_paged() ) {
							if( isset( $options['archive']['paged'] ) ) {
								add_filter( 'nishiki_before_site_footer', function() use ( $options, $output ) { echo $output; }, 10 );
							}
						}
					}
				}

			}
		}

	}
}

$output = new NISHIKI_GB_BREADCRUMBS();
