<?php
// Init Customizer
if ( ! function_exists( 'nishiki_gb_breadcrumbs_customizer' ) ) {
	add_action( 'customize_register', 'nishiki_gb_breadcrumbs_customizer' );
	function nishiki_gb_breadcrumbs_customizer( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_GB_PREFIX_BREADCRUMBS, array(
				'title'     => __( 'パンくずリスト', 'nishiki_gb' ),
				'priority'  => 600,
				'panel'     => 'panel_' . NISHIKI_GB_PREFIX,
			)
		);

		// Text Color
		$wp_customize->add_setting('setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_text_color',array(
			'default' => '#333333',
			'sanitize_callback' => 'sanitize_hex_color',
		));

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_text_color',
				array(
					'label'      => __( 'Text Color', 'nishiki' ),
					'section'           =>  'section_' . NISHIKI_GB_PREFIX_BREADCRUMBS,
					'settings'          =>  'setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_text_color',
					'priority'=> 1040,
				)
			)
		);

		// Text Link Color
		$wp_customize->add_setting('setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_link_color',array(
			'default' => '#0a88cc',
			'sanitize_callback' => 'sanitize_hex_color',
		));

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_link_color',
				array(
					'label'      => __( 'Link Color', 'nishiki' ),
					'section'           =>  'section_' . NISHIKI_GB_PREFIX_BREADCRUMBS,
					'settings'          =>  'setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_link_color',
					'priority'=> 1040,
				)
			)
		);

		// Text Link Hover Color
		$wp_customize->add_setting('setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_link_hover_color',array(
			'default' => '#0044a3',
			'sanitize_callback' => 'sanitize_hex_color',
		));

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_link_hover_color',
				array(
					'label'      => __( 'Link Hover Color', 'nishiki' ),
					'section'           =>  'section_' . NISHIKI_GB_PREFIX_BREADCRUMBS,
					'settings'          =>  'setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_link_hover_color',
					'priority'=> 1040,
				)
			)
		);

		// Background Color
		$wp_customize->add_setting('setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_background_color',array(
			'default' => '',
			'sanitize_callback' => 'sanitize_hex_color',
		));

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_background_color',
				array(
					'label'      => __( 'Background Color', 'nishiki' ),
					'section'           =>  'section_' . NISHIKI_GB_PREFIX_BREADCRUMBS,
					'settings'          =>  'setting_' . NISHIKI_GB_PREFIX_BREADCRUMBS . '_background_color',
					'priority'=> 1030,
				)
			)
		);
	}
}


