<?php
// Define Prefix.
if ( ! defined( 'NISHIKI_GB_PREFIX' ) ) {
	define( 'NISHIKI_GB_PREFIX', 'nishiki_gb' );
}

// Define General Prefix.
if ( ! defined( 'NISHIKI_GB_PREFIX_BREADCRUMBS' ) ) {
	define( 'NISHIKI_GB_PREFIX_BREADCRUMBS', NISHIKI_GB_PREFIX . '_breadcrumbs' );
}
// Define Theme Support Prefix.
if ( ! defined( 'NISHIKI_GB_PREFIX_SUPPORT' ) ) {
	define( 'NISHIKI_GB_PREFIX_SUPPORT', NISHIKI_GB_PREFIX . '_support' );
}

// Define Extension Prefix.
if ( ! defined( 'NISHIKI_GB_PREFIX_META' ) ) {
	define( 'NISHIKI_GB_PREFIX_META', NISHIKI_GB_PREFIX . '_meta' );
}
if ( ! defined( 'NISHIKI_GB_PREFIX_SHARE' ) ) {
	define( 'NISHIKI_GB_PREFIX_SHARE', NISHIKI_GB_PREFIX . '_share' );
}
if ( ! defined( 'NISHIKI_GB_PREFIX_ACCOUNT' ) ) {
	define( 'NISHIKI_GB_PREFIX_ACCOUNT', NISHIKI_GB_PREFIX . '_account' );
}
if ( ! defined( 'NISHIKI_GB_PREFIX_SOCIAL' ) ) {
	define( 'NISHIKI_GB_PREFIX_SOCIAL', NISHIKI_GB_PREFIX . '_social' );
}
if ( ! defined( 'NISHIKI_GB_PREFIX_ANALYTICS' ) ) {
	define( 'NISHIKI_GB_PREFIX_ANALYTICS', NISHIKI_GB_PREFIX . '_analytics' );
}
if ( ! defined( 'NISHIKI_GB_PREFIX_CONTENT' ) ) {
	define( 'NISHIKI_GB_PREFIX_CONTENT', NISHIKI_GB_PREFIX . '_content' );
}

// Plugin Active.
if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
	require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
}

// plugin directory root.
if ( ! function_exists( 'nishiki_gb_plugin_dir_root' ) ) {
	function nishiki_gb_plugin_dir_root() {
		return plugin_dir_url( __FILE__ );
	}
}

// 公開OKな投稿タイプ名を全取得.
if ( ! function_exists( 'nishiki_gb_get_all_post_types' ) ) {
	function nishiki_gb_get_all_post_types() {

		$args = array(
			'public'   => true, //公開している投稿タイプは表示
			'_builtin' => false, //デフォルトの投稿タイプは非表示
		);

		$output = 'names'; // 「names」で投稿タイプ名を指定
		$operator = 'and'; // 「and」で$argsの条件にどちらも合致するものだけ指定

		$post_types = get_post_types( $args, $output, $operator ); //条件に合った投稿タイプ名を配列で取得

		$post_types_array = array( 'post', 'page' );
		foreach ( $post_types  as $post_type ) { //取得した配列をループさせる
			$post_types_array[] = $post_type; //投稿タイプ名を表示
		}

		return $post_types_array;
	}
}

// Customizer Controll JS
add_action( 'customize_controls_enqueue_scripts', 'nishiki_gb_panels_js', 99 );
function nishiki_gb_panels_js() {
	wp_enqueue_script( 'nishiki-gb-customize-controls', nishiki_gb_plugin_dir_root() . '/customizer/assets/js/customize-controls.js', array(), '1.0', true );
}

// Customizer Init.
require_once 'class/auth/class-auth.php';

// Active Plugin.
$nishiki_gb_extension_active = new NISHIKI_GB_EXTENSION_ACTIVE();
$nishiki_gb_extension_active->response();

// Update Check
require_once 'updatechecker/update.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'https://support.animagate.com/wp/packages/nishiki-gb/nishiki-growing-beauty.json',
	plugin_dir_path( __FILE__ ) . 'nishiki-growing-beauty.php',
	'Nishiki Growing Beauty'
);
