<?php
if ( ! class_exists( 'NISHIKI_GB_PLUGIN_REMOTE_CHECK' ) ) {
	class NISHIKI_GB_PLUGIN_REMOTE_CHECK {
		private $network_url = 'https://support.animagate.com/wp/';
		private $base_file = 'nishiki_gb_reg_callback.php';

		// Remote Check.
		public function remote_check( $args ) {
			$args = array(
				'product'         => $args['product'],
				'extension'       => $args['extension'],
				'site_url'        => rawurlencode( $args['site_url'] ),
				'key'							=> $args['key'],
			);

			$target_url = $this->network_url . $this->base_file . '?' . http_build_query( $args );
			$request = wp_safe_remote_get(
				$target_url, array(
					'sslverify' => false,
				)
			);

			// echo $target_url;
			if ( isset( $request ) && ! empty( $request ) && ! is_wp_error( $request ) && $request['response']['code'] === 200 ) {
				return true;
			} else {
				return false;
			}

		}
	}
}

if ( ! class_exists( 'NISHIKI_GB_EXTENSION_ACTIVE' ) ) {
	class NISHIKI_GB_EXTENSION_ACTIVE {
		// Check Extension
		private function active_plugin( $extension ) {
			$plugin_file = 'nishiki-gb-' . $extension . '/nishiki-gb-' . $extension . '.php';
			$reg_key_data = get_option( 'nishiki_gb_' . $extension );
			$activate = isset( $reg_key_data['activate'] ) ? $reg_key_data['activate'] : '';
			$reg_key = isset( $reg_key_data['reg_key'] ) ? $reg_key_data['reg_key'] : '';
			if ( is_plugin_active( $plugin_file ) ) {
//			if ( is_plugin_active( $plugin_file ) && $activate === true && isset( $activate ) && isset( $reg_key ) ) {
				require_once WP_PLUGIN_DIR . '/nishiki-gb-' . $extension . '/customizer/add_' . $extension . '.php';
			} else {
				return false;
			}
		}

		public function response() {
			$extensions = array( 'share', 'social', 'analytics', 'meta', 'content' );
			foreach ( $extensions as $extension ) {
				$this->active_plugin( $extension );
			}
		}
	}
}
