<?php
if ( ! class_exists( 'NISHIKI_GB_SCRIPT' ) ) {
	/**
	 * Create Code.
	 */
	class NISHIKI_GB_SCRIPT extends NISHIKI_GB_GENERAL_UTILITY {

		/**
		 * Constructor.
		 *
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_gb_register_settings' ), 20 );

			// スクリプト追加
			$page_name = $this->plugin_name . '_script';
			$this->script( $page_name );
		}

		/**
		 * フォームの設定(基本)
		 */
		public function nishiki_gb_register_settings() {
			$page_name = $this->plugin_name . '_script';

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				__( '', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_general_cb' ),
				$page_name
			);

			add_settings_field(
				'enable',
				__( '出力を有効にする', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_checkbox_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '有効化',
					'label' => 'enable',
					'page_name' => $page_name,
					'description' => '',
				)
			);

			add_settings_field(
				'header',
				__( 'ヘッダーに JavaScript を追加', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_textarea_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '',
					'label' => 'header',
					'page_name' => $page_name,
					'description' => '出力の優先順位（デフォルト：10）1 〜 999 の範囲で設定。数字が小さいほど実行の優先度が高いです',
				)
			);

			add_settings_field(
				'footer',
				__( 'フッターに JavaScript を追加', 'nishiki_gb' ),
				array( $this, 'nishiki_gb_textarea_cb' ),
				$page_name,
				$page_name,
				array(
					'title' => '',
					'label' => 'footer',
					'page_name' => $page_name,
					'description' => '出力の優先順位（デフォルト：10）1 〜 999 の範囲で設定。数字が小さいほど実行の優先度が高いです',
				)
			);
		}

		/**
		 * スクリプト出力
		 */
		public function script( $page_name ) {
			$options = get_option( $page_name );

			if ( ! empty( $options ) && ! empty( $options['enable'] ) ) {
				if ( ! empty( $options['header'] ) ) {
					add_action( 'wp_head', function() use ( $options ) {
						echo $options['header'];
					}, $options['header_priority'] );
				}

				if ( ! empty( $options['footer'] ) ) {
					add_action( 'wp_footer', function() use ( $options ) {
						echo $options['footer'];
					}, $options['footer_priority']);
				}
			}
		}


		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			// チェックボックス
			if ( isset( $input['enable'] ) ) {
				$new_input['enable'] = absint( $input['enable'] );
			}

			// テキスト
			if ( isset( $input['header'] ) ) {
//				$new_input['header'] = base64_encode( stripslashes( $input['header'] ) );
				$new_input['header'] = $input['header'];
			}

			// テキスト
			if ( isset( $input['header_priority'] ) ) {
				$new_input['header_priority'] = absint( $input['header_priority'] );
			}

			// テキスト
			if ( isset( $input['footer'] ) ) {
				$new_input['footer'] = $input['footer'];
			}

			// テキスト
			if ( isset( $input['footer_priority'] ) ) {
				$new_input['footer_priority'] = absint( $input['footer_priority'] );
			}

			// wp_die(var_dump($new_input));
			return $new_input;
		}


	}
}

$output = new NISHIKI_GB_SCRIPT();
