<?php
if ( ! class_exists( 'NISHIKI_GB_GENERAL' ) ) {
	class NISHIKI_GB_GENERAL extends NISHIKI_GB_GENERAL_UTILITY {
		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'nishiki_gb_gerenal_menu' ), 10 );
		}

		/**
		 * サブメニュー追加
		 */
		public function nishiki_gb_gerenal_menu() {
			add_submenu_page(
				'nishiki-gb.php',
				'一般設定',
				'一般設定',
				'manage_options',
				'nishiki-gb-general.php',
				array( $this, 'nishiki_gb_general_page' )
			);
		}

	  public $tab_array = array(
		  'profile'    => 'プロフィール',
		  'script'    => 'スクリプト追加',
		  'optimize'    => 'テーマ最適化',
		  'breadcrumbs'    => 'パンくずリスト',
	  );

	  /**
	   * タブ出力
	   */
	  public function create_tab() {
		  $admin_url = 'admin.php?page=nishiki-gb-general.php';
		  $flag       = false;
		  $tab_array = $this->tab_array;

		  echo '<div class="nav-tab-wrapper">';
		  foreach ( $tab_array as $key => $val ) {
			  $active = '';
			  if ( ! isset( $_GET['action'] ) && $flag === false ) {
				  $active = ' nav-tab-active';
				  $flag = 1;
			  } elseif ( isset( $_GET['action'] ) && $key === $_GET['action'] && $flag === false ) {
				  $active = ' nav-tab-active';
			  }
			  echo '<a href="' . esc_url(
					  add_query_arg(
						  array(
							  'action' => $key,
						  ), $admin_url
					  )
				  ) . '" class="nav-tab' . $active . '">' . $val . '</a>';
		  }

		  echo '</div>';
	  }

	  /**
	   * 設定画面出力
	   */
	  public function create_setting() {
		  $tab_array = $this->tab_array;
		  $flag = false;

		  foreach ( $tab_array as $key => $val ) {
			  if ( ! isset( $_GET['action'] ) && $flag === false ) {
				  $flag = true;
			  } elseif ( isset( $_GET['action'] ) && $key === $_GET['action'] && $flag === false ) {
				  $flag = true;
			  }

			  if ( $flag === true ) {
				  settings_fields( $this->plugin_name . '_' . $key );
				  do_settings_sections( $this->plugin_name . '_' . $key );

		    	submit_button();

				  break;
			  }
		  }
	  }

	  /**
		 * オプションページの内容
		 */
		public function nishiki_gb_general_page() {
			$this->options = get_option( $this->plugin_name );
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( __( 'このページを表示する権限がありません。' ) );
			}
			?>
			<div class="wrap">
				<h1>一般設定</h1>
				<?php $this->create_tab(); ?>
				<form method="post" action="options.php">
					<?php $this->create_setting(); ?>
				</form>
			</div>
			<?php
		}
	}

	if ( is_admin() ) {
		$output = new NISHIKI_GB_GENERAL();
	}
}
