<?php
if ( ! class_exists( 'NISHIKI_GB_NOTIFICATION' ) ) {
	/**
	 * Create NOTIFICATION.
	 */
	class NISHIKI_GB_NOTIFICATION {

		/**
		 * Constructor.
		 *
		 * 初期設定
		 */
		public function __construct() {
			add_action( 'admin_init', array( $this, 'nishiki_gb_notification_dismissed' ) );
			add_action( 'admin_notices', array( $this, 'nishiki_gb_notification' ) );
		}

		/**
		 * Check Nishiki Setting.
		 *
		 * 設定チェック
		 */

		//閉じたフラグがあるかチェックして、なければ表示。閉じたフラグは一定期間で消える仕組みにする。
		//閉じるボタンを押したらupdate_option 1日
		//1日すぎたら再度表示
		public function nishiki_setting_notification($user_id) {
			echo '<div class="notice notice-warning nishiki-pro-info">';
			echo '<h3>Nishiki Pro テーマをおすすめします</h3>';
			echo '<p>ワードプレス プラグインの入れすぎで、管理や運用が煩雑になっていませんか？</p>';
			echo '<p>「ウェブサイト運営に欠かせない機能」がまとめて搭載されている Nishiki Pro テーマをご利用ください。プラグインの導入・選定・アップデートにかかる時間的・技術的コストを大幅に削減でき、コンテンツ作成に集中できます。</p>';
			echo '<p><strong>「ワードプレスのカスタマイズにかける時間的コストは少ない方がいい」</strong>と開発者は考えています。</p>';
			echo '<h3>Nishiki Pro テーマで使える機能（一部）</h3>';
			echo '<ul>';
			echo '<li><a class="button" href="https://support.animagate.com/manual/list/wp-nishiki-pro-gutenberg/" target="_blank">コードを書かずに簡単にコンテンツ作成ができる！「Nishiki Blocks Pro」</a></li>';
			echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-share-function/" target="_blank">シェアボタン</a></li>';
			echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-meta-function/" target="_blank">OGP</a></li>';
			echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-heading-style/" target="_blank">見出しデザイン</a></li>';
			echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-pro-gutenberg-marker/" target="_blank">マーカー</a></li>';
			echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-page-template/" target="_blank">LP 作成用テンプレート</a></li>';
			echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-header-layout/" target="_blank">ヘッダーレイアウト</a></li>';
			echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-multiple-search/" target="_blank">絞り込み検索</a></li>';
			echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-table-of-contents/" target="_blank">目次</a></li>';
			echo '<li><a class="button" href="https://support.animagate.com/manual/wp-nishiki-campaign-link/" target="_blank">キャンペーンリンク</a></li>';
			echo '</ul>';
			echo '<p>Nishiki Pro のご利用を検討いただく方へ向けて、お試し版を配布しています。</p>';
			echo '<p><a class="button button-primary" href="https://support.animagate.com/manual/wp-nishiki-pro-trial-download/" target="_blank">Nishiki Pro お試し版（無料）はこちら</a></p>';
			echo '<p>※ Nishiki Pro をご利用の方は Nishiki Growing Beauty プラグインは不要になりますので、停止・削除ください。</p>';
			/*
			if( ! get_user_meta( $user_id, 'nishiki_gb_notification_dismissed' ) ){
				echo '<p style="text-align: right;"><a href="' . esc_url( admin_url('?nishiki-gb-notification-dismissed') ) . '">非表示にする</a></p>';
			}
			*/
			echo '</div>';
		}

		public function nishiki_gb_notification() {
			$screen = get_current_screen();
			$user_id = get_current_user_id();
			$this->nishiki_setting_notification($user_id);
			/*
			if ( ! get_user_meta( $user_id, 'nishiki_gb_notification_dismissed' ) || 'nishiki-gb' === $screen->parent_base ) {
				$this->nishiki_setting_notification($user_id);
			}
			*/
		}

		public function nishiki_gb_notification_dismissed() {
			$user_id = get_current_user_id();
			if ( isset( $_GET['nishiki-gb-notification-dismissed'] ) ) {
				add_user_meta( $user_id, 'nishiki_gb_notification_dismissed', 'true', true );
			}
		}

	}
}

$output = new NISHIKI_GB_NOTIFICATION();
