<?php
if ( ! class_exists( 'NISHIKI_GB_GENERAL_UTILITY_FORM' ) ) {
	class NISHIKI_GB_GENERAL_UTILITY_FORM {
		/**
		 * フォーム作成（チェックボックス一つ）
		 */
		public function create_form_checkbox( $title = '', $label, $page_name ) {
			$options = get_option( $page_name );
			$label_name = $page_name . '_' . $label;

			if ( isset( $options[$label] ) ) {
				$checked = ' checked="checked"';
			} else {
				$checked = '';
			}

			echo '<p><input type="checkbox" id="' . esc_attr( $label_name ) . '" name="' .  esc_attr( $page_name ) . '[' . esc_attr( $label ). ']" value="1"' . esc_attr( $checked ) . '><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></p>';
		}

		/**
		 * フォーム作成（チェックボックス複数）
		 */
		public function create_form_checkbox_multiple( $title = '', $label, $page_name, $script ) {
			$options = get_option( $page_name );

			echo '<ul>';
			foreach ( $script as $key => $title ) {
				$checked = '';
				if ( isset( $options[ $label ] ) ) {
					if ( array_key_exists( $key, $options[ $label ] ) ) {
						$checked = ' checked="checked"';
					}
				}
				$label_name = $label . '_' . $key;

				echo '<li><input type="checkbox" id="' . esc_attr( $label_name ) . '" name="' .  esc_attr( $page_name ) . '[' . esc_attr( $label ). '][' . esc_attr( $key ) . ']" value="1"' . esc_attr( $checked ) . '><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '（' . esc_html( $key ) . '）</label></li>';
			}
			echo '</ul>';
		}

		/**
		 * フォーム作成（テキスト）
		 */
		public function create_form_text( $title, $label, $page_name, $placeholder = '' ) {
			$options = get_option( $page_name );
			$label_name = $page_name . '_' . $label;

			if ( isset( $options[ $label ] ) ) {
				$data = $options[ $label ];
			} else {
				$data = '';
			}

			if ( ! empty( $title ) ) {
				echo '<h4><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></h4>';
			}
			echo '<p><input placeholder="' . esc_attr( $placeholder ) . '" type="text" id="' . esc_attr( $label_name ) . '" name="' .  esc_attr( $page_name ) . '[' . esc_attr( $label ). ']" value="' . esc_attr( $data ) . '" /></p>';
		}

		/**
		 * フォーム作成（テキストエリア）
		 */
		public function create_form_textarea( $title = '', $label, $page_name ) {
			$options = get_option( $page_name );

			$data = '';
			$priority_data = 10;
			$label_name = $page_name . '_' . $label;
			$priority = $label . '_priority';

			if ( isset( $options[ $label ] ) ) {
				$data = $options[ $label ];
			}

			if ( isset( $options[ $priority ] ) ) {
				$priority_data = $options[ $priority ];
			}

			if ( ! empty( $title ) ) {
				echo '<h4><label for="' . esc_attr( $label_name ) . '">' . esc_html( $title ) . '</label></h4>';
			}

			echo '<p><textarea rows="10" cols="10" class="large-text code" id="' . esc_attr( $label ) . '" name="' .  esc_attr( $page_name ) . '[' . esc_attr( $label ). ']" value="' . esc_attr( $data ) . '" />' . esc_textarea( $data ) . '</textarea></p>';

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
			echo '<input type="number" name="' .  esc_attr( $page_name ) . '[' . esc_attr( $priority ) . ']" value="' . absint( $priority_data ) . '">';
		}
	}
}
