<?php
/**
 * アーカイブ ページ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

get_header(); ?>
	<main id="main" class="site-main" role="main" <?php do_action( 'nishiki_pro_main_attributes' ); ?>>
		<?php do_action( 'nishiki_pro_before_archive_header' ); ?>
		<header<?php echo wp_kses_post( apply_filters( 'nishiki_pro_page_header_attributes', '' ) ); ?>>
			<div class="page-header-inner container">
		<?php do_action( 'nishiki_pro_before_archive_title' ); ?>
		<?php if ( is_post_type_archive() ) { ?>
			<h1><?php post_type_archive_title(); ?></h1>
		<?php } else {
			the_archive_title( '<h1>', '</h1>' );
		}
		?>
		<?php do_action( 'nishiki_pro_after_archive_title' ); ?>
		<?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
			</div>
		</header>
		<?php do_action( 'nishiki_pro_after_archive_header' ); ?>
		<?php do_action( 'nishiki_pro_before_archive_container' ); ?>
		<div class="container column">
		<?php
			do_action( 'nishiki_pro_before_archive_inner_container' );
			nishiki_pro_get_template_part( 'parts/archive/content' );
			do_action( 'nishiki_pro_sidebar' );
			do_action( 'nishiki_pro_after_archive_inner_container' );
		?>
		</div>
		<?php do_action( 'nishiki_pro_after_archive_container' ); ?>
	</main>
<?php
get_footer();
