<?php
if ( ! class_exists( 'NISHIKI_BLOCKS_PRO_CARD' ) ) {
	/**
	 * カードブロックの設定
	 */
	class NISHIKI_BLOCKS_PRO_CARD {
		/**
		 * Construct.
		 */
		public function __construct() {
			add_filter( 'register_block_type_args', array( $this, 'custom_modify_block_args' ), 10, 2 );
		}

		/**
		 * ダイナミックブロックうに関する設定を追加
		 */
		public function custom_modify_block_args( $args, $block_type ) {
			$attributes = array(
							'cardUrl'  => array(
								'type'    => 'string',
								'default' => '',
							),
							'cardTarget'               => array(
								'type'    => 'boolean',
								'default' => false,
							),
							'cardBackgroundColor'      => array(
								'type'    => 'string',
								'default' => '#ffffff',
							),
							'cardBorderColor'          => array(
								'type'    => 'string',
								'default' => '#cccccc',
							),
							'cardTextMainColor'        => array(
								'type'    => 'string',
								'default' => '#444444',
							),
							'cardTextSubColor'         => array(
								'type'    => 'string',
								'default' => '#aaaaaa',
							),
							'cardImageAlign'           => array(
								'type'    => 'string',
								'default' => 'card-image-left',
							),
							'cardImageAlt'             => array(
								'type'    => 'string',
								'default' => '',
							),
							'cardLabel'                => array(
								'type'    => 'string',
								'default' => '',
							),
							'cardLabelBackgroundColor' => array(
								'type'    => 'string',
								'default' => '#222222',
							),
							'cardLabelTextColor'       => array(
								'type'    => 'string',
								'default' => '#ffffff',
							),
							'cardLayout'               => array(
								'type'    => 'string',
								'default' => 'horizontal',
							),
							'cardAspectRatio'          => array(
								'type'    => 'string',
								'default' => '',
							),
							'cardTitleEllipsis'        => array(
								'type'    => 'string',
								'default' => '',
							),
							'cardDescEllipsis'         => array(
								'type'    => 'string',
								'default' => '',
							),
							'cardMargin'               => array(
								'type'    => 'boolean',
								'default' => true,
							),
							'cardDescription'          => array(
								'type'    => 'boolean',
								'default' => true,
							),
							'cardDomain'               => array(
								'type'    => 'boolean',
								'default' => true,
							),
						);

			if ( 'nishiki-blocks-pro/card' === $block_type ) {
				$args['attributes'] = $attributes;
				$args['render_callback'] = array( $this, 'sc_render' );
			}

			return $args;
		}

		/**
		 * ダイナミックブロック登録
		 *
		 * @return void
		 */
		public function register_dynamic_block() {
			register_block_type(
				'nishiki-blocks-pro/card',
				array(
					'attributes'      => array(
						'cardUrl'                  => array(
							'type'    => 'string',
							'default' => '',
						),
						'cardTarget'               => array(
							'type'    => 'boolean',
							'default' => false,
						),
						'cardBackgroundColor'      => array(
							'type'    => 'string',
							'default' => '#ffffff',
						),
						'cardBorderColor'          => array(
							'type'    => 'string',
							'default' => '#cccccc',
						),
						'cardTextMainColor'        => array(
							'type'    => 'string',
							'default' => '#444444',
						),
						'cardTextSubColor'         => array(
							'type'    => 'string',
							'default' => '#aaaaaa',
						),
						'cardImageAlign'           => array(
							'type'    => 'string',
							'default' => 'card-image-left',
						),
						'cardImageAlt'             => array(
							'type'    => 'string',
							'default' => '',
						),
						'cardLabel'                => array(
							'type'    => 'string',
							'default' => '',
						),
						'cardLabelBackgroundColor' => array(
							'type'    => 'string',
							'default' => '#222222',
						),
						'cardLabelTextColor'       => array(
							'type'    => 'string',
							'default' => '#ffffff',
						),
						'cardLayout'               => array(
							'type'    => 'string',
							'default' => 'horizontal',
						),
						'cardAspectRatio'          => array(
							'type'    => 'string',
							'default' => '',
						),
						'cardTitleEllipsis'        => array(
							'type'    => 'string',
							'default' => '',
						),
						'cardDescEllipsis'         => array(
							'type'    => 'string',
							'default' => '',
						),
						'cardMargin'               => array(
							'type'    => 'boolean',
							'default' => true,
						),
						'cardDescription'          => array(
							'type'    => 'boolean',
							'default' => true,
						),
						'cardDomain'               => array(
							'type'    => 'boolean',
							'default' => true,
						),
					),
					'render_callback' => array( $this, 'sc_render' ),
					'supports'        => array(
						'spacing' => array(
							'margin'  => true,
						),
					),
				)
			);
		}

		/**
		 * ショートコード作成
		 *
		 * @param array $attributes 属性
		 * @return $card
		 */
		public function sc_render( $attributes, $content ) {
			$atts = shortcode_atts(
				array(
					'cardUrl'                  => '',
					'cardTarget'               => false,
					'cardBackgroundColor'      => '',
					'cardBorderColor'          => '',
					'cardTextMainColor'        => '',
					'cardTextSubColor'         => '',
					'cardImageAlign'           => '',
					'cardImageAlt'             => '',
					'cardLabel'                => '',
					'cardLabelBackgroundColor' => '',
					'cardLabelTextColor'       => '',
					'cardLayout'               => '',
				),
				$attributes
			);

			$card = '';

			if ( ! empty( $attributes['cardUrl'] ) ) {
				$get_post_id = url_to_postid( $attributes['cardUrl'] );

				if ( 0 !== $get_post_id ) {
					$card = $this->get_internal_post( $get_post_id, $attributes );
				} else {
					$card = $this->get_external_post( $attributes );
				}
			}

			return $card;
		}

		/**
		 * 内部リンク
		 *
		 * @param int   $post_id 投稿 ID
		 * @param array $attributes 属性
		 * @return $output
		 */
		public function get_internal_post( $post_id, $attributes ) {
			setup_postdata( $post_id );

			$desc        = '';
			$domain_name = '';
			$classes     = [];
			$css         = '';
			$class_name  = '';

			$domain = ! empty( $_SERVER['SERVER_NAME'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_NAME'] ) ) : getenv( 'SERVER_NAME' );

			if ( ! empty( $attributes['cardDomain'] ) && $domain ) {
				$domain_name = '<span class="card-domain" style="color:' . $attributes['cardTextSubColor'] . ';">' . $domain . '</span>';
			}

			if ( get_post_field( 'post_excerpt', $post_id ) ) {
				$excerpt = trim( get_post_field( 'post_excerpt', $post_id ) );
			} else {
				$excerpt = wp_trim_words( get_post_field( 'post_content', $post_id ), 50 );
			}

			if ( ! empty( $attributes['cardLabel'] ) ) {
				$classes[] = 'has-card-label';
				$label       = '<span class="card-label" style="background-color:' . $attributes['cardLabelBackgroundColor'] . '; color:' . $attributes['cardLabelTextColor'] . ';">' . $attributes['cardLabel'] . '</span>';
			} else {
				$label       = '';
			}

			if ( ! empty( $attributes['cardTarget'] ) ) {
				$target = ' target="_blank" rel="noopener noreferrer"';
			} else {
				$target = '';
			}

			// Margin
			if ( $attributes['cardMargin'] ) {
				$classes[] = 'has-margin';
			}

			// Title Ellipsis
			if ( ! empty( $attributes['cardTitleEllipsis'] ) ) {
				$classes[]		= 'has-title-ellipsis';
				$title_ellipsis = ' title-ellipsis-' . $attributes['cardTitleEllipsis'];
			} else {
				$title_ellipsis = '';
			}

			// Desc Ellipsis
			if ( ! empty( $attributes['cardDescEllipsis'] ) ) {
				$classes[]     = 'has-desc-ellipsis';
				$desc_ellipsis = ' desc-ellipsis-' . $attributes['cardDescEllipsis'];
			} else {
				$desc_ellipsis = '';
			}

			// AspectRatio
			if ( ! empty( $attributes['cardAspectRatio'] ) && 'vertical' === $attributes['cardLayout'] ) {
				$classes[]	  = 'has-aspect-ratio';
				$aspect_ratio = ' aspect-ratio-' . $attributes['cardAspectRatio'];
			} else {
				$aspect_ratio = '';
			}

			// クラス名
			if ( ! empty( $attributes['className'] ) ) {
				$classes[] = $attributes['className'];
			}

			$title = '<span class="card-title' . $title_ellipsis . '" style="color:' . $attributes['cardTextMainColor'] . ';">' . get_the_title( $post_id ) . '</span>';

			if ( ! empty( $attributes['cardDescription'] ) ) {
				$desc = '<span class="card-desc' . $desc_ellipsis . '" style="color:' . $attributes['cardTextMainColor'] . ';">' . $excerpt . '</span>';
			}

			if ( get_the_post_thumbnail( $post_id ) !== '' ) {
				$image = '<div class="card-image' . $aspect_ratio . '">' . get_the_post_thumbnail( $post_id, 'post-thumbnail', array( 'alt' => get_the_title( $post_id ) ) ) . '</div>';
			} else {
				$image = '';
			}

			$text = '<div class="card-text">' . $title . $desc . $domain_name . '</div>';

			$classes[] = $attributes['cardImageAlign'];
			$classes[] = $attributes['cardLayout'];

			// インライン CSS を追加		
			if ( ! empty( $attributes['style'] ) ){
				$style = wp_style_engine_get_styles( $attributes['style'] );
				$css = $style['css'];
			}

			$wrapper_attributes = get_block_wrapper_attributes( 
				array( 
					'class' => trim( implode( ' ', $classes ) ),
					'style' => $css,
				)
			);

//			$output = '<div class="wp-block-nishiki-blocks-pro-card ' . esc_attr( $attributes['cardImageAlign'] . $margin_class . $label_class . $aspect_ratio_class . $title_ellipsis_class . $desc_ellipsis_class . $class_name . ' ' . $attributes['cardLayout'] ) . '"><a class="nishiki-pro-card-inner"' . wp_kses_post( $target ) . ' href="' . esc_url( get_permalink( $post_id ) ) . '" style="border-color:' . esc_attr( $attributes['cardBorderColor'] ) . '; background-color:' . esc_attr( $attributes['cardBackgroundColor'] ) . ';">' . wp_kses_post( $label . $image . $text ) . '</a></div>';
			$output = '<div ' . wp_kses_post( $wrapper_attributes ) . '>';
			$output .= '<a class="nishiki-pro-card-inner"' . wp_kses_post( $target ) . ' href="' . esc_url( get_permalink( $post_id ) ) . '" style="border-color:' . esc_attr( $attributes['cardBorderColor'] ) . '; background-color:' . esc_attr( $attributes['cardBackgroundColor'] ) . ';">';
			$output .= wp_kses_post( $label . $image . $text );
			$output .= '</a></div>';

			wp_reset_postdata();

			return $output;
		}

		/**
		 * 外部リンク
		 *
		 * @param array $attributes 属性
		 * @return $output
		 */
		public function get_external_post( $attributes ) {
			// delete_transient('nishiki_pro_card_' . $attributes['cardUrl'] . '_' . get_the_ID());
			$card_data = get_transient( 'nishiki_pro_card_' . $attributes['cardUrl'] . '_' . get_the_ID() );

			if ( false === $card_data ) {
				$request = wp_remote_get(
					$attributes['cardUrl'],
					array(
						'user-agent' => '',
					)
				);

				if ( isset( $request ) && ! empty( $request ) && ! is_wp_error( $request ) && 200 === $request['response']['code'] ) {

					$domain = wp_parse_url( $attributes['cardUrl'] );

					// Charset
					/* if ( preg_match( '/<meta.+?charset.*?=.*?["\'](.+)[ "\'].*?\/?>/i', $request['body'], $matches ) ) { */
					if ( preg_match( '/.+?charset=(.+)/i', $request['headers']['content-type'], $matches ) ) {
						if ( $matches[1] ) {
							$charset = $matches[1];
						} else {
							$charset = '';
						}
					}
					if ( $domain ) {
						// $favicon = '<img class="card-favicon" src="https://www.google.com/s2/favicons?domain=' . $domain['host'] . '">';
						// $domain_name = '<span class="card-domain" style="color:' . $attributes['cardTextSubColor'] . ';">' . $favicon . $domain['host'] . '</span>';
						$domain = $domain['host'];
					} else {
						$domain = '';
					}

					// Image
					if ( preg_match( '/<meta.+?(property|name)=["\'](og:image|twitter:image)["\'][^\/>]*?content=["\']([^"\']+?)["\'].*?\/?>/is', $request['body'], $matches ) ) {
						if ( $matches[3] ) {
							$thumbnail = $matches[3];
						} else {
							$thumbnail = $this->get_content_image( $request['body'] );
						}
					} else {
						$thumbnail = $this->get_content_image( $request['body'] );
					}

					// Title
					if ( preg_match( '/<title.*?>(.+?)<\/title>/is', $request['body'], $matches ) ) {
						if ( ! empty( $charset ) && mb_detect_encoding( $charset, 'UTF-8' ) ) {
							$title = mb_convert_encoding( $matches[1], 'UTF-8', $charset );
						} else {
							$title = $matches[1];
						}
					} else {
						$title = '';
					}

					//var_dump($title);

					// Description
					if ( preg_match( '/<meta.+?name=["\']description["\'][^\/>]*?content=["\']([^"\']+?)["\'].*?\/?>/is', $request['body'], $matches ) ) {

						if ( ! empty( $charset ) && mb_detect_encoding( $charset, 'UTF-8' ) ) {
							$desc = mb_convert_encoding( $matches[1], 'UTF-8', $charset );
						} else {
							$desc = $matches[1];
						}
					} else {
						$desc = '';
					}

					$card_data = array(
						'title'     => $title,
						'desc'      => $desc,
						'domain'    => $domain,
						'thumbnail' => $thumbnail,
					);

					set_transient( 'nishiki_pro_card_' . $attributes['cardUrl'] . '_' . get_the_ID(), $card_data, 60 * 60 * 24 * 10 );
				}
			}

			if ( ! empty( $card_data ) ) {
				$desc        = '';
				$domain_name = '';
				$classes     = [];
				$css         = '';
				$class_name  = '';

				if ( ! empty( $attributes['cardLabel'] ) ) {
					$label       = '<span class="card-label" style="background-color:' . $attributes['cardLabelBackgroundColor'] . '; color:' . $attributes['cardLabelTextColor'] . ';">' . $attributes['cardLabel'] . '</span>';
					$classes[]   = 'has-card-label';
				} else {
					$label       = '';
				}

				if ( ! empty( $attributes['cardTarget'] ) ) {
					$target = ' target="_blank" rel="noopener noreferrer"';
				} else {
					$target = '';
				}

				// Margin
				if ( $attributes['cardMargin'] ) {
					$classes[] = 'has-margin';
				}

				// Title Ellipsis
				if ( ! empty( $attributes['cardTitleEllipsis'] ) ) {
					$classes[]      = 'has-title-ellipsis';
					$title_ellipsis = ' title-ellipsis-' . $attributes['cardTitleEllipsis'];
				} else {
					$title_ellipsis = '';
				}

				// Desc Ellipsis
				if ( ! empty( $attributes['cardDescEllipsis'] ) ) {
					$classes[]     = 'has-desc-ellipsis';
					$desc_ellipsis = ' desc-ellipsis-' . $attributes['cardDescEllipsis'];
				} else {
					$desc_ellipsis       = '';
				}

				// AspectRatio
				if ( ! empty( $attributes['cardAspectRatio'] ) && 'vertical' === $attributes['cardLayout'] ) {
					$classes[]    = 'has-aspect-ratio';
					$aspect_ratio = ' aspect-ratio-' . $attributes['cardAspectRatio'];
				} else {
					$aspect_ratio       = '';
				}

				// クラス名
				if ( ! empty( $attributes['className'] ) ) {
					$classes[] = $attributes['className'];
				}

				// Align
				if ( ! empty( $attributes['align'] ) ) {
					$classes[] = 'align' . $attributes['align'];
				}

				$title = '<span class="card-title' . $title_ellipsis . '" style="color:' . $attributes['cardTextMainColor'] . ';">' . $card_data['title'] . '</span>';
				if ( ! empty( $attributes['cardDescription'] ) && '' !== $card_data['desc'] ) {
					$desc = '<span class="card-desc' . $desc_ellipsis . '" style="color:' . $attributes['cardTextMainColor'] . ';">' . $card_data['desc'] . '</span>';
				}
				if ( ! empty( $attributes['cardDomain'] ) && '' !== $card_data['domain'] ) {
					$domain_name = '<span class="card-domain" style="color:' . $attributes['cardTextSubColor'] . ';">' . $card_data['domain'] . '</span>';
				}
				$card_text = '<div class="card-text">' . $label . $title . $desc . $domain_name . '</div>';
				if ( ! empty( $card_data['thumbnail'] ) ) {
					$card_image = '<div class="card-image' . $aspect_ratio . '"><img src="' . $card_data['thumbnail'] . '" alt="' . $card_data['title'] . '"></div>';
				} else {
					$card_image = '';
				}

				$classes[] = $attributes['cardImageAlign'];
				$classes[] = $attributes['cardLayout'];

				// インライン CSS を追加		
				if ( ! empty( $attributes['style'] ) ){
					$style = wp_style_engine_get_styles( $attributes['style'] );
					$css = $style['css'];
				}

				$wrapper_attributes = get_block_wrapper_attributes( 
					array( 
						'class' => trim( implode( ' ', $classes ) ),
						'style' => $css,
					)
				);

				$output = '<div ' . wp_kses_post( $wrapper_attributes ) . '>';
				$output .= '<a class="nishiki-pro-card-inner"' . $target . ' href="' . esc_url( $attributes['cardUrl'] ) . '" style="border-color:' . $attributes['cardBorderColor'] . '; background-color:' . $attributes['cardBackgroundColor'] . ';">';
				$output .= wp_kses_post( $card_image . $card_text );
				$output .= '</a></div>';
			} else {
				$output = 'データを取得できませんでした。正しい URL を入力してください。';
			}

			return $output;
		}

		/**
		 * Get Contents First Image
		 *
		 * @param string $content 本文
		 * @return $thumbnail
		 */
		public function get_content_image( $content ) {
			ob_start();
			ob_end_clean();
			preg_match_all( '/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $content, $matches );

			if ( isset( $matches[1][0] ) && ! is_wp_error( $matches[1][0] ) && file_exists( $matches[1][0] ) ) {
				$thumbnail = $matches[1][0];
			} else {
				$thumbnail = '';
			}

			// print_r('コンテンツから取得');

			return $thumbnail;
		}

	}

	$output = new NISHIKI_BLOCKS_PRO_CARD();
}
