<?php
if ( ! class_exists( 'NISHIKI_BLOCKS_PRO_FILTER_TIMELINE' ) ) {
	/**
	 * ブロックフィルター
	 */
	class NISHIKI_BLOCKS_PRO_FILTER_TIMELINE {

		/**
		 * constructor.
		 */
		public function __construct() {
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_block_inline_style' ), 20 );
		}

		function enqueue_block_inline_style() {
			global $post;
	
			if ( empty( $post->ID ) ) {
				return false;
			}
	
			$post_object = get_post( $post->ID );
	
			$all_blocks      = nishiki_pro_parse_all_blocks( $post->ID );
	
			if ( ! empty( $all_blocks ) ) {
	
				foreach ( $all_blocks as $blocks ) {
					// 全ブロックのコンテンツ取得
					$all_block_contents = nishiki_pro_parse_all_block_content( $blocks );
	
					$style = '';
	
					foreach ( $all_block_contents as $block ) {
						if ( 'nishiki-blocks-pro/timeline' === $block['blockName'] ) {
							if( ! empty( $block['attrs']['blockID'] ) ){
								$id = $block['attrs']['blockID'];
							}

							// Root Id
							if ( ! empty( $id ) ) {
								$root_style = '#nishiki-blocks-pro-tabs-' . $id;
							}

							$custom_style = '';

							if( array_key_exists( 'iconColor', $block['attrs'] ) ){
								$iconcolor = $block['attrs']['iconColor'];

								$custom_style .= '--iconcolor:' . $iconcolor . ';';
							}

							if( array_key_exists( 'timelineBorderColor', $block['attrs'] ) ){
								$bordercolor = $block['attrs']['timelineBorderColor'];

								$custom_style .= '--bordercolor:' . $bordercolor . ';';
							}
							
							if ( ! empty( $custom_style ) ) {
								$blockid = $block['attrs']['blockID'];
								$style = '.block-' . $blockid . '{';
								$style .= $custom_style;
								$style .= '}';
							}

							if ( ! empty( $style ) ) {
								wp_add_inline_style( 'nishiki-pro-main-style', $style );
							}
	
						}
					}
				}
			}
		}

	}

	new NISHIKI_BLOCKS_PRO_FILTER_TIMELINE();
	
}
