<?php
// Init Nishiki Blocks Pro v2
function nishiki_blocks_pro_v2_block_init() {

	/**
	 * Registers the block(s) metadata from the `blocks-manifest.php` and registers the block type(s)
	 * based on the registered block metadata.
	 * Added in WordPress 6.8 to simplify the block metadata registration process added in WordPress 6.7.
	 *
	 * @see https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/
	 */
	if ( function_exists( 'wp_register_block_types_from_metadata_collection' ) ) {
		wp_register_block_types_from_metadata_collection( __DIR__ . '/build', __DIR__ . '/build/blocks-manifest.php' );
		return;
	}

	// 個別チェック用
/*
	register_block_type( __DIR__ . '/build/accordion' );
	register_block_type( __DIR__ . '/build/accordion-content' );
	register_block_type( __DIR__ . '/build/animation' );
	register_block_type( __DIR__ . '/build/balloon' );
	register_block_type( __DIR__ . '/build/broken-grid-layout' );
	register_block_type( __DIR__ . '/build/broken-grid-layout-content' );
	register_block_type( __DIR__ . '/build/button' );
	register_block_type( __DIR__ . '/build/button2' );
	register_block_type( __DIR__ . '/build/buttons' );
	register_block_type( __DIR__ . '/build/card' );
	register_block_type( __DIR__ . '/build/countdown' );
	register_block_type( __DIR__ . '/build/faq' );
	register_block_type( __DIR__ . '/build/filter-search' );
	register_block_type( __DIR__ . '/build/filter-search-keywords' );
	register_block_type( __DIR__ . '/build/filter-search-terms' );
	register_block_type( __DIR__ . '/build/format' );
	register_block_type( __DIR__ . '/build/frame' );
	register_block_type( __DIR__ . '/build/icon' );
	register_block_type( __DIR__ . '/build/layout' );
	register_block_type( __DIR__ . '/build/layout-content' );
	register_block_type( __DIR__ . '/build/patterns' );
	register_block_type( __DIR__ . '/build/posts' );
	register_block_type( __DIR__ . '/build/radarchart' );
	register_block_type( __DIR__ . '/build/rss' );
	register_block_type( __DIR__ . '/build/section2' );
	register_block_type( __DIR__ . '/build/share-button' );
	register_block_type( __DIR__ . '/build/share-button-icon' );
	register_block_type( __DIR__ . '/build/slider2' );
	register_block_type( __DIR__ . '/build/slide2' );
	register_block_type( __DIR__ . '/build/tabs2' );
	register_block_type( __DIR__ . '/build/tab2' );
	register_block_type( __DIR__ . '/build/timelines' );
	register_block_type( __DIR__ . '/build/timeline' );
*/

	/**
	 * Registers the block(s) metadata from the `blocks-manifest.php` file.
	 * Added to WordPress 6.7 to improve the performance of block type registration.
	 *
	 * @see https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/
	 */
	if ( function_exists( 'wp_register_block_metadata_collection' ) ) {
//		wp_register_block_metadata_collection( __DIR__ . '/build', __DIR__ . '/build/blocks-manifest.php' );
	}
	/**
	 * Registers the block type(s) in the `blocks-manifest.php` file.
	 *
	 * @see https://developer.wordpress.org/reference/functions/register_block_type/
	 */
	$manifest_data = require __DIR__ . '/build/blocks-manifest.php';
	foreach ( array_keys( $manifest_data ) as $block_type ) {
//		register_block_type( __DIR__ . "/build/{$block_type}" );
	}
}
add_action( 'init', 'nishiki_blocks_pro_v2_block_init' );

// Add Block Category.
if ( ! function_exists( 'nishiki_blocks_pro_categories' ) ) {
	/**
	 * ブロックカテゴリー追加
	 *
	 * @param array $categories Array of categories for block types.
	 */
	function nishiki_blocks_pro_categories( $categories ) {
		array_unshift( $categories, array(
			'slug'  => 'nishiki-blocks-pro-deplecated',
			'title' => __( '非推奨', 'nishiki-pro' )
		) );

		array_unshift( $categories, array(
			'slug'  => 'nishiki-blocks-pro',
			'title' => __( 'Nishiki Blocks Pro', 'nishiki-pro' )
		) );

		return $categories;
	}

	if ( function_exists( 'get_default_block_categories' ) && function_exists( 'get_block_editor_settings' ) ) {
		add_filter( 'block_categories_all', 'nishiki_blocks_pro_categories', 10, 1 );
	} else {
		add_filter( 'block_categories', 'nishiki_blocks_pro_categories', 10, 1 );
	}
}


// Initialize the Dynamic blocks
require_once __DIR__ . '/dynamic/index.php';

// Initialize filter
require_once __DIR__ . '/filter/index.php';