<?php
if ( ! class_exists( 'NISHIKI_PRO_BLOCK_EDITOR_ADMIN' ) ) {
	/**
	 * ブロックエディター管理（管理画面）
	 */
	class NISHIKI_PRO_BLOCK_EDITOR_ADMIN extends NISHIKI_PRO_BLOCK_EDITOR_UTILITY {

		/**
		 * NISHIKI_PRO_CONTENT_ADMIN constructor.
		 */
		public function __construct() {
			// オプションページ追加フック.
			add_action( 'admin_menu', array( $this, 'admin_menu' ), 20 );
		}

		/**
		 * サブメニュー追加
		 */
		public function admin_menu() {
			add_submenu_page(
				'nishiki-pro-general.php',
				'ブロックエディター管理',
				'ブロックエディター管理',
				'manage_options',
				'nishiki-pro-block-editor.php',
				array( $this, 'admin_page' )
			);
		}

		/**
		 * 表示するタブ
		 *
		 * @var array
		 */
		public $tab_array = array(
			'colors'   => 'カラー',
			'headings' => '見出し（Beta）',
		);

		/**
		 * タブ出力
		 */
		public function create_tab() {
			$admin_url  = 'admin.php?page=nishiki-pro-block-editor.php';
			$flag       = false;
			$tab_array  = $this->tab_array;
			
			// GET パラメータの安全な取得とサニタイズ
			$get_select = isset( $_GET['select'] ) ? sanitize_key( wp_unslash( $_GET['select'] ) ) : '';

			// ホワイトリスト検証
			$allowed_tabs = array_keys( $this->tab_array );
			if ( ! empty( $get_select ) && ! in_array( $get_select, $allowed_tabs, true ) ) {
				$get_select = ''; // 無効な値の場合は空文字列に
			}

			echo '<div class="nav-tab-wrapper">';
			foreach ( $tab_array as $key => $val ) {
				$active = '';
				
				// キーの検証
				$sanitized_key = sanitize_key( $key );
				if ( $sanitized_key !== $key ) {
					continue; // 無効なキーはスキップ
				}

				if ( ! isset( $get_select ) && false === $flag ) {
					$active = ' nav-tab-active';
					$flag   = 1;
				} elseif ( isset( $get_select ) && $sanitized_key === $get_select && false === $flag ) {
					$active = ' nav-tab-active';
				}
				
				if ( empty( $get_select ) && 'colors' === $sanitized_key ) {
					$active = ' nav-tab-active';
				}

				// URLの安全な構築
				$tab_url = add_query_arg(
					array(
						'select' => $sanitized_key,
					),
					$admin_url
				);

				echo '<a href="' . esc_url( $tab_url ) . '" class="nav-tab' . esc_attr( $active ) . '">' . esc_html( $val ) . '</a>';
			}

			echo '</div>';
		}


		/**
		 * 設定画面出力
		 */
		public function create_setting() {
			$tab_array  = $this->tab_array;
			$flag       = false;
			
			// GET パラメータの安全な取得とサニタイズ
			$get_select = isset( $_GET['select'] ) ? sanitize_key( wp_unslash( $_GET['select'] ) ) : '';

			// ホワイトリスト検証
			$allowed_tabs = array_keys( $this->tab_array );
			if ( ! empty( $get_select ) && ! in_array( $get_select, $allowed_tabs, true ) ) {
				$get_select = ''; // 無効な値の場合は空文字列に
			}

			foreach ( $tab_array as $key => $val ) {
				// キーの検証
				$sanitized_key = sanitize_key( $key );
				if ( $sanitized_key !== $key ) {
					continue; // 無効なキーはスキップ
				}

				if ( ! isset( $get_select ) && false === $flag ) {
					$flag = true;
				} elseif ( isset( $get_select ) && $sanitized_key === $get_select && false === $flag ) {
					$flag = true;
				}

				if ( true === $flag ) {
					// オプション名の安全な構築
					$option_group = sanitize_text_field( $this->page_name . '_' . $sanitized_key );
					
					// オプション名の検証
					if ( preg_match( '/^[a-zA-Z0-9_-]+$/', $option_group ) ) {
						settings_fields( $option_group );
						do_settings_sections( $option_group );
					}

					break;
				}
			}

			if ( false === $flag ) {
				// デフォルトのcolorsタブ
				$default_option = sanitize_text_field( $this->page_name . '_colors' );
				if ( preg_match( '/^[a-zA-Z0-9_-]+$/', $default_option ) ) {
					settings_fields( $default_option );
					do_settings_sections( $default_option );
				}
			}
		}

		/**
		 * オプションページの内容
		 */
		public function admin_page() {
			// 権限チェック
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( esc_html( 'このページを表示する権限がありません。' ) );
			}

			// オプション名の検証
			$option_name = sanitize_text_field( 'nishiki_pro_block_editor' );
			if ( ! preg_match( '/^[a-zA-Z0-9_-]+$/', $option_name ) ) {
				wp_die( esc_html( '無効なオプション名です。' ) );
			}

			$this->options = get_option( $option_name, array() );
			?>
					<div class="wrap">
						<h1><?php echo esc_html( 'ブロックエディター管理' ); ?></h1>
							<?php $this->create_tab(); ?>
						<form method="post" action="options.php">
							<?php $this->create_setting(); ?>
						</form>

						<hr>
						<h3><?php echo esc_html( 'マニュアルを見る' ); ?></h3>
						<p>
							<a target="_blank" rel="noopener noreferrer" class="button" href="<?php echo esc_url( 'https://support.animagate.com/manual/wp-nishiki-color-palette/' ); ?>"><?php echo esc_html( __( 'カラー', 'textdomain' ) ); ?></a>
							<a target="_blank" rel="noopener noreferrer" class="button" href="<?php echo esc_url( 'https://support.animagate.com/manual/wp-nishiki-heading-style/' ); ?>"><?php echo esc_html( __( '見出しスタイル', 'textdomain' ) ); ?></a>
						</p>
					</div>
			<?php
		}

	}

	if ( is_admin() ) {
		$output = new NISHIKI_PRO_BLOCK_EDITOR_ADMIN();
	}
}
