<?php
if ( ! class_exists( 'NISHIKI_PRO_BLOCK_STYLES' ) ) {
	/**
	 * ブロックエディターのスタイル作成
	 */
	class NISHIKI_PRO_BLOCK_STYLES {

		/**
		 * Constructor.
		 */
		public function __construct() {
			add_action( 'init', array( $this, 'register' ), 10 );
		}

		/**
		 * スタイル追加
		 */
		public function register() {
			// heading
			$heading_array = array(
				array(
					'name'  => 'heading-border-01',
					'label' => 'ボーダー（上下）',
					// 'inline_style' => '.wp-block-quote.is-style-nishiki-blocks-pro-quote-blue { color: blue; }',
				),
				array(
					'name'  => 'heading-border-02',
					'label' => 'ボーダー（下）',
				),
				array(
					'name'  => 'heading-border-03',
					'label' => 'ボーダー',
				),
				array(
					'name'  => 'heading-border-04',
					'label' => 'ボーダー（水平）',
				),
				array(
					'name'  => 'heading-bracket-01',
					'label' => 'カッコ（左上/右下）',
				),
				array(
					'name'  => 'heading-bracket-02',
					'label' => 'カッコ（左右）',
				),
			);

			// Paragraph
			$paragraph_array = array(
				array(
					'name'  => 'paragraph-info-01',
					'label' => 'お知らせ',
				),
				array(
					'name'  => 'paragraph-info-02',
					'label' => 'お知らせ（メガホン）',
				),
				array(
					'name'  => 'paragraph-warning-01',
					'label' => '注意',
				),
				array(
					'name'  => 'paragraph-question-01',
					'label' => 'ヘルプ',
				),
				array(
					'name'  => 'paragraph-checkmark-01',
					'label' => 'チェック',
				),
				array(
					'name'  => 'paragraph-point-01',
					'label' => 'ポイント',
				),
				array(
					'name'  => 'paragraph-point-02',
					'label' => 'ポイント（虫眼鏡）',
				),
				array(
					'name'  => 'paragraph-point-03',
					'label' => 'ポイント（鉛筆）',
				),
				array(
					'name'  => 'paragraph-point-04',
					'label' => 'ポイント（本）',
				),
				array(
					'name'  => 'paragraph-circle-01',
					'label' => 'サークル',
				),
				array(
					'name'  => 'paragraph-cross-01',
					'label' => 'クロス',
				),
			);

			// Cover
			$cover_array = array(
				array(
					'name'  => 'cover-effect-01',
					'label' => 'ドット',
				),
				array(
					'name'  => 'cover-effect-02',
					'label' => 'ストライプ（斜め）',
				),
				array(
					'name'  => 'cover-effect-03',
					'label' => 'ストライプ（縦）',
				),
				array(
					'name'  => 'cover-effect-04',
					'label' => 'ストライプ（横）',
				),
				array(
					'name'  => 'cover-effect-05',
					'label' => '画像拡大',
				),
			);

			// table
			$table_array = array(
				array(
					'name'  => 'table-left-header-01',
					'label' => '左見出し',
				),
			);

			// button
			$button_array = array(
				array(
					'name'  => 'button-border-01',
					'label' => 'ボーダー（右下）',
				),
				array(
					'name'  => 'button-border-02',
					'label' => 'ボーダー（ストライプ）',
				),
			);

			// group
			$group_array = array(
				array(
					'name'  => 'group-stripe-01',
					'label' => 'ストライプ01',
				),
				array(
					'name'  => 'group-stripe-02',
					'label' => 'ストライプ02',
				),
				array(
					'name'  => 'group-dot-01',
					'label' => 'ドット',
				),
				array(
					'name'  => 'group-check-01',
					'label' => 'チェック',
				),
				array(
					'name'  => 'group-icon-info-01',
					'label' => 'お知らせ',
				),
				array(
					'name'  => 'group-icon-info-02',
					'label' => 'お知らせ（メガホン）',
				),
				array(
					'name'  => 'group-icon-warning-01',
					'label' => '注意',
				),
				array(
					'name'  => 'group-icon-question-01',
					'label' => 'ヘルプ',
				),
				array(
					'name'  => 'group-icon-checkmark-01',
					'label' => 'チェックマーク',
				),
				array(
					'name'  => 'group-icon-point-01',
					'label' => 'ポイント',
				),
				array(
					'name'  => 'group-icon-point-02',
					'label' => 'ポイント（虫眼鏡）',
				),
				array(
					'name'  => 'group-icon-point-03',
					'label' => 'ポイント（鉛筆）',
				),
				array(
					'name'  => 'group-icon-point-04',
					'label' => 'ポイント（本）',
				),
				array(
					'name'  => 'group-icon-circle-01',
					'label' => 'サークル',
				),
				array(
					'name'  => 'group-icon-cross-01',
					'label' => 'クロス',
				),
			);

			// image
			$image_array = array(
				array(
					'name'  => 'image-circle-01',
					'label' => '円',
				),
				array(
					'name'  => 'image-rhombus-01',
					'label' => 'ひし形',
				),
				array(
					'name'  => 'image-water-color-01',
					'label' => '水彩01',
				),
				array(
					'name'  => 'image-water-color-02',
					'label' => '水彩02',
				),
				array(
					'name'  => 'image-water-color-03',
					'label' => '水彩03',
				),
				array(
					'name'  => 'image-ink-01',
					'label' => 'インク01',
				),
				array(
					'name'  => 'image-ink-02',
					'label' => 'インク02',
				),
				array(
					'name'  => 'image-ink-03',
					'label' => 'インク03',
				),
				array(
					'name'  => 'image-fluid-01',
					'label' => '流体01',
				),
				array(
					'name'  => 'image-fluid-02',
					'label' => '流体02',
				),
				array(
					'name'  => 'image-fluid-03',
					'label' => '流体03',
				),
			);

			// Shadow
			$box_shadow_array = array(
				array(
					'name'  => 'box-shadow-sm',
					'label' => 'Shadow Small',
				),
				array(
					'name'  => 'box-shadow',
					'label' => 'Shadow',
				),
				array(
					'name'  => 'box-shadow-md',
					'label' => 'Shadow Medium',
				),
				array(
					'name'  => 'box-shadow-lg',
					'label' => 'Shadow Large',
				),
				array(
					'name'  => 'box-shadow-xl',
					'label' => 'Shadow XL',
				),
				array(
					'name'  => 'box-shadow-2-xl',
					'label' => 'Shadow 2XL',
				),
				array(
					'name'  => 'box-shadow-inner',
					'label' => 'Shadow Inner',
				),
				array(
					'name'  => 'hover-box-shadow-01',
					'label' => 'Hover Shadow 01',
				),
				array(
					'name'  => 'hover-box-shadow-02',
					'label' => 'Hover Shadow 02',
				),
				array(
					'name'  => 'hover-box-shadow-03',
					'label' => 'Hover Shadow 03',
				),
				array(
					'name'  => 'hover-box-shadow-04',
					'label' => 'Hover Shadow 04',
				),
				array(
					'name'  => 'hover-box-shadow-05',
					'label' => 'Hover Shadow 05',
				)
			);

			// accordion
			$accordion_array = array(
				array(
					'name'  => 'border',
					'label' => '枠あり',
				),
				array(
					'name'  => 'main-color',
					'label' => 'メインカラー',
				),
				array(
					'name'  => 'accent-color',
					'label' => 'アクセントカラー',
				),
			);

			// heading
			$this->register_blocks_styles( 'core/heading', $heading_array );

			// paragraph
			$this->register_blocks_styles( 'core/paragraph', $paragraph_array );
			$this->register_blocks_styles( 'core/paragraph', $box_shadow_array );

			// cover
			$this->register_blocks_styles( 'core/cover', $cover_array );

			// table
			$this->register_blocks_styles( 'core/table', $table_array );

			// button
			$this->register_blocks_styles( 'nishiki-blocks-pro/button', $button_array );
			$this->register_blocks_styles( 'nishiki-blocks-pro/button', $box_shadow_array );
			$this->register_blocks_styles( 'nishiki-blocks-pro/button2', $button_array );
			$this->register_blocks_styles( 'nishiki-blocks-pro/button2', $box_shadow_array );
			$this->register_blocks_styles( 'core/button', $box_shadow_array );

			// group
			$this->register_blocks_styles( 'core/group', $group_array );
			$this->register_blocks_styles( 'core/group', $box_shadow_array );

			// image
			$this->register_blocks_styles( 'core/image', $image_array );
			$this->register_blocks_styles( 'core/image', $box_shadow_array );

			// accordion
			$this->register_blocks_styles( 'core/accordion', $accordion_array );
		}

		/**
		 * スタイル登録
		 *
		 * @param string $block_name ブロック名
		 * @param array  $style_properties プロパティ
		 * @return void
		 */
		public function register_blocks_styles( $block_name, $style_properties ) {
			if ( ! empty( $block_name ) && ! empty( $style_properties ) && is_array( $style_properties ) ) {
				foreach ( $style_properties as $property ) {
					register_block_style(
						$block_name,
						array(
							'name'  => 'nishiki-blocks-pro-' . $property['name'],
							'label' => $property['label'],
							// 'inline_style' => '.wp-block-quote.is-style-nishiki-blocks-pro-quote-blue { color: blue; }',
						)
					);
				}
			}
		}

	}
}

$output = new NISHIKI_PRO_BLOCK_STYLES();
