<?php
if ( ! class_exists( 'NISHIKI_PRO_GENERAL' ) ) {
	/**
	 * 一般設定
	 */
	class NISHIKI_PRO_GENERAL extends NISHIKI_PRO_GENERAL_UTILITY {
		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'nishiki_pro_gerenal_menu' ), 10 );
		}

		/**
		 * サブメニュー追加
		 */
		public function nishiki_pro_gerenal_menu() {
			add_menu_page(
				'Nishiki Pro',
				'Nishiki Pro',
				'manage_options',
				'nishiki-pro-general.php',
				array( $this, 'nishiki_pro_general_page' ),
				'dashicons-admin-generic'
			);

			add_submenu_page(
				'nishiki-pro-general.php',
				'一般設定',
				'一般設定',
				'manage_options',
				'nishiki-pro-general.php',
				array( $this, 'nishiki_pro_general_page' )
			);
		}

		/**
		 * 表示するタブ
		 *
		 * @var array
		 */
		public $tab_array = array(
			'top'         => 'トップページ',
			'font'        => 'フォント',
			'profile'     => 'プロフィール',
			'script'      => 'スクリプト追加',
			'optimize'    => 'テーマ最適化',
			'breadcrumbs' => 'パンくずリスト',
			'infeed_ads'  => 'インフィード広告（Beta）',
			'redirect'    => 'リダイレクト',
			'css'         => '追加 CSS',
		);

		/**
		 * タブ出力
		 */
		public function create_tab() {
			$admin_url  = 'admin.php?page=nishiki-pro-general.php';
			$flag       = false;
			$tab_array  = $this->tab_array;

			$get_action = ! empty( $_GET['action'] ) ? htmlspecialchars( $_GET['action'] ) : '';

			echo '<div class="nav-tab-wrapper">';
			foreach ( $tab_array as $key => $val ) {
				$active = '';
				if ( ! isset( $get_action ) && false === $flag ) {
					$active = ' nav-tab-active';
					$flag   = 1;
				} elseif ( isset( $get_action ) && $key === $get_action && false === $flag ) {
					$active = ' nav-tab-active';
				}
				if( empty( $get_action ) && 'top' == $key ){
					$active = ' nav-tab-active';
				}
	
				echo '<a href="' . esc_url(
					add_query_arg(
						array(
							'action' => $key,
						),
						$admin_url
					)
				) . '" class="nav-tab' . esc_attr( $active ) . '">' . esc_html( $val ) . '</a>';
			}

			echo '</div>';
		}

		/**
		 * 設定画面出力
		 */
		public function create_setting() {

			$tab_array  = $this->tab_array;
			$flag       = false;
			$get_action = ! empty( $_GET['action'] ) ? htmlspecialchars( $_GET['action'] ) : '';

			foreach ( $tab_array as $key => $val ) {
				if ( ! isset( $get_action ) && false === $flag ) {
					$flag = true;
				} elseif ( isset( $get_action ) && $key === $get_action && false === $flag ) {
					$flag = true;
				}

				if ( true === $flag ) {
					settings_fields( $this->plugin_name . '_' . $key );
					do_settings_sections( $this->plugin_name . '_' . $key );

					submit_button();

					break;
				}
			}

			if( false === $flag ){
				settings_fields( $this->plugin_name . '_top' );
				do_settings_sections( $this->plugin_name . '_top' );
	
				submit_button();
			}

		}

		/**
		 * オプションページの内容
		 */
		public function nishiki_pro_general_page() {
			$this->options = get_option( $this->plugin_name );
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( 'このページを表示する権限がありません。' );
			}
			?>
				<div class="wrap">
					<h1>一般設定</h1>
						<?php $this->create_tab(); ?>
					<form method="post" action="options.php">
						<?php $this->create_setting(); ?>
					</form>

					<hr>
					<h3>マニュアルを見る</h3>
					<p>
						<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-top-title-description/">トップページ</a>
						<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-font-family/">フォント</a>
						<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-user-profile/">プロフィール</a>
						<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-script/">スクリプト追加</a>
						<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-gb-optimize/">テーマ最適化</a>
						<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-breadcrumbs/">パンくずリスト</a>
						<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-infeed-ads/">インフィード広告</a>
						<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-redirect/">リダイレクト</a>
						<a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-add-css/">追加 CSS</a>
					</p>
				</div>
			<?php
		}
	}

	if ( is_admin() ) {
		$output = new NISHIKI_PRO_GENERAL();
	}
}
