<?php
if ( ! class_exists( 'NISHIKI_PRO_CONTENT_POST_TYPE' ) ) {
	/**
	 * 投稿の編集画面に設定画面追加
	 */
	class NISHIKI_PRO_CONTENT_POST_TYPE extends NISHIKI_PRO_CONTENT_UTILITY {

		/**
		 * 初期設定
		 */
		public function __construct() {

			// 投稿タイプ追加
			add_action( 'init', array( $this, 'nishiki_pro_content_register_post_type' ), 20 );

			// Gutenberg対応
			add_filter( 'gutenberg_can_edit_post_type', array( $this, 'nishiki_pro_content_can_edit_post_type' ), 20, 2 );

			// ショートコード有効化
			add_shortcode( 'nishiki_pro_cta', array( $this, 'nishiki_pro_content_shortcode' ), 20 );

			// カラムにCTA追加
			add_filter( 'manage_nishiki_pro_content_posts_columns', array( $this, 'nishiki_pro_content_columns_head' ), 20 );
			add_action( 'manage_nishiki_pro_content_posts_custom_column', array( $this, 'nishiki_pro_content_columns' ), 20, 2 );

			// metabox追加
			add_action( 'add_meta_boxes', array( $this, 'nishiki_pro_content_add_meta_box' ), 20 );

			// metabox保存
			add_action( 'save_post', array( $this, 'nishiki_pro_content_save_meta_box_data' ), 20 );

		}

		/**
		 * カスタム投稿タイプ追加
		 */
		public function nishiki_pro_content_register_post_type() {

			register_post_type(
				'nishiki_pro_content',
				array(
					'labels'                => array(
						'name'               => '再利用コンテンツ',
						'add_new_item'       => '再利用コンテンツを追加',
						'edit_item'          => '編集',
						'new_item'           => '新規作成',
						'attributes'         => '',
						'view_item'          => 'コンテンツを表示',
						'search_items'       => '検索',
						'not_found'          => '見つかりませんでした',
						'not_found_in_trash' => 'ゴミ箱にはありません',
						'parent_item_colon'  => '',
					),
					'public'                => false,
					'exclude_from_search'   => true,
					'publicly_queryable'    => false,
					'show_ui'               => true,
					'show_in_nav_menus'     => false,
					'show_in_menu'          => true,
					'menu_icon'             => 'dashicons-flag',
					'description'           => '',
					'has_archive'           => false,
					'show_in_rest'          => true,
					'rest_base'             => 'nishiki_pro_content',
					'rest_controller_class' => 'WP_REST_Posts_Controller',
					'supports'              => array(
						'title',
						'editor',
						'revisions',
					),
				)
			);
		}

		/**
		 * カスタム投稿タイプ Gutenberg 対応
		 *
		 * @param boolean $can_edit 編集可能かどうか
		 * @param string  $post_type 投稿タイプ
		 * @return $can_edit
		 */
		public function nishiki_pro_content_can_edit_post_type( $can_edit, $post_type ) {

			if ( $this->plugin_name === $post_type ) {
				return true;
			}

			return $can_edit;
		}

		/**
		 * ショートコード
		 *
		 * @param array $atts 属性
		 * @return $post_content
		 */
		public function nishiki_pro_content_shortcode( $atts ) {
			$a = shortcode_atts(
				array(
					'id' => '',
				),
				$atts
			);
			if ( '' === $a['id'] ) {
				return false;
			}
			$post_content = '<div id="nishiki_pro_cta_' . esc_attr( $a['id'] ) . '">' . apply_filters( 'the_content', get_post_field( 'post_content', esc_attr( $a['id'] ) ) ) . '</div>';

			return $post_content;
		}

		/**
		 * カラム追加
		 *
		 * @param array $defaults デフォルト設定
		 * @return $defaults
		 */
		public function nishiki_pro_content_columns_head( $defaults ) {
			$defaults['nishiki_pro_content'] = 'ショートコード';

			return $defaults;
		}

		/**
		 * カラム内容
		 *
		 * @param string $column_name カラム名
		 * @param int    $post_ID 投稿 ID
		 * @return void
		 */
		public function nishiki_pro_content_columns( $column_name, $post_ID ) {
			if ( 'nishiki_pro_content' === $column_name ) {
				echo '[nishiki_pro_content id="' . absint( $post_ID ) . '"]';
			}
		}

		/**
		 * Adds a box to the main column on the Post and Page edit screens.
		 */
		public function nishiki_pro_content_add_meta_box() {

			$screens = nishiki_pro_get_all_post_types();
			foreach ( $screens as $screen ) {
				add_meta_box(
					'nishiki_pro_content_' . $screen,
					__( '個別にコンテンツを追加する（上級者向け）', 'nishiki_pro' ),
					array( $this, 'nishiki_pro_content_callback' ),
					$screen
				);
			}

			// 編集画面にショートコード表示
			add_meta_box(
				'nishiki-pro-content-info',
				__( 'ショートコード', 'nishiki_pro' ),
				array( $this, 'download_information' ),
				'nishiki_pro_content',
				'side',
				'high'
			);
		}


		/**
		 * Prints the box content.
		 *
		 * @param WP_Post $post The object for the current post/page.
		 */
		public function nishiki_pro_content_callback( $post ) {

			// Add a nonce field so we can check for it later.
			wp_nonce_field( 'nishiki_pro_content_save_meta_box_data', 'nishiki_pro_content_meta_box_nonce' );

			/*
			 * Use get_post_meta() to retrieve an existing value
			 * from the database and use the value for the form.
			 */
			// $value = get_post_meta( $post->ID, '_nishiki_pro_content', true );
			echo '<p><a target="_blank" rel="noopener noreferrer" class="button" href="' . esc_url( admin_url( 'edit.php?post_type=nishiki_pro_content' ) ) . '">再利用コンテンツ</a> <a target="_blank" rel="noopener noreferrer" class="button" href="' . esc_url( admin_url( 'admin.php?page=nishiki-pro-content.php' ) ) . '">再利用コンテンツ管理</a></p>';
			echo '<p>個別でコンテンツ管理する場合は設定してください。</p>';

			$hook_array   = $this->section_array;
			$content_list = array( '' => '共通設定' ) + $this->nishiki_pro_content_list() + array( 'disabled' => '非表示' );

			foreach ( $hook_array as $hook => $hook_name ) {
				if ( ! empty( $hook_array ) ) {
					echo '<p><label for="nishiki_pro_content_' . esc_attr( $hook ) . '">' . esc_attr( $hook_name ) . '</label> <select name="' . esc_attr( $hook ) . '" id="nishiki_pro_content_' . esc_attr( $hook ) . '">';
					foreach ( $content_list as $key => $title ) {
						$value = get_post_meta( $post->ID, '_' . $hook, true );
						if ( isset( $value ) && $value === (string) $key ) {
							$selected = ' selected="selected"';
						} else {
							$selected = '';
						}

						echo '<option value="' . esc_attr( $key ) . '"' . esc_attr( $selected ) . '">' . esc_html( $title ) . '</option>';
					}
					echo '</select></p>';
				}
			}

			echo '<div style="border:1px solid #aaa; padding:1rem;border-radius: 4px;position: relative;margin-top: 2.5rem;">';
			echo '<h3 style="margin: 0;display: inline-block;position: absolute;top: -0.7rem;background: #fff;padding: 0 0.5rem;">※ コンテンツが表示されない場合</h3>';
			echo '<p><a target="_blank" rel="noopener noreferrer" class="button" href="' . esc_url( admin_url( 'admin.php?page=nishiki-pro-content.php' ) ) . '">再利用コンテンツ管理</a> ページで以下の設定を確認してください。</p>';
			echo '<p>「全ページ共通」タブを選択 →「コンテンツを表示する」にチェックを入れてください。</p>';
			echo '<h4>トップページに表示されない場合</h4>';
			echo '<p>「トップページ」タブを選択 →「コンテンツを表示する」にチェックを入れてください。</p>';
			echo '<h4>投稿・固定ページに表示されない場合</h4>';
			echo '<p>「投稿・固定ページ」タブを選択 →「コンテンツを表示する」にチェックを入れてください。</p>';
			echo '<p>「投稿・固定ページ」タブを選択 →「表示する投稿タイプ」にチェックを入れてください。</p>';
			echo '</div>';
		}

		/**
		 * When the post is saved, saves our custom data.
		 *
		 * @param int $post_id The ID of the post being saved.
		 */
		public function nishiki_pro_content_save_meta_box_data( $post_id ) {

			// Check if our nonce is set.
			if ( ! isset( $_POST['nishiki_pro_content_meta_box_nonce'] ) ) {
				return;
			}

			// Verify that the nonce is valid.
			if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nishiki_pro_content_meta_box_nonce'] ) ), 'nishiki_pro_content_save_meta_box_data' ) ) {
				return;
			}

			// If this is an autosave, our form has not been submitted, so we don't want to do anything.
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}

			// Check the user's permissions.
			if ( isset( $_POST['post_type'] ) ) {

				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}
			} else {

				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}

			// OK, it's safe for us to save the data now.
			// $value = get_post_meta( $post_id, '_nishiki_pro_content', true );
			$hook_array = $this->section_array;

			foreach ( $hook_array as $hook => $label ) {
				// ポストされていなかったら
				if ( ! isset( $_POST[ $hook ] ) ) {
					$value = get_post_meta( $post_id, '_' . $hook, true );
					if ( $value ) {
						delete_post_meta( $post_id, '_' . $hook, $value );
					}
				} else {
					// Sanitize user input.
					$my_data = sanitize_text_field( wp_unslash( ( $_POST[ $hook ] ) ) );

					// Update the meta field in the database.
					update_post_meta( $post_id, '_' . $hook, $my_data );
				}
			}

		}

		/**
		 * サイドバーにショートコード表示
		 *
		 * @param object $post 投稿オブジェクト
		 * @return void
		 */
		public function download_information( $post ) {
			?>
			<div class="nishiki-pro-content-info-panel">
				<p>
					<input style="width:100%;" type="text" value='[nishiki_pro_content id="<?php echo absint( $post->ID ); ?>"]' readonly onfocus="this.select()" />
					<span style="display:inline-block;margin-top:0.5rem;">ショートコードは投稿ページ、固定ページ、ウィジェットにも使用できます。</span>
				</p>
				<p>
					【上級者向け設定】スペース区切りで class 属性を追加できます。
				</p>
				<p>
					※「追加 CSS クラス」の値は class 属性を追加しなくても自動で付与されます。
				</p>
				<div>例：<code>[nishiki_pro_content id="<?php echo absint( $post->ID ); ?>" class="abc text"]</code></div>
			</div>
			<?php
		}

	}

	$nishiki_pro_content_post_type = new NISHIKI_PRO_CONTENT_POST_TYPE();
}
