<?php
if ( ! class_exists( 'NISHIKI_PRO_CONTENT_SC' ) ) {
	/**
	 * CONTENT Shortcode.
	 */
	class NISHIKI_PRO_CONTENT_SC extends NISHIKI_PRO_CONTENT_UTILITY {

		/**
		 * Construct
		 */
		public function __construct() {
			add_shortcode( 'nishiki_pro_content', array( $this, 'nishiki_pro_content_sc' ) );
		}

		/**
		 * ショートコード作成
		 *
		 * @param array $atts 属性
		 */
		public function nishiki_pro_content_sc( $atts ) {
			// default value
			$args = shortcode_atts(
				array(
					'id' => '',
					'class' => '',
				),
				$atts
			);

			if ( empty( $args['id'] ) ) {
				return false;
			}

			// コンテンツ専用ショートコード除外
			$post_content = preg_replace( '/\[nishiki_pro_content(.*?)\]/s', '', apply_filters( 'the_content', get_post_field( 'post_content', $args['id'] ) ) );
			$post_content = str_replace( ']]>', ']]&gt;', $post_content );
			
			$this->remove_restore_autop_the_content();

			// 追加 CSS クラス
			$custom_class = array();

			if( get_post_meta( $args['id'], '_nishiki_pro_meta_box_class_nishiki_pro_content', true ) ){
				$meta_box_class =' ' . get_post_meta( $args['id'], '_nishiki_pro_meta_box_class_nishiki_pro_content', true );
				$custom_class = explode( ' ', $meta_box_class );
			}

			$default_class = array(
				'nishiki-pro-content',
				'nishiki-pro-content-sc',
				'nishiki-pro-content-sc-' . $args['id']
			);

			$extra_class = explode( ' ', $args['class'] );

			$classes = array_merge( $default_class, $custom_class, $extra_class );

			return '<div class="' . esc_attr( trim( implode( ' ', $classes ) ) ) . '">' . wp_kses_post( $post_content ) . '</div>';
		}

	}
}

$shortcode = new NISHIKI_PRO_CONTENT_SC();
