<?php
if ( ! class_exists( 'NISHIKI_PRO_CONTENT_TERM' ) ) {
	/**
	 * タームごとに再利用コンテンツの設定を表示
	 */
	class NISHIKI_PRO_CONTENT_TERM extends NISHIKI_PRO_CONTENT_UTILITY {

		/**
		 * 初期設定
		 */
		public function __construct() {
			// term meta 登録.
			add_action(
				'init',
				function() {
					$array = $this->taxonomies();

					foreach ( $array as $taxonomy => $label ) {
						// add_action( $taxonomy . '_add_form_fields', array( $this, 'new_term_meta_field' ), 20, 3 );
						add_action( $taxonomy . '_edit_form_fields', array( $this, 'edit_term_meta_field' ), 20, 3 );

						// add_action( 'create_' . $taxonomy, array( $this, 'save_term_meta' ), 20, 3 );
						add_action( 'edit_' . $taxonomy, array( $this, 'save_term_meta' ), 20, 3 );

						// add_filter( 'manage_edit-' . $taxonomy . '_columns', array( $this, 'add_term_columns' ), 20, 3 );
						// add_action( 'manage_' . $taxonomy . '_custom_column', array( $this, 'add_term_value' ), 20, 3 );
					}

					$this->register_term_meta();
				},
				20
			);
		}

		/**
		 * More以外の配列（最後の配列データを削除）
		 *
		 * @return $content_array
		 */
		public function content_array() {
			$content_array = $this->section_array;
			array_pop( $content_array );

			return $content_array;
		}

		/**
		 * 追加したいフィールドを配列で登録
		 *
		 * @return $taxonomies
		 */
		public function taxonomies() {
			// 表示したいフィールドのタクソノミーを配列で登録.
			$taxonomy_array = $this->nishiki_pro_content_taxonomy_list();
			// var_dump($taxonomy_array);
			$taxonomies = array();
			foreach ( $taxonomy_array as $taxonomy ) {
				if ( 'post_format' !== $taxonomy->name ) {
					$taxonomies[ $taxonomy->name ] = $taxonomy->label;
				}
			}

			return $taxonomies;
		}

		/**
		 * Term Meta 登録
		 *
		 * @return void
		 */
		public function register_term_meta() {
			foreach ( $this->content_array() as $key => $val ) {
				register_meta( 'term', $key, array( $this, 'sanitize_meta_box' ) );
			}
		}

		/**
		 * Sanitize meta box
		 *
		 * @param string $text 文字列
		 * @return $text
		 */
		public function sanitize_meta_box( $text ) {
			return esc_html( $text );
		}

		/**
		 * 入力フィールド追加(新規登録画面)
		 *
		 * @return void
		 */
		public function new_term_meta_field() {
			wp_nonce_field( basename( __FILE__ ), 'term_meta_nishiki_pro_content_nonce' );
			echo '<div class="form-field">';
			foreach ( $this->content_array() as $key => $val ) {
				echo '<label for="' . esc_attr( $key ) . '">' . esc_html( $val ) . '</label>';
				$this->content_select_box( '', $key, $val );
			}
			echo '</div>';
		}

		/**
		 * 入力フィールド追加（編集画面）
		 *
		 * @param array $current_term ターム
		 * @return void
		 */
		public function edit_term_meta_field( $current_term ) {
			wp_nonce_field( basename( __FILE__ ), 'term_meta_nishiki_pro_content_nonce' );
			foreach ( $this->content_array() as $key => $val ) {
				echo '<tr class="form-field">';
				echo '<th scope="row"><label for="' . esc_attr( $key ) . '">' . esc_html( $val ) . '</label></th><td>';
				$this->content_select_box( $current_term, $key, $val );
				echo '</tr>';
			}
		}

		/**
		 * セレクトボックス作成
		 *
		 * @param array  $current_term ターム
		 * @param string $key キー
		 * @param string $val 値
		 * @return void
		 */
		public function content_select_box( $current_term, $key, $val ) {
			$content_list = array(
				'' => '共通設定',
			) + $this->nishiki_pro_content_list() + array(
				'disabled' => '非表示',
			);

			echo '<select name="' . esc_attr( $key ) . '" id="' . esc_attr( $key ) . '">';
			foreach ( $content_list as $content_id => $title ) {
				$selected = '';
				if ( ! empty( $current_term ) ) {
					$text = get_term_meta( $current_term->term_id, $key, true ) ? get_term_meta( $current_term->term_id, $key, true ) : '';
					if ( isset( $text ) && $text === (string) $content_id ) {
						$selected = ' selected="selected"';
					}
				}

				echo '<option value="' . esc_attr( $content_id ) . '" ' . esc_attr( $selected ) . ' ">' . esc_html( $title ) . '</option>';
			}
			echo '</select>';
		}

		/**
		 * 保存
		 *
		 * @param int $term_id ターム ID
		 * @return void
		 */
		public function save_term_meta( $term_id ) {

			if ( ! isset( $_POST['term_meta_nishiki_pro_content_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['term_meta_nishiki_pro_content_nonce'] ) ), basename( __FILE__ ) ) ) {
				return;
			}

			foreach ( $this->content_array() as $key => $val ) {

				$old_data = get_term_meta( $term_id, $key, true );
				$new_data = isset( $_POST[ $key ] ) ? $this->sanitize_meta_box( sanitize_text_field( wp_unslash( $_POST[ $key ] ) ) ) : '';

				if ( $old_data && '' === $new_data ) {
					delete_term_meta( $term_id, $key );

				} elseif ( $old_data !== $new_data ) {
					update_term_meta( $term_id, $key, $new_data );
				}
			}
		}

		/**
		 * カラムに表示
		 *
		 * @param array $columns カラム
		 * @return $columns
		 */
		public function add_term_columns( $columns ) {
			foreach ( $this->content_array() as $key => $val ) {
				$columns[ $key ] = $val;
			}

			return $columns;
		}

		/**
		 * カラムに値を出力
		 *
		 * @param string $value 値
		 * @param string $column_name カラム名
		 * @param int    $term_id ターム ID
		 * @return void
		 */
		public function add_term_value( $value, $column_name, $term_id ) {
			foreach ( $this->content_array() as $key => $val ) {
				if ( $column_name === $key ) {
					echo esc_html( get_term_meta( $term_id, $key, true ) );
				}
			}
		}
	}

	if ( is_admin() ) {
		$nishiki_pro_content_term = new NISHIKI_PRO_CONTENT_TERM();
	}
}
