<?php
if ( ! class_exists( 'NISHIKI_PRO_META_BOX_CONTENT_WIDTH' ) ) {
	/**
	 * Meta box 追加(コンテンツ幅)
	 *
	 * @author     AnimaGate, Inc.
	 * @link       https://support.animagate.com/product/wp-nishiki-pro/
	 */
	class NISHIKI_PRO_META_BOX_CONTENT_WIDTH {
		/**
		 * 名前
		 *
		 * @var string
		 */
		private $meta_box_name = 'nishiki_pro_meta_box_content_width';

		/**
		 * Constructor.
		 */
		public function __construct() {
			add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ), 10 );
			add_action( 'save_post', array( $this, 'save_meta_box' ), 10 );
		}

		/**
		 * Adds a box to the main column on the Post and Page edit screens.
		 */
		public function add_meta_box() {

			$screens = nishiki_pro_get_all_post_types();
			foreach ( $screens as $screen ) {
				add_meta_box(
					$this->meta_box_name . '_' . $screen,
					__( 'コンテンツ幅を変更する', 'nishiki_pro' ),
					array( $this, 'meta_box_callback' ),
					$screen,
					'side'
				);
			}
		}

		/**
		 * Prints the box content.
		 *
		 * @param WP_Post $post The object for the current post/page.
		 */
		public function meta_box_callback( $post ) {

			// Add a nonce field so we can check for it later.
			wp_nonce_field( $this->meta_box_name . '_save', $this->meta_box_name . '_nonce' );

			/*
			 * Use get_post_meta() to retrieve an existing value
			 * from the database and use the value for the form.
			 */
			$value = get_post_meta( get_the_ID(), '_' . $this->meta_box_name . '_' . get_post_type(), true );
			echo '<label for="' . esc_attr( $this->meta_box_name ) . '"><input type="number" id="' . esc_attr( $this->meta_box_name ) . '" name="' . esc_attr( $this->meta_box_name ) . '_new_field" value="' . absint( $value ) . '"/> px</label>';
			echo '<p><small>変更しない場合は 0 を入力してください。</small></p>';
		}

		/**
		 * When the post is saved, saves our custom data.
		 *
		 * @param int $post_id The ID of the post being saved.
		 */
		public function save_meta_box( $post_id ) {

			// Check if our nonce is set.
			if ( ! isset( $_POST[ $this->meta_box_name . '_nonce' ] ) ) {
				return;
			}

			// Verify that the nonce is valid.
			if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_nonce' ] ) ), $this->meta_box_name . '_save' ) ) {
				return;
			}

			// If this is an autosave, our form has not been submitted, so we don't want to do anything.
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}

			// Check the user's permissions.
			if ( isset( $_POST['post_type'] ) && 'page' === $_POST['post_type'] ) {

				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}
			} else {

				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}

			/* OK, it's safe for us to save the data now. */

			$value = get_post_meta( $post_id, '_' . $this->meta_box_name . '_' . get_post_type(), true );

			// 値がポストされていなかったら
			if ( ! isset( $_POST[ $this->meta_box_name . '_new_field' ] ) ) {
				if ( $value ) {
					delete_post_meta( $post_id, '_' . $this->meta_box_name . '_' . get_post_type(), 1 );
				}
				return;
			} else {
				// Sanitize user input.
				$my_data = sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_new_field' ] ) );

				// Update the meta field in the database.
				update_post_meta( $post_id, '_' . $this->meta_box_name . '_' . get_post_type(), $my_data );
			}
		}

	}
}

$output = new NISHIKI_PRO_META_BOX_CONTENT_WIDTH();
