<?php
if ( ! class_exists( 'NISHIKI_PRO_META_BOX_PR' ) ) {
	/**
	 * Meta box 追加(PR)
	 *
	 * @author     AnimaGate, Inc.
	 * @link       https://support.animagate.com/product/wp-nishiki-pro/
	 */
	class NISHIKI_PRO_META_BOX_PR {
		/**
		 * 名前
		 *
		 * @var string
		 */
		private $meta_box_name = 'nishiki_pro_meta_box_pr';

		/**
		 *
		 * Constructor.
		 */
		public function __construct() {
			add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ), 10 );
			add_action( 'save_post', array( $this, 'save_meta_box' ), 10 );
		}

		/**
		 * Adds a box to the main column on the Post and Page edit screens.
		 */
		public function add_meta_box() {

			$screens = nishiki_pro_get_all_post_types();
			foreach ( $screens as $screen ) {
				add_meta_box(
					$this->meta_box_name . '_' . $screen,
					__( 'PR 設定', 'nishiki_pro' ),
					array( $this, 'meta_box_callback' ),
					$screen,
					'side'
				);
			}
		}

		/**
		 * Prints the box content.
		 *
		 * @param WP_Post $post The object for the current post/page.
		 */
		public function meta_box_callback( $post ) {

			// Add a nonce field so we can check for it later.
			wp_nonce_field( $this->meta_box_name . '_save', $this->meta_box_name . '_nonce' );

			/*
			 * Use get_post_meta() to retrieve an existing value
			 * from the database and use the value for the form.
			 */

			$value_label  = get_post_meta( get_the_ID(), '_' . $this->meta_box_name . '_label_' . get_post_type(), true );
			$value_label_text  = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_PR . '_label_text', 'PR' );
			$value_label_custom_text = get_post_meta( get_the_ID(), '_' . $this->meta_box_name . '_custom_label_text_' . get_post_type(), true );
			$value_label_checked = ( $value_label ) ? ' checked="checked"' : '';

			echo '<label for="' . esc_attr( $this->meta_box_name ) . '_label">';
			echo '<input type="checkbox" id="' . esc_attr( $this->meta_box_name ) . '_label" name="' . esc_attr( $this->meta_box_name ) . '_label_new_field" value="1" ' . esc_attr( $value_label_checked ) . ' />ラベルを表示</label>';

			$value_before_content = get_post_meta( get_the_ID(), '_' . $this->meta_box_name . '_before_content_' . get_post_type(), true );
			$value_before_content_text  = get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_PR . '_before_content_text', '本ページはプロモーションが含まれています。' );
			$value_before_content_custom_text = get_post_meta( get_the_ID(), '_' . $this->meta_box_name . '_custom_before_content_text_' . get_post_type(), true );
			$value_before_content_checked = ( $value_before_content ) ? ' checked="checked"' : '';

			echo '<p><label for="' . esc_attr( $this->meta_box_name ) . '_before_content">';
			echo '<input type="checkbox" id="' . esc_attr( $this->meta_box_name ) . '_before_content" name="' . esc_attr( $this->meta_box_name ) . '_before_content_new_field" value="1" ' . esc_attr( $value_before_content_checked ) . ' />本文の冒頭に表示</label></p>';
			echo '<p><label for="' . esc_attr( $this->meta_box_name ) . '_custom_label_text"><legend>カスタム（ラベル）</legend><input placeholder="' . esc_attr( $value_label_text ) . '" type="text" id="' . esc_attr( $this->meta_box_name ) . '_custom_label_text" name="' . esc_attr( $this->meta_box_name ) . '_custom_label_text_new_field" value="' . esc_html( $value_label_custom_text ) . '"/></label></p>';
			echo '<p><label for="' . esc_attr( $this->meta_box_name ) . '_custom_before_content_text"><legend>カスタム（本文の冒頭）</legend><textarea placeholder="' . esc_attr( $value_before_content_text ) . '" id="' . esc_attr( $this->meta_box_name ) . '_custom_before_content_text" name="' . esc_attr( $this->meta_box_name ) . '_custom_before_content_text_new_field">' . esc_html( $value_before_content_custom_text ) . '</textarea></label></p>';

		}

		/**
		 * When the post is saved, saves our custom data.
		 *
		 * @param int $post_id The ID of the post being saved.
		 */
		public function save_meta_box( $post_id ) {

			// Check if our nonce is set.
			if ( ! isset( $_POST[ $this->meta_box_name . '_nonce' ] ) ) {
				return;
			}

			// Verify that the nonce is valid.
			if ( ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_nonce' ] ) ), $this->meta_box_name . '_save' ) ) {
				return;
			}

			// If this is an autosave, our form has not been submitted, so we don't want to do anything.
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}

			// Check the user's permissions.
			if ( isset( $_POST['post_type'] ) && 'page' === $_POST['post_type'] ) {

				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}
			} else {

				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}

			/* OK, it's safe for us to save the data now. */

			/*
			 * Label
			 */
			$value = get_post_meta( $post_id, '_' . $this->meta_box_name . '_label_' . get_post_type(), true );

			// 値がポストされていなかったら
			if ( ! isset( $_POST[ $this->meta_box_name . '_label_new_field' ] ) ) {
				if ( $value ) {
					delete_post_meta( $post_id, '_' . $this->meta_box_name . '_label_' . get_post_type(), 1 );
				}
			} else {
				// Sanitize user input.
				$my_data = sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_label_new_field' ] ) );

				// Update the meta field in the database.
				update_post_meta( $post_id, '_' . $this->meta_box_name . '_label_' . get_post_type(), $my_data );
			}

			/*
			 * Before Content
			 */
			$value = get_post_meta( $post_id, '_' . $this->meta_box_name . '_before_content_' . get_post_type(), true );

			// 値がポストされていなかったら
			if ( ! isset( $_POST[ $this->meta_box_name . '_before_content_new_field' ] ) ) {
				if ( $value ) {
					delete_post_meta( $post_id, '_' . $this->meta_box_name . '_before_content_' . get_post_type(), 1 );
				}
			} else {
				// Sanitize user input.
				$my_data = sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_before_content_new_field' ] ) );

				// Update the meta field in the database.
				update_post_meta( $post_id, '_' . $this->meta_box_name . '_before_content_' . get_post_type(), $my_data );
			}

			/*
			 * Custom Label Text
			 */
			$value = get_post_meta( $post_id, '_' . $this->meta_box_name . '_custom_label_text_' . get_post_type(), true );

			// 値がポストされていなかったら
			if ( ! isset( $_POST[ $this->meta_box_name . '_custom_label_text_new_field' ] ) ) {
				if ( $value ) {
					delete_post_meta( $post_id, '_' . $this->meta_box_name . '_custom_label_text_' . get_post_type(), 1 );
				}
			} else {
				// Sanitize user input.
				$my_data = sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_custom_label_text_new_field' ] ) );

				// Update the meta field in the database.
				update_post_meta( $post_id, '_' . $this->meta_box_name . '_custom_label_text_' . get_post_type(), $my_data );
			}

			/*
			 * Custom Before Content Text
			 */
			$value = get_post_meta( $post_id, '_' . $this->meta_box_name . '_custom_before_content_text_' . get_post_type(), true );

			// 値がポストされていなかったら
			if ( ! isset( $_POST[ $this->meta_box_name . '_custom_before_content_text_new_field' ] ) ) {
				if ( $value ) {
					delete_post_meta( $post_id, '_' . $this->meta_box_name . '_custom_before_content_text_' . get_post_type(), 1 );
				}
			} else {
				// Sanitize user input.
				$my_data = sanitize_text_field( wp_unslash( $_POST[ $this->meta_box_name . '_custom_before_content_text_new_field' ] ) );

				// Update the meta field in the database.
				update_post_meta( $post_id, '_' . $this->meta_box_name . '_custom_before_content_text_' . get_post_type(), $my_data );
			}

		}

	}
}

$output = new NISHIKI_PRO_META_BOX_PR();
