<?php
if ( ! class_exists( 'NISHIKI_PRO_META_OGP_ADMIN' ) ) {
	/**
	 * OGP
	 */
	class NISHIKI_PRO_META_OGP_ADMIN {
		/**
		 * Holds the options to be used in the fields callbacks
		 *
		 * @var 0.0.1
		 */
		private $options;

		/**
		 * Holds plugin name
		 *
		 * @var 0.0.1
		 */
		private $plugin_name = 'nishiki_pro_meta_ogp';

		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'nishiki_pro_meta_ogp_admin_menu' ), 20 );

			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_pro_meta_ogp_register_settings' ), 20 );

		}

		/**
		 * サブメニュー追加
		 */
		public function nishiki_pro_meta_ogp_admin_menu() {
			add_submenu_page(
				'nishiki-pro-general.php',
				'OGP',
				'OGP',
				'manage_options',
				'nishiki-pro-meta-ogp.php',
				array( $this, 'nishiki_pro_meta_ogp_admin_page' )
			);
		}

		/**
		 * フォームの設定
		 *
		 * @return void
		 */
		public function nishiki_pro_meta_ogp_register_settings() {

			register_setting(
				$this->plugin_name,
				'nishiki_pro_meta_ogp',
				array( $this, 'sanitize' )
			);

			add_settings_section(
				'nishiki_pro_meta_ogp_general',
				__( '出力設定', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_meta_ogp_general_cb' ),
				$this->plugin_name
			);

			add_settings_field(
				'active',
				__( '出力するOGPにチェック', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_meta_ogp_active_cb' ),
				$this->plugin_name,
				'nishiki_pro_meta_ogp_general',
				array( 'label_for' => 'active' )
			);

		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			if ( isset( $input['active'] ) ) {
					$new_input['active'] = array_map( 'strip_tags', $input['active'] );
			}

			// wp_die(var_dump($new_input));
			return $new_input;
		}


		/**
		 * フォームの出力
		 */
		public function nishiki_pro_meta_ogp_general_cb() {
			$nonce = wp_create_nonce( 'nishiki_pro_meta_ogp' );
			echo '<input type="hidden" name="nishiki_pro_meta_ogp" value="' . esc_attr( $nonce ) . '" />';
		}

		/**
		 * 出力設定
		 */
		public function nishiki_pro_meta_ogp_active_cb() {
			$this->options = get_option( 'nishiki_pro_meta_ogp' );
			// var_dump(get_option( 'nishiki_pro_meta_ogp' ));

			$ogp_array = array(
				'ogp'      => 'OGP共通',
				'twitter'  => 'Twitter Cards',
				'facebook' => 'Facebook',
			);

			if ( isset( $this->options['active'] ) ) {
				$checked = ' checked="checked"';
			} else {
				$checked = '';
			}
			echo '<ul>';
			foreach ( $ogp_array as $ogp => $label ) {
				$ogp_checked = '';
				if ( isset( $this->options['active'] ) ) {
					if ( array_key_exists( $ogp, $this->options['active'] ) ) {
						$ogp_checked = ' checked="checked"';
					}
				}

				echo '<li><input type="checkbox" id="' . esc_attr( $ogp ) . '" name="nishiki_pro_meta_ogp[active][' . esc_attr( $ogp ) . ']" value="1"' . esc_attr( $ogp_checked ) . '><label for="' . esc_attr( $ogp ) . '">' . esc_html( $label ) . '</label></li>';
			}
			echo '</ul>';
		}

		/**
		 * オプションページの内容
		 */
		public function nishiki_pro_meta_ogp_admin_page() {
			$this->options = get_option( 'nishiki_pro_meta_ogp' );
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( 'このページを表示する権限がありません。' );
			}
			?>
			<div class="wrap">
				<h1>OGP 設定</h1>
				<p>OGP（Open Graph Protocol）を出力するための設定をします。Twitter,Facebookにウェブサイトを投稿した際のタイトル、画像、抜粋などをデザインします。</p>
				<p>詳細設定は「外観」→「カスタマイズ」→「[Nishiki Pro] オプション」→「OGP」で行なってください。</p>
				<hr>
				<form method="post" action="options.php">
					<?php
					settings_fields( $this->plugin_name );
					do_settings_sections( $this->plugin_name );
					submit_button();
					?>
				</form>
				<hr>
				<h3>マニュアルを見る</h3>
				<p><a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-meta-function/">操作マニュアル</a></p>
			</div>
			<?php
		}
	}

	if ( is_admin() ) {
		$nishiki_pro_meta_ogp_page = new NISHIKI_PRO_META_OGP_ADMIN();
	}
}
