<?php
if ( ! class_exists( 'NISHIKI_PRO_MULTIPLE_SEARCH_ADMIN' ) ) {
	/**
	 * 絞り込み検索（管理画面）
	 */
	class NISHIKI_PRO_MULTIPLE_SEARCH_ADMIN extends NISHIKI_PRO_MULTIPLE_SEARCH_UTILITY {

		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_menu', array( $this, 'add_menu' ), 10 );
		}

		/**
		 * メニュー追加
		 */
		public function add_menu() {
			add_submenu_page(
				'nishiki-pro-general.php',
				'絞り込み検索',
				'絞り込み検索',
				'manage_options',
				'nishiki-pro-filter-search.php',
				array( $this, 'add_page' )
			);
		}

		/**
		 * 設定画面出力
		 */
		public function create_setting() {
			settings_fields( $this->plugin_name );
			do_settings_sections( $this->plugin_name );
		}

		/**
		 * オプションページの内容
		 */
		public function add_page() {
			$this->options = get_option( $this->plugin_name );
			if ( ! current_user_can( 'manage_options' ) ) {
				wp_die( 'このページを表示する権限がありません。' );
			}
			?>
			<div class="wrap">
				<h1>絞り込み検索</h1>
				<form method="post" action="options.php" name="nishiki_pro_multiple_search">
					<?php $this->create_setting(); ?>
					<p>
						<input type="button" class="button button-secondary" value="全てにチェック" onclick="allcheck(true);">
						<input type="button" class="button button-secondary" value="全てのチェックを外す" onclick="allcheck(false);">
					</p>
					<script>
						function allcheck( flag ) {
							var ElementsCount = document.nishiki_pro_multiple_search.elements.length;
							for( i=0 ; i < ElementsCount ; i++ ) {
								document.nishiki_pro_multiple_search.elements[i].checked = flag;
							}
						}
					</script>
					<?php submit_button() ;?>
				</form>
				<hr>
				<h3>マニュアルを見る</h3>
				<p><a target="_blank" rel="noopener noreferrer" class="button" href="https://support.animagate.com/manual/wp-nishiki-filter-search/">操作マニュアル</a></p>
			</div>
			<?php
		}
	}

	if ( is_admin() ) {
		$output = new NISHIKI_PRO_MULTIPLE_SEARCH_ADMIN();
	}
}
