<?php
if ( ! class_exists( 'NISHIKI_PRO_MULTIPLE_SEARCH_SC' ) ) {
	/**
	 * CONTENT Shortcode.
	 */
	class NISHIKI_PRO_MULTIPLE_SEARCH_SC extends NISHIKI_PRO_MULTIPLE_SEARCH_UTILITY {

		/**
		 * Construct
		 */
		public function __construct() {
			add_shortcode( 'nishiki_pro_multiple_search', array( $this, 'nishiki_pro_multiple_search_sc' ) );
		}

		/**
		 * ショートコード作成
		 *
		 * @param array $atts 属性
		 * @return $html
		 */
		public function nishiki_pro_multiple_search_sc( $atts ) {
			$html = '';

			$options    = get_option( 'nishiki_pro_multiple_search' );
			$taxonomies = $this->get_taxonomies( 'objects' );
			$args       = array(
				'hide_empty' => false,
			);

			$html .= '<section class="nishiki-pro-filter-search">';
			$html .= '<form class="wp-block-search multiple" role="search" method="get" action="' . esc_url( home_url( '/' ) ) . '">';
			$html .= '<div class="search-inner">';
			$html .= apply_filters( 'nishiki_pro_before_multiple_search_inner_content', '' );
			$html .= '<input class="wp-block-search__input" type="text" value="' . esc_attr( get_search_query() ) . '" name="s" id="s" placeholder="' . __( 'Enter a term to search.', 'nishiki-pro' ) . '">';
			if ( $taxonomies ) {

				foreach ( $taxonomies  as $taxonomy ) {
					$taxonomy_name = $taxonomy->name;

					if ( ! empty( $options[ $taxonomy_name ]['display'] ) && ! empty( $taxonomy->show_in_rest ) ) {

						//フォームの表示タイプごとに checkbox, radio, select を出力する
						$form_input_type = 'checkbox';

						if( ! empty( $options[ $taxonomy_name ]['formInputType'] ) ){
							$form_input_type = $options[ $taxonomy_name ]['formInputType'];
						}

						$terms = apply_filters( 'nishiki_pro_multiple_search_terms', get_terms( $taxonomy_name, $args ), $taxonomy_name, $args );

						if ( $terms ) {
							$taxonomy_label = $taxonomy->label;

							if ( ! empty( $options[ $taxonomy_name ]['label'] ) ) {
								$taxonomy_label = $options[ $taxonomy_name ]['label'];
							}

							$html .= '<div class="taxonomy taxonomy-' . esc_html( $taxonomy_name ) . '">';
							$html .= '<p class="title">' . esc_html( $taxonomy_label ) . '</p>';

							switch( $form_input_type ){
								case 'checkbox':

									$html .= self::create_checkbox( $options, $taxonomy_name, $terms );

									break;

								case 'radio':

									$html .= self::create_radio( $options, $taxonomy_name, $terms );

									break;

								case 'select':

									$html .= self::create_selectbox( $options, $taxonomy_name, $terms );

									break;
							}
							/*
							foreach ( $terms as $term ) {
								$term_checked = '';
								if ( ! empty( $options[ $taxonomy ]['terms'] ) && is_array( $options[ $taxonomy ]['terms'] ) ) {
									if ( array_key_exists( $term->term_id, $options[ $taxonomy ]['terms'] ) ) {
										if ( ! empty( get_query_var( 'term_id' ) ) ) {
											if ( in_array( strval( $term->term_id ), get_query_var( 'term_id' ), true ) ) {
												$term_checked = ' checked';
											}
										}

										if ( ! empty( $options['multiple_search_display_count'] ) ) {
											$term_count = '(' . $term->count . ')';
										} else {
											$term_count = '';
										}

										$html .= '<label><input type="checkbox" name="term_id[]" value="' . esc_attr( $term->term_id ) . '"' . esc_attr( $term_checked ) . '>' . $term->name . $term_count . '</label>';
									}
								}
							}
							*/

							$html .= '</div>';
						}
					}
				}
			}

			$html .= '<div class="relation center flex justify-center">';
			$relation_array = array(
				'or'  => __( 'Find any word', 'nishiki-pro' ),
				'and' => __( 'Find all words', 'nishiki-pro' ),
			);
			foreach ( $relation_array as $key => $val ) {
				$relation_checked = '';
				if ( ! empty( get_query_var( 'relation' ) ) ) {
					if ( get_query_var( 'relation' ) === $key ) {
						$relation_checked = ' checked="checked"';
					}
				} else {
					if ( 'or' === $key ) {
						$relation_checked = ' checked="checked"';
					}
				}

				$html .= '<label><input type="radio" name="relation" value="' . esc_attr( $key ) . '"' . esc_attr( $relation_checked ) . '>' . esc_html( $val ) . '</label>';
			}

			$html .= '</div>';

			$html .= '<div class="submit center"><button class="btn" type="submit" id="searchsubmit">' . __( 'Narrow down the conditions and search.', 'nishiki-pro' ) . '</button></div>';
			$html .= apply_filters( 'nishiki_pro_after_multiple_search_inner_content', '' );
			$html .= '</div>';
			$html .= '</form>';
			$html .= '</section>';

			return do_action( 'nishiki_pro_before_multiple_search_content' ) . $html . do_action( 'nishiki_pro_after_multiple_search_content' );
		}

		/**
		 * フォーム作成（チェックボックス）
		 */
		public function create_checkbox( $options, $taxonomy, $terms ){
			$output = '';

			$name = 'checkbox_' . $taxonomy;

			foreach ( $terms as $term ) {
				$term_checked = '';
				if ( ! empty( $options[ $taxonomy ]['terms'] ) && is_array( $options[ $taxonomy ]['terms'] ) ) {
					if ( array_key_exists( $term->term_id, $options[ $taxonomy ]['terms'] ) ) {
						if ( ! empty( get_query_var( $name ) ) ) {
							if ( in_array( strval( $term->term_id ), get_query_var( $name ), true ) ) {
								$term_checked = ' checked';
							}
						}

						if ( ! empty( $options['multiple_search_display_count'] ) ) {
							$term_count = '(' . $term->count . ')';
						} else {
							$term_count = '';
						}

						$output .= '<label><input type="checkbox" name="' . esc_attr( $name ) . '[]" value="' . esc_attr( $term->term_id ) . '"' . esc_attr( $term_checked ) . '>' . esc_html( $term->name . $term_count ) . '</label>';
					}
				}
			}

			return $output;
		}

		/**
		 * フォーム作成（ラジオボタン）
		 */
		public function create_radio( $options, $taxonomy, $terms ){
			$output = '';
			$item_num = '';
			$checked_flag = false;
			$no_checked = '';

			$name = 'radio_' . $taxonomy;

			foreach( $terms as $term ){
				// タームデータ取得
				$term_data = get_term( $term, $taxonomy );

				// query の中からタームのデータに合うものを checked する
				global $wp_query;

				$checked = '';

				if ( ! empty( $options[ $taxonomy ]['terms'] ) && is_array( $options[ $taxonomy ]['terms'] ) ) {
					if ( array_key_exists( $term->term_id, $options[ $taxonomy ]['terms'] ) ) {
						if( ! is_admin() ){
							foreach( $wp_query->query as $key => $val ){
								if( $key == $name ){
									if( ! empty( $val ) && ! is_array( $val ) ){
										if( strval( $term_data->term_id ) === $val ){
											$checked = ' checked';
											$checked_flag = true;
										}
									}
								}
							}
						}
		
						if ( ! empty( $options['multiple_search_display_count'] ) ) {
							$item_num = '(' . $term_data->count . ')';
						} else {
							$item_num = '';
						}
		
						$output .= '<label class="radio">';
						$output .= '<input type="radio" name="' . esc_attr( $name ) . '" value="' . absint( $term_data->term_id ) . '"' . esc_attr( $checked ) . '>' . esc_html( $term_data->name . $item_num );
						$output .= '</label>';
					}
				}
			}

			if( false === $checked_flag ){
				$no_checked = ' checked';
			}

			if( ! empty( $output ) ){
				$output = '<label class="radio"><input type="radio" name="' . esc_attr( $name ) . '" value=""' . esc_attr( $no_checked ) . '>指定なし</label>' . $output;
			}

			return $output;
		}

		/**
		 * フォーム作成（セレクトボックス）
		 */
		public function create_selectbox( $options, $taxonomy, $terms ){
			$output = '';
			$item_num = '';
			$select_options = '';
			$selected_flag = false;
			$no_selected = '';

			$name = 'select_' . $taxonomy;

			foreach( $terms as $term ){
				// タームデータ取得
				$term_data = get_term( $term, $taxonomy );

				// query の中からタームのデータに合うものを checked する
				global $wp_query;

				$selected = '';
				
				if ( ! empty( $options[ $taxonomy ]['terms'] ) && is_array( $options[ $taxonomy ]['terms'] ) ) {
					if ( array_key_exists( $term->term_id, $options[ $taxonomy ]['terms'] ) ) {
						if( ! is_admin() ){
							foreach( $wp_query->query as $key => $val ){
								if( $key == $name ){
									if( ! empty( $val ) && ! is_array( $val ) ){
										if( strval( $term_data->term_id ) === $val ){
											$selected = ' selected';
											$selected_flag = true;
										}
									}
								}
							}
						}
		
						if ( ! empty( $options['multiple_search_display_count'] ) ) {
							$item_num = '(' . $term_data->count . ')';
						} else {
							$item_num = '';
						}
		
						$select_options .= '<option value="' . absint( $term_data->term_id ) . '"' . esc_attr( $selected ) . '>' . esc_html( $term_data->name . $item_num ) . '</option>';		
					}
				}

			}

			if( false === $selected_flag ){
				$no_selected = ' selected';
			}

			if( ! empty( $select_options ) ){
				$select_options = '<option value=""' . esc_attr( $no_selected ) . '>指定なし</option>' . $select_options;

				$output .= '<label class="select">';
				$output .= '<div class="select-inner">';
				$output .= '<select name="' . esc_attr( $name ) . '">';
				$output .= $select_options;
				$output .= '</select>';
				$output .= '</div>';
				$output .= '</label>';
			}

			return $output;
		}
	}
}

$shortcode = new NISHIKI_PRO_MULTIPLE_SEARCH_SC();
