<?php
if ( ! class_exists( 'NISHIKI_PRO_MULTIPLE_SEARCH_UTILITY' ) ) {
	/**
	 * 絞り込み検索（ユーティリティ）
	 */
	class NISHIKI_PRO_MULTIPLE_SEARCH_UTILITY extends NISHIKI_PRO_MULTIPLE_SEARCH_UTILITY_FORM {
		/**
		 * Holds plugin name
		 *
		 * @var 0.0.1
		 */
		public $options;

		/**
		 * 名前
		 *
		 * @var string
		 */
		public $plugin_name = 'nishiki_pro_multiple_search';

		/**
		 * フォーム作成（単数チェック）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function multiple_search_checkbox_cb( $args ) {
			$this->options = get_option( $args['page_name'] );

			$this->create_form_multiple_search_checkbox( $args['title'], $args['label'], $args['page_name'] );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 * フォーム作成（テキスト）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function multiple_search_text_cb( $args ) {
			$this->create_form_multiple_search_text( $args );
		}

		/**
		 * フォーム作成（テキストエリア）
		 *
		 * @param array $args 設定
		 * @return void
		 */
		public function multiple_search_cb( $args ) {
			$this->options = get_option( $args['page_name'] );

			$this->create_form_multiple_search( $args['title'], $args['label'], $args['page_name'], $args['taxonomy'] );

			if ( ! empty( $args['description'] ) ) {
				echo '<p class="description">' . esc_html( $args['description'] ) . '</p>';
			}
		}

		/**
		 * カスタム投稿タイプかどうかチェック
		 *
		 * @return boolean
		 */
		public function is_custom_post_type() {
			$post_obj = get_post_type_object( get_post_type() );
			if ( ! empty( $post_obj ) && false === $post_obj->_builtin ) {
				return $post_obj;
			} else {
				return false;
			}
		}

		/**
		 * カスタムタクソノミー全部取得
		 *
		 * @param string $output 取得するデータ names | objects
		 * @return $result
		 */
		public function get_taxonomies( $output = 'names' ) {
			
			$args             = array(
				'public'   => true,
			);

			$operator   = 'and'; // 'and' or 'or'
			$taxonomies = get_taxonomies( $args, $output, $operator );

			return $taxonomies;
		}

	}
}
