<?php
if ( ! class_exists( 'NISHIKI_PRO_PROFILE' ) ) {
	/**
	 * Create.
	 */
	class NISHIKI_PRO_PROFILE extends NISHIKI_PRO_GENERAL_UTILITY {

		/**
		 * 初期設定
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_pro_register_settings' ), 20 );

			// ソーシャルプロフィール出力
			add_action( 'nishiki_pro_after_single_author_description', array( $this, 'output_user_social' ) );

			// 連絡先情報に入力欄追加
			add_filter( 'user_contactmethods', array( $this, 'nishiki_pro_contact_methods' ), 20, 1 );
		}

		/**
		 * ソーシャル一覧
		 *
		 * @var array
		 */
		public $user_social = array(
			'twitter'   => 'Twitter URL',
			'x'         => 'X URL',
			'facebook'  => 'Facebook個人ページ URL',
			'instagram' => 'Instagram URL',
			'youtube'   => 'YouTube URL',
			'amazon'    => 'Amazon URL',
			'pinterest' => 'Pinterest URL',
			'github'    => 'GitHub URL',
			'steam'     => 'Steam URL',
			'twitch'    => 'Twitch URL',
		);

		/**
		 * Add contact methods.
		 *
		 * @param array $user_contact 配列
		 * @return $user_contact
		 */
		public function nishiki_pro_contact_methods( $user_contact ) {
			// 入力欄追加
			foreach ( $this->user_social as $key => $label ) {
				$user_contact[ 'nishiki_pro_user_social_' . $key ] = $label;
			}

			return $user_contact;
		}

		/**
		 * フォーム追加
		 */
		public function nishiki_pro_register_settings() {
			$page_name = $this->plugin_name . '_profile';

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				'',
				array( $this, 'nishiki_pro_general_cb' ),
				$page_name
			);

			add_settings_field(
				'enable',
				__( '投稿ページの著者の情報にウェブサイト＋ソーシャルアカウントを表示する', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_checkbox_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '有効化',
					'label'       => 'enable',
					'page_name'   => $page_name,
					'description' => '有効にする場合はチェックを入れてください。設定は WordPress の管理画面から「ユーザー」→「あなたのプロフィール」の連絡先情報の項目で設定してください。',
				)
			);
		}

		/**
		 * 出力
		 */
		public function output_user_social() {
			if ( $this->is_nishiki_pro_user_social() ) {
				echo '<div id="nishiki-pro-user-profile-wrapper">';
				
				global $post;

				// $post_author_id = get_the_author_meta('ID');
				$post_author_id = $post->post_author;
				$website        = get_the_author_meta( 'user_url', $post_author_id );

				if ( ! empty( $website ) ) {
					echo '<a class="profile-website" aria-label="' . esc_url( $website ) . '" target="_blank" rel="noopener noreferrer" href="' . esc_url( $website ) . '"><i class="icomoon icon-earth"></i></a>';
				}

				foreach ( $this->user_social as $key => $label ) {
					$profile = get_user_meta( $post_author_id, 'nishiki_pro_user_social_' . $key, true );

					if ( ! empty( $profile ) ) {
						echo '<a class="profile-' . esc_attr( $key ) . '" aria-label="' . esc_attr( $key ) . '" target="_blank" rel="noopener noreferrer" href="' . esc_url( $profile ) . '"><i class="icomoon icon-' . esc_html( $key ) . '"></i></a>';
					}
				}
				
				echo '</div>';
			}
		}

		/**
		 *
		 * 表示設定チェック
		 */
		public function is_nishiki_pro_user_social() {
			$options = get_option( $this->plugin_name . '_profile' );

			if ( empty( $options ) ) {
				return false;
			}

			if ( empty( $options['enable'] ) ) {
				return false;
			}

			return $options;
		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			// チェックボックス
			if ( isset( $input['enable'] ) ) {
				$new_input['enable'] = absint( $input['enable'] );
			}

			return $new_input;
		}

	}

	$output = new NISHIKI_PRO_PROFILE();
}

