<?php
if ( ! class_exists( 'NISHIKI_PRO_REDIRECT' ) ) {
	/**
	 * Create Class.
	 */
	class NISHIKI_PRO_REDIRECT extends NISHIKI_PRO_GENERAL_UTILITY {

		/**
		 * 初期設定
		 */
		public function __construct() {
			// フォーム追加
			add_action( 'admin_init', array( $this, 'nishiki_pro_register_settings' ), 20 );
		}

		/**
		 * フォームの登録
		 */
		public function nishiki_pro_register_settings() {
			$page_name = $this->plugin_name . '_redirect';

			register_setting(
				$page_name,
				$page_name,
				array( $this, 'sanitize' )
			);

			add_settings_section(
				$page_name,
				'',
				array( $this, 'nishiki_pro_general_cb' ),
				$page_name
			);

			add_settings_field(
				'page',
				__( 'リダイレクトする', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_checkbox_multiple_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'page',
					'page_name'   => $page_name,
					'description' => 'リダイレクトしたいページにチェックを入れてください。',
					'script'      => array(
						'404'        => '404 ページ',
						'author'     => '著者のアーカイブページ',
						'search'     => '検索結果ページ',
						'attachment' => '添付ファイルのページ',
					),
					'display_key' => false,
				)
			);

			add_settings_field(
				'url',
				__( 'リダイレクト先の URL（上級者向け）', 'nishiki_pro' ),
				array( $this, 'nishiki_pro_text_cb' ),
				$page_name,
				$page_name,
				array(
					'title'       => '',
					'label'       => 'url',
					'page_name'   => $page_name,
					'placeholder' => esc_url( get_home_url() ),
					'description' => '空欄の場合はホーム URL（' . home_url() . '） にリダイレクトします。安全な URL にリダイレクトするため、外部ドメインは指定できません。よくわからない場合は、空欄のままにしてください。',
				)
			);
		}

		/**
		 * 入力値のサニタイズ
		 *
		 * @param array $input Contains all settings fields as array keys
		 */
		public function sanitize( $input ) {
			$new_input = array();

			// wp_die(var_dump($input) );

			if ( isset( $input ) ) {
				foreach ( $input as $key => $val ) {
					// 配列の場合
					if ( is_array( $input[ $key ] ) ) {
						$new_input[ $key ] = array_map( 'absint', $input[ $key ] );
					} else {
						// 通常の場合
						$new_input[ $key ] = esc_url( $input[ $key ] );
					}
				}
			}

			return $new_input;
		}

	}
}

$output = new NISHIKI_PRO_REDIRECT();
