<?php
if ( ! function_exists( 'nishiki_pro_init_customizer_campaign' ) ) {
	add_action( 'customize_register', 'nishiki_pro_init_customizer_campaign' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_init_customizer_campaign( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
			array(
				'title'    => __( 'Campaign Link', 'nishiki-pro' ),
				'priority' => 600,
				'panel'    => 'panel_' . NISHIKI_PRO_PREFIX,
			)
		);

		// Display Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">表示</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_header',
				)
			)
		);

		$campaign_default_display_page = array(
			'top'      => 'トップページ',
			'singular' => '投稿 / 固定 / カスタム投稿ページ',
			'archive'  => 'アーカイブページ',
			'404'      => '404 ページ',
			'search'   => '検索結果ページ',
		);

		foreach ( $campaign_default_display_page as $key => $page ) {
			// Display Page
			$wp_customize->add_setting(
				'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_' . $key,
				array(
					'default'           => false,
					'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
				)
			);

			$wp_customize->add_control(
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_' . $key,
				array(
					'label'    => $page,
					'type'     => 'checkbox',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_display_page_' . $key,
				)
			);
		}

		// Text Link Target
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link_target',
			array(
				'default'           => false,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link_target',
			array(
				'label'    => __( 'Open New Tab', 'nishiki-pro' ),
				'type'     => 'checkbox',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link_target',
			)
		);

		// Layout Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_layout_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_layout_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">レイアウト</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_layout_header',
				)
			)
		);

		// Header Layout
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_layout',
			array(
				'default'           => 'text-button',
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_campaign_layout',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Image_Radio_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_layout',
				array(
					'label'    => '',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_layout',
					'type'     => 'select',
					'choices'  => array(
						'text-button' => 'data:image/png;base64,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
',
						'button-text' => 'data:image/png;base64,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
',
					),
				)
			)
		);

		// Text Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">テキスト</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_header',
				)
			)
		);

		// Text
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text',
			array(
				'default'           => __( 'Text', 'nishiki-pro' ),
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text',
			array(
				'label'    => __( 'Text', 'nishiki-pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text',
			)
		);

		// Text Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_color',
			array(
				'default'           => '#ffffff',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_color',
				array(
					'label'    => __( 'Text Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_color',
				)
			)
		);

		// Text Hover Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_hover_color',
			array(
				'default'           => '#eeeeee',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_hover_color',
				array(
					'label'    => __( 'Text Hover Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_hover_color',
				)
			)
		);

		// Text Link
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link',
			array(
				'label'       => __( 'Text link', 'nishiki-pro' ),
				'description' => __( '※日本語 URL は使用できません。', 'nishiki-pro' ),
				'type'        => 'text',
				'section'     => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
				'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link',
			)
		);

		// Text Link Target
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link_target',
			array(
				'default'           => false,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link_target',
			array(
				'label'    => __( 'Open New Tab', 'nishiki-pro' ),
				'type'     => 'checkbox',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_text_link_target',
			)
		);

		// Button Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">ボタン</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_header',
				)
			)
		);

		// Button Text
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text',
			array(
				'default'           => __( 'Button Text', 'nishiki-pro' ),
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text',
			array(
				'label'    => __( 'Button Text', 'nishiki-pro' ),
				'type'     => 'text',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text',
			)
		);

		// Button Text Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text_color',
			array(
				'default'           => '#444444',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text_color',
				array(
					'label'    => __( 'Button Text Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text_color',
				)
			)
		);

		// Button Text Hover Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text_hover_color',
			array(
				'default'           => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text_hover_color',
				array(
					'label'    => __( 'Button Text Hover Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_text_hover_color',
				)
			)
		);

		// Button Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_color',
			array(
				'default'           => '#ffffff',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_color',
				array(
					'label'    => __( 'Button Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_color',
				)
			)
		);

		// Button Hover Color
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_hover_color',
			array(
				'default'           => '#eeeeee',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_hover_color',
				array(
					'label'    => __( 'Button Hover Color', 'nishiki-pro' ),
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_hover_color',
				)
			)
		);

		// Button Text Link
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_link',
			array(
				'label'       => __( 'Button link', 'nishiki-pro' ),
				'description' => __( '※日本語 URL は使用できません。', 'nishiki-pro' ),
				'type'        => 'text',
				'section'     => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
				'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_link',
			)
		);

		// Button Text Link Target
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_link_target',
			array(
				'default'           => false,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_link_target',
			array(
				'label'    => __( 'Open New Tab', 'nishiki-pro' ),
				'type'     => 'checkbox',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_link_target',
			)
		);

		// Button Radius
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_radius',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_number_range',
				'default'           => 4,
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Range(
				$wp_customize,
				'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_radius',
				array(
					'label'    => __( 'コーナーの角丸（px）', 'nishiki-pro' ),
					'min'      => 0,
					'max'      => 100,
					'step'     => 1,
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_button_radius',
				)
			)
		);

		// Background Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">背景</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_header',
				)
			)
		);

		// Background Type
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_type',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_choices_campaign_background_type',
				'default'           => 'single-color',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_type',
			array(
				'label'       => __( 'Type', 'nishiki-pro' ),
				'description' => __( '※選択したタイプによって、有効になるカラー設定が異なります。', 'nishiki-pro' ),
				'section'     => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
				'settings'    => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_type',
				'type'        => 'select',
				'choices'     => array(
					'single-color' => __( '単色', 'nishiki-pro' ),
					'dot'          => __( 'ドット', 'nishiki-pro' ),
					'polka-dot'    => __( '水玉ドット', 'nishiki-pro' ),
					'stripe'       => __( 'ストライプ', 'nishiki-pro' ),
					'check'        => __( 'チェック', 'nishiki-pro' ),
				),
			)
		);

		// Background Color
		for ( $i = 1; $i <= 3; ++$i ) {

			$campaign_default_background_color = array(
				'#8b65a3',
				'#a6a3ba',
				'',
			);

			$wp_customize->add_setting(
				'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_color_' . sprintf( '%02d', $i ),
				array(
					'default'           => $campaign_default_background_color[ $i - 1 ],
					'sanitize_callback' => 'sanitize_hex_color',
				)
			);

			$wp_customize->add_control(
				new WP_Customize_Color_Control(
					$wp_customize,
					'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_color_' . sprintf( '%02d', $i ),
					array(
						'label'    => 'カラー' . sprintf( '%02d', $i ),
						'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
						'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_background_color_' . sprintf( '%02d', $i ),
					)
				)
			);
		}

		// Animation Header
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_header',
			array(
				'sanitize_callback' => 'nishiki_pro_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new Nishiki_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_header',
				array(
					'label'    => '<p class="nishiki-pro-customizer-heading">アニメーション</p>',
					'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
					'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_header',
				)
			)
		);

		// Animation Text Typewriting
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_text_typewriter',
			array(
				'default'           => false,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_text_typewriter',
			array(
				'label'    => __( 'Typewriter(Text)', 'nishiki-pro' ),
				'type'     => 'checkbox',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_text_typewriter',
			)
		);

		// Animation Button Shine
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_button_shine',
			array(
				'default'           => false,
				'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			'ctrl_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_button_shine',
			array(
				'label'    => __( 'Shine(Button)', 'nishiki-pro' ),
				'type'     => 'checkbox',
				'section'  => 'section_' . NISHIKI_PRO_PREFIX_CAMPAIGN,
				'settings' => 'setting_' . NISHIKI_PRO_PREFIX_CAMPAIGN . '_animation_button_shine',
			)
		);

	}
}
