<?php
/**
 * Add CSS
 *
 * @return $output
 */
function nishiki_pro_css_button() {
	$output = '';

	// Button
	$nishiki_pro_btn_type = esc_html( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_type', 'simple' ) );
	switch ( $nishiki_pro_btn_type ) {
		case 'mild':
			$output .= nishiki_pro_css_button_design( 'mild' ) . '
				{border-radius:4px;}
			';
			break;
		case 'custom':
			$nishiki_pro_btn_radius = absint( get_theme_mod( 'setting_' . NISHIKI_PRO_PREFIX_DESIGN . '_btn_radius', 30 ) );
			$output                .= nishiki_pro_css_button_design( 'custom' ) . "
				{border-radius:{$nishiki_pro_btn_radius}px;}
			";
			break;
	}

	return $output;
}

/**
 * ボタンデザイン
 *
 * @param string $type タイプ
 * @return $output
 */
function nishiki_pro_css_button_design( $type ) {
	$output = "
		body.nishiki-pro-design-btn-{$type} button.icon,
		body.nishiki-pro-design-btn-{$type} .search-box button,
		body.nishiki-pro-design-btn-{$type} .search-box input,
		body.nishiki-pro-design-btn-{$type} button.close,
		body.nishiki-pro-design-btn-{$type} a.btn,
		body.nishiki-pro-design-btn-{$type} .nishiki-pro-social-button-inner a,
		body.nishiki-pro-design-btn-{$type} .widget .tagcloud a,
		body.nishiki-pro-design-btn-{$type} .widget .wp-block-tag-cloud a,
		body.nishiki-pro-design-btn-{$type} .comments-area #respond input[type=submit]
	";

	return $output;
}
