<?php
if ( ! function_exists( 'nishiki_pro_init_customizer_support' ) ) {
	add_action( 'customize_register', 'nishiki_pro_init_customizer_support' );
	/**
	 * カスタマイザーの設定
	 *
	 * @param instance $wp_customize インスタンス
	 * @return void
	 */
	function nishiki_pro_init_customizer_support( $wp_customize ) {

		// Section
		$wp_customize->add_section(
			'section_' . NISHIKI_PRO_PREFIX_SUPPORT,
			array(
				'title'    => __( 'テーマサポート', 'nishiki_pro' ),
				'priority' => 600,
				'panel'    => 'panel_' . NISHIKI_PRO_PREFIX,
			)
		);

		// Wrapper
		$wp_customize->add_setting(
			'setting_' . NISHIKI_PRO_PREFIX_SUPPORT . '_text',
			array(
				'sanitize_callback' => 'nishiki_sanitize_text',
			)
		);

		$wp_customize->add_control(
			new NISHIKI_PRO_WP_Customize_Content(
				$wp_customize,
				'ctrl_' . NISHIKI_PRO_PREFIX_SUPPORT . '_text',
				array(
					'label'         => '',
					'start_content' => 'Nishiki テーマ・専用プラグインをご利用の方に向けて以下のサービスを用意しています。ウェブサイト運営にご活用ください。',
					'content'       => '<ul class="nishiki_theme_support"><li><a target="_blank" rel="noopener noreferrer" href="https://support.animagate.com/manual/wp-nishiki/">テーマ操作マニュアル</a></li><li><a target="_blank" href="https://support.animagate.com/manual/wp-nishiki-growing-beauty/">プラグイン操作マニュアル</a></li><li><a  target="_blank" href="https://support.animagate.com/community/">ユーザーコミュニティ</a></li><li><a target="_blank" href="https://support.animagate.com/personal/product/wp-nishiki/">個別サポート</a></li><li><a class="primary" target="_blank" href="https://support.animagate.com/product/wp-nishiki-growing-beauty/">拡張プラグイン</a></li></ul>',
					'end_content'   => '',
					'section'       => 'section_' . NISHIKI_PRO_PREFIX_SUPPORT,
					'settings'      => 'setting_' . NISHIKI_PRO_PREFIX_SUPPORT . '_text',
				)
			)
		);

	}
}
