<?php
if ( ! class_exists( 'NISHIKI_PRO_ADMIN_DASHBOARD' ) ) {
	/**
	 * ダッシュボードに表示
	 */
	class NISHIKI_PRO_ADMIN_DASHBOARD {
		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'wp_dashboard_setup', array( $this, 'nishiki_pro_admin_dashboard' ), 5 );
		}

		/**
		 * ウィジェット追加
		 */
		public function nishiki_pro_admin_dashboard() {
			wp_add_dashboard_widget(
				'support-animagate-news',
				__( 'Support Animagate News', 'nishiki-pro' ),
				array( $this, 'support_animagate_news' )
			);

			wp_add_dashboard_widget(
				'support-animagate-manual',
				__( 'Support Animagate Manual', 'nishiki-pro' ),
				array( $this, 'support_animagate_manual' )
			);
		}

		/**
		 * ウィジェット作成
		 */
		public function support_animagate_news() {
			?>
				<p class="read">新サービスのリリース、システムメンテナンスなどをお知らせしています。</p>
			<?php
				echo wp_kses_post( $this->get_feed_items( 'https://support.animagate.com/category/news/feed/' ) );
			?>
			<p><a class="button" target="_blank" rel="noopener noreferrer" href="https://support.animagate.com/news/">お知らせをもっと見る</a></p>
			<?php
		}

		/**
		 * ウィジェット作成
		 */
		public function support_animagate_manual() {
			?>
				<p class="read">ワードプレステーマ Nishiki / Nishiki Pro の機能、ワードプレスの基本的な操作方法、サポトピアのサービス活用方法などを解説したマニュアルです。</p>
			<?php
				echo wp_kses_post( $this->get_feed_items( 'https://support.animagate.com/manual/feed/' ) );
			?>
			<p><a class="button" target="_blank" rel="noopener noreferrer" href="https://support.animagate.com/manual/">マニュアル一覧でもっと見る</a></p>
			<?php
		}

		/**
		 * フィード処理
		 *
		 * @param string $feed_url フィード URL
		 * @return $output
		 */
		public function get_feed_items( $feed_url ) {
			// 取得したURLのフィードのキャッシュがあるかどうかを確認
			$output = get_transient( $feed_url );
			if ( false === $output ) {

				// キャッシュがなかったら取りに行く
				$rss = fetch_feed( $feed_url );

				if ( is_wp_error( $rss ) ) {
					return '<p>情報を取得できませんでした。しばらく経ってから再度読み込んでください。</p>';
				}

				$maxitems  = $rss->get_item_quantity( 5 );
				$rss_items = $rss->get_items( 0, $maxitems );

				$output .= '<ul>';

				foreach ( $rss_items as $item ) {
					$title = $item->get_title();
					$link  = $item->get_permalink();
					$date  = $item->get_date( get_option( 'date_format' ) );

					$output .= '<li><a target="_blank" rel="noopener noreferrer" href="' . $link . '"><span class="date">' . $date . '</span><div class="title">' . $title . '</div></a></li>';
				}

				$output .= '</ul>';

				set_transient( $feed_url, $output, 60 * 60 * 12 );
			}

			return $output;
		}
	}

	if ( is_admin() ) {
		$output = new NISHIKI_PRO_ADMIN_DASHBOARD();
	}
}
