<?php
if ( ! class_exists( 'NISHIKI_PRO_NAV_MENU' ) ) {
	/**
	 * ナビゲーションメニュー追加
	 */
	class NISHIKI_PRO_NAV_MENU {
		/**
		 * 初期設定
		 */
		public function __construct() {
			// オプションページ追加フック
			add_action( 'admin_init', array( $this, 'add_meta_box' ) );
			add_filter( 'wp_setup_nav_menu_item', array( $this, 'setup_nav_menu_item' ) );

			// ナビメニューにカスタムフィールド追加
			add_action( 'wp_nav_menu_item_custom_fields', array( $this, 'add_custom_menu_item' ), 10, 4 );
			add_action( 'wp_update_nav_menu_item', array( $this, 'update_custom_menu_item' ), 10, 4 );
		}

		/**
		 * Meta box 追加
		 *
		 * @return void
		 */
		public function add_meta_box() {
			add_meta_box(
				'nishiki-pro-nav-menus',
				__( '[Nishiki Pro] : Menu', 'nishiki-pro' ),
				array( $this, 'meta_box_content' ),
				'nav-menus',
				'side',
				'low'
			);
		}

		/**
		 * ナビゲーションメニュー設定
		 *
		 * @param array $menu_item メニューアイテム
		 * @return $menu_item
		 */
		public function setup_nav_menu_item( $menu_item ) {
			if ( isset( $menu_item ) ) {
				if ( 'nishiki-pro-nav-menus' === $menu_item->type ) {
					$menu_item->type_label = __( '[Nishiki Pro] : Menu', 'nishiki-pro' );
				}
			}
			return $menu_item;
		}

		/**
		 * Meta box content
		 *
		 * @return void
		 */
		public function meta_box_content() {
			global $nav_menu_selected_id;
			$walker = new Walker_Nav_Menu_Checklist();

			$items = array();

			$menus = array(
				array(
					'name'     => 'search',
					'label'    => __( 'Search(footer)', 'nishiki-pro' ),
					'location' => 'footer',
				),
				array(
					'name'     => 'menu',
					'label'    => __( 'Menu(footer)', 'nishiki-pro' ),
					'location' => 'footer',
				),
			);

			foreach ( $menus as $menu ) {
				$item                   = new stdClass();
				$item->classes          = array();
				$item->title            = $menu['label'];
				$item->attr_title       = $menu['name'];
				$item->type             = 'nishiki-pro-nav-menus';
				$item->object_id        = $menu['name'];
				$item->object           = $menu['name'];
				$item->url              = null;
				$item->db_id            = 0;
				$item->xfn              = null;
				$item->menu_item_parent = null;
				$item->target           = null;

				$items[] = $item;
			}

			echo '<div id="nishiki-pro-nav-menus" class="posttypediv">';
			echo '<div id="tabs-panel-nishiki-pro-nav-menus" class="tabs-panel tabs-panel-active">';
			echo '<ul id="nishiki-pro-nav-menus-checklist" class="categorychecklist form-no-clear">';
			echo walk_nav_menu_tree( array_map( 'wp_setup_nav_menu_item', $items ), 0, (object) array( 'walker' => $walker ) );
			echo '</ul>';
			echo '</div>';
			echo '</div>';
			echo '<p class="button-controls">';
			echo '<span class="add-to-menu">';
			echo '<input type="submit"' . esc_attr( wp_nav_menu_disabled_check( $nav_menu_selected_id ) ) . ' class="button-secondary submit-add-to-menu" value="' . esc_attr__( 'Add to Menu' ) . '" name="add-menu-item" id="submit-nishiki-pro-nav-menus" />';
			echo '</span>';
			echo '</p>';
		}

		/**
		 * Add Custom Field
		 *
		 * @param int $item_id アイテム ID
		 * @return void
		 */
		public function add_custom_menu_item( $item_id ) {
			wp_nonce_field( 'nishiki_pro_custom_attr_nonce', '_nishiki_pro_custom_attr_nonce' );
			$custom_attribute = get_post_meta( $item_id, '_nishiki_pro_custom_attr', true );
			?>
			<input type="hidden" name="nishiki-pro-custom-attr-nonce" value="<?php echo esc_attr( wp_create_nonce( 'nishiki-pro-custom-attr' ) ); ?>" />

			<p class="description description-wide">
				<label for="edit-menu-item-nishiki-pro-custom-attr-<?php echo absint( $item_id ); ?>">
					<?php esc_html_e( '[Nishiki Pro]：カスタム属性', 'nishiki-pro' ); ?>
				</label>
				<br />
				<input type="text" id="edit-menu-item-nishiki-pro-custom-attr-<?php echo absint( $item_id ); ?>" class="widefat edit-menu-item-nishiki-pro-custom-attr" name="menu-item-nishiki-pro-custom-attr[<?php echo absint( $item_id ); ?>]" value="<?php echo esc_attr( $custom_attribute ); ?>" />
				<input type="hidden" value="<?php echo absint( $item_id ); ?>" />
			</p>

			<?php
		}

		/**
		 * Update Custom Field
		 *
		 * @param int $menu_id メニュー ID
		 * @param int $menu_item_db_id メニューアイテム ID
		 * @return $menu_id
		 */
		public function update_custom_menu_item( $menu_id, $menu_item_db_id ) {
			// Verify this came from our screen and with proper authorization.
			if ( ! isset( $_POST['_nishiki_pro_custom_attr_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_nishiki_pro_custom_attr_nonce'] ) ), 'nishiki_pro_custom_attr_nonce' ) ) {
				return $menu_id;
			}

			if ( isset( $_POST['menu-item-nishiki-pro-custom-attr'][ $menu_item_db_id ] ) ) {

				$sanitized_data = sanitize_text_field( wp_unslash( $_POST['menu-item-nishiki-pro-custom-attr'][ $menu_item_db_id ] ) );
				update_post_meta( $menu_item_db_id, '_nishiki_pro_custom_attr', $sanitized_data );
			} else {
				delete_post_meta( $menu_item_db_id, '_nishiki_pro_custom_attr' );
			}
		}
	}

	if ( is_admin() ) {
		$output = new NISHIKI_PRO_NAV_MENU();
	}
}
