<?php
if ( ! class_exists( 'NISHIKI_PRO_WIDGET' ) ) {
	/**
	 * 固定（追尾）ウィジェット
	 */
	class NISHIKI_PRO_WIDGET {
		/**
		 * 初期設定
		 */
		public function __construct() {
			// ウィジェット追加フック
			add_action( 'widgets_init', array( $this, 'add_widget' ), 1 );
		}

		/**
		 * ウィジェット追加
		 *
		 * @return void
		 */
		public function add_widget() {
			// Sticky Widget
			register_sidebar(
				array(
					'name'          => __( 'Sticky Sidebar', 'nishiki-pro' ),
					'id'            => 'sidebar_sticky',
					'before_widget' => '<section id="%1$s" class="widget %2$s">',
					'after_widget'  => '</section>',
					'before_title'  => '<h2>',
					'after_title'   => '</h2>',
				)
			);

			// Mobile Nav Items Widget(before)
			register_sidebar(
				array(
					'name'          => __( 'Mobile before nav items', 'nishiki-pro' ),
					'id'            => 'mobile_before_nav_items',
					'before_widget' => '<section id="%1$s" class="mobile-before-nav-items widget %2$s">',
					'after_widget'  => '</section>',
					'before_title'  => '<h2>',
					'after_title'   => '</h2>',
				)
			);

			// Mobile Nav Items Widget(after)
			register_sidebar(
				array(
					'name'          => __( 'Mobile after nav items', 'nishiki-pro' ),
					'id'            => 'mobile_after_nav_items',
					'before_widget' => '<section id="%1$s" class="mobile-after-nav-items widget %2$s">',
					'after_widget'  => '</section>',
					'before_title'  => '<h2>',
					'after_title'   => '</h2>',
				)
			);
		}
	}

	$output = new NISHIKI_PRO_WIDGET();
}
