<?php
/**
 * インデックス ページ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

get_header();
?>
	<main id="main" class="site-main" role="main" <?php do_action( 'nishiki_pro_main_attributes' ); ?>>
	<?php
	// Front Page Setting
	if ( get_option( 'show_on_front' ) !== 'page' && get_theme_mod( 'setting_top_main_visual_display', true ) === true ) {
		nishiki_pro_get_template_part( 'parts/front/main-visual' );
	} else {
		if ( get_option( 'show_on_front' ) === 'page' ) {
			?>
			<?php do_action( 'nishiki_pro_before_home_header' ); ?>
			<header<?php echo wp_kses_post( apply_filters( 'nishiki_pro_page_header_attributes', '' ) ); ?>>
				<div class="page-header-inner container">
					<h1><?php single_post_title(); ?></h1>
				</div>
			</header>
			<?php do_action( 'nishiki_pro_after_home_header' ); ?>
			<?php
		}
	}
	if ( get_theme_mod( 'setting_top_recently_article_display', true ) ) {
		if ( have_posts() ) {
			?>
			<?php do_action( 'nishiki_pro_before_home_container' ); ?>
			<?php do_action( 'nishiki_pro_before_index_container' ); ?>
			<div class="container column">
			<?php 
				do_action( 'nishiki_pro_before_home_inner_container' );
				nishiki_pro_get_template_part( 'parts/archive/content' );
				do_action( 'nishiki_pro_sidebar' );
				do_action( 'nishiki_pro_after_home_inner_container' );
			?>
			</div>
			<?php do_action( 'nishiki_pro_after_index_container' ); ?>
			<?php do_action( 'nishiki_pro_after_home_container' ); ?>
			<?php
		}
	}
	?>
	</main>
<?php
get_footer();
