<?php
add_action( 'customize_register', 'nishiki_pro_init_customizer_search' );
/**
 * 検索結果ページ（カスタマイザー）
 *
 * @param instance $wp_customize インスタンス
 * @return void
 */
function nishiki_pro_init_customizer_search( $wp_customize ) {
	// Section
	$wp_customize->add_section(
		'section_search',
		array(
			'title'    => __( 'Search Pages', 'nishiki-pro' ),
			'priority' => 60,
		)
	);

	// Heading
	$wp_customize->add_setting(
		'setting_search_sidebar_header',
		array(
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		)
	);

	$wp_customize->add_control(
		new Nishiki_WP_Customize_Content(
			$wp_customize,
			'ctrl_search_sidebar_header',
			array(
				'label'    => '<p class="nishiki-pro-customizer-heading">サイドバー</p>',
				'section'  => 'section_search',
				'settings' => 'setting_search_sidebar_header',
			)
		)
	);

	// Column
	$wp_customize->add_setting(
		'setting_search_column',
		array(
			'default'           => 'none',
			'sanitize_callback' => 'nishiki_pro_sanitize_choices',
		)
	);

	$wp_customize->add_control(
		'ctrl_search_column',
		array(
			'label'    => __( 'Placement', 'nishiki-pro' ),
			'section'  => 'section_search',
			'settings' => 'setting_search_column',
			'type'     => 'select',
			'choices'  => array(
				'left'   => __( 'Left', 'nishiki-pro' ),
				'right'  => __( 'Right', 'nishiki-pro' ),
				'bottom' => __( 'Bottom', 'nishiki-pro' ),
				'none'   => __( 'None', 'nishiki-pro' ),
			),
		)
	);

	// Sidebar Width
	$wp_customize->add_setting(
		'setting_search_sidebar_width',
		array(
			'default'           => 300,
			'sanitize_callback' => 'nishiki_pro_sanitize_number_range',
		)
	);

	$wp_customize->add_control(
		new Nishiki_WP_Customize_Range(
			$wp_customize,
			'ctrl_search_sidebar_width',
			array(
				'label'    => __( 'Width(px)', 'nishiki-pro' ),
				'min'      => 0,
				'max'      => 1000,
				'step'     => 10,
				'section'  => 'section_search',
				'settings' => 'setting_search_sidebar_width',
			)
		)
	);

	// Sidebar Margin
	$wp_customize->add_setting(
		'setting_search_sidebar_margin',
		array(
			'default'           => 50,
			'sanitize_callback' => 'nishiki_pro_sanitize_number_range',
		)
	);

	$wp_customize->add_control(
		new Nishiki_WP_Customize_Range(
			$wp_customize,
			'ctrl_search_sidebar_margin',
			array(
				'label'    => __( 'Margin(px)', 'nishiki-pro' ),
				'min'      => 0,
				'max'      => 50,
				'step'     => 1,
				'section'  => 'section_search',
				'settings' => 'setting_search_sidebar_margin',
			)
		)
	);

	// Heading
	$wp_customize->add_setting(
		'setting_search_title_header',
		array(
			'sanitize_callback' => 'nishiki_pro_sanitize_text',
		)
	);

	$wp_customize->add_control(
		new Nishiki_WP_Customize_Content(
			$wp_customize,
			'ctrl_search_title_header',
			array(
				'label'    => '<p class="nishiki-pro-customizer-heading">ページタイトル</p>',
				'section'  => 'section_search',
				'settings' => 'setting_search_title_header',
			)
		)
	);

	// Title Text Color
	$wp_customize->add_setting(
		'setting_search_title_text_color',
		array(
			'default'           => '#ffffff',
			'sanitize_callback' => 'sanitize_hex_color',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'ctrl_search_text_color',
			array(
				'label'     => __( 'Text Color', 'nishiki-pro' ),
				'section'   => 'section_search',
				'transport' => 'postMessage',
				'settings'  => 'setting_search_title_text_color',
			)
		)
	);

	// Title Background Color
	$wp_customize->add_setting(
		'setting_search_title_background_color',
		array(
			'default'           => '#222222',
			'sanitize_callback' => 'sanitize_hex_color',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'ctrl_setting_search_title_background_color',
			array(
				'label'    => __( 'Background Color', 'nishiki-pro' ),
				'section'  => 'section_search',
				'settings' => 'setting_search_title_background_color',
			)
		)
	);

	// Title Background Opacity
	$wp_customize->add_setting(
		'setting_search_title_background_opacity',
		array(
			'default'           => 100,
			'sanitize_callback' => 'nishiki_pro_sanitize_number_range',
		)
	);

	$wp_customize->add_control(
		new Nishiki_WP_Customize_Range(
			$wp_customize,
			'ctrl_search_title_background_opacity',
			array(
				'label'    => __( 'Background Opacity(%)', 'nishiki-pro' ),
				'min'      => 0,
				'max'      => 100,
				'step'     => 1,
				'section'  => 'section_search',
				'settings' => 'setting_search_title_background_opacity',
			)
		)
	);

	// Display Title Eye Catch
	$wp_customize->add_setting(
		'setting_search_title_eye_catch_display',
		array(
			'default'           => false,
			'sanitize_callback' => 'nishiki_pro_sanitize_checkbox',
		)
	);

	$wp_customize->add_control(
		'ctrl_search_title_eye_catch_display',
		array(
			'label'    => __( 'Display Eye Catch', 'nishiki-pro' ),
			'type'     => 'checkbox',
			'section'  => 'section_search',
			'settings' => 'setting_search_title_eye_catch_display',
		)
	);

	// Eye Catch
	$wp_customize->add_setting(
		'setting_search_title_eye_catch',
		array(
			'default'           => '',
			'sanitize_callback' => 'nishiki_pro_sanitize_image',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'ctrl_search_title_eye_catch',
			array(
				'label'       => __( 'Eye catch Image', 'nishiki-pro' ),
				'description' => __( 'Display when eye-catching image is not set. Recommended image size 16:9', 'nishiki-pro' ),
				'section'     => 'section_search',
				'settings'    => 'setting_search_title_eye_catch',
			)
		)
	);

	// Eye Catch Alt
	$wp_customize->add_setting(
		'setting_search_title_eye_catch_alt',
		array(
			'default'           => '',
			'sanitize_callback' => 'nishiki_pro_sanitize_textarea',
		)
	);

	$wp_customize->add_control(
		'ctrl_search_title_eye_catch_alt',
		array(
			'label'    => __( 'Image Alt', 'nishiki-pro' ),
			'type'     => 'textarea',
			'section'  => 'section_search',
			'settings' => 'setting_search_title_eye_catch_alt',
		)
	);

	// Eye Catch Layout
	$wp_customize->add_setting(
		'setting_search_title_eye_catch_layout',
		array(
			'default'           => 'background',
			'sanitize_callback' => 'nishiki_pro_sanitize_radio',
		)
	);

	$wp_customize->add_control(
		'ctrl_search_title_eye_catch_layout',
		array(
			'label'    => __( 'Eye Catch Layout', 'nishiki-pro' ),
			'type'     => 'radio',
			'section'  => 'section_search',
			'settings' => 'setting_search_title_eye_catch_layout',
			'choices'  => array(
				'background'   => __( 'Title Background', 'nishiki-pro' ),
				'top'          => __( 'Title Top', 'nishiki-pro' ),
				'bottom'       => __( 'Title Bottom', 'nishiki-pro' ),
				'content'      => __( 'Content Top', 'nishiki-pro' ),
				'content-wide' => __( 'Content Top(wide)', 'nishiki-pro' ),
			),
		)
	);
}
