<?php
/**
 * カスタマイザー初期設定
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

// Define Extend
require_once get_template_directory() . '/library/customizer/extend.php';

// Sanitize
require_once get_template_directory() . '/library/customizer/sanitize.php';

// Title Tagline
require_once get_template_directory() . '/library/customizer/add_title_tagline.php';

// Header
require_once get_template_directory() . '/library/customizer/add_header.php';

// Footer
require_once get_template_directory() . '/library/customizer/add_footer.php';

// Top
require_once get_template_directory() . '/library/customizer/add_top.php';

// Front
require_once get_template_directory() . '/library/customizer/add_front.php';

// Post
require_once get_template_directory() . '/library/customizer/add_post.php';

// Page
require_once get_template_directory() . '/library/customizer/add_page.php';

// Archive
require_once get_template_directory() . '/library/customizer/add_archive.php';

// Search
require_once get_template_directory() . '/library/customizer/add_search.php';

// Error404
require_once get_template_directory() . '/library/customizer/add_error404.php';

// Output CSS
require_once get_template_directory() . '/library/customizer/css.php';
require_once get_template_directory() . '/library/customizer/css-block-editor.php';
require_once get_template_directory() . '/library/customizer/css-drawer-menu.php';

// Front Page Section
define( 'NISHIKI_PRO_SECTION_NUM', apply_filters( 'nishiki_pro_section_num', 4 ) );

// Front Page Featured Item
define( 'NISHIKI_PRO_FEATURED_ITEM_NUM', apply_filters( 'nishiki_pro_featured_item_num', 3 ) );

// Footer Credit
define( 'NISHIKI_PRO_CREDIT', 'Powered by WordPress.<br><a target="_blank" rel="noopener noreferrer" href="https://support.animagate.com/product/wp-nishiki-pro/">The Nishiki Pro theme</a> is Supported by <a target="_blank" rel="noopener noreferrer" href="https://www.animagate.com/">AnimaGate, Inc.</a>' );

/**
 * セクション数
 *
 * @return $panel_count
 */
function nishiki_pro_panel_count() {
	$panel_count  = 0;
	$num_sections = NISHIKI_PRO_SECTION_NUM;

	// Create a setting and control for each of the sections available in the theme.
	for ( $i = 1; $i < ( 1 + $num_sections ); $i++ ) {
		if ( get_theme_mod( 'panel_front_section' . $i ) ) {
			$panel_count++;
		}
	}

	return $panel_count;
}

// 翻訳テキスト差し替え
if ( ! function_exists( 'nishiki_pro_change_customizer_translated_text' ) ) {
	/**
	 * 翻訳された日本語テキストを書き換え
	 *
	 * @param string $translated_text 翻訳テキスト
	 * @param string $untranslated_text 未翻訳テキスト
	 * @param string $domain ドメイン
	 * @return $translated_text
	 */
	function nishiki_pro_change_customizer_translated_text( $translated_text, $untranslated_text, $domain ) {

		switch ( $untranslated_text ) {

			case 'Current header':
				$translated_text = '現在の画像';
				break;
		}

		return $translated_text;
	}

	add_filter( 'gettext', 'nishiki_pro_change_customizer_translated_text', 10, 3 );
}


// Customizer Controll JS
add_action( 'customize_controls_enqueue_scripts', 'nishiki_pro_panels_js' );
/**
 * カスタマイザー用スクリプト
 *
 * @return void
 */
function nishiki_pro_panels_js() {
	wp_enqueue_script( 'nishiki-customize-controls', get_template_directory_uri() . '/assets/js/customize-controls.js', array(), '1.0', true );
}
