<?php
/**
 * Define Default Setting.
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

if ( ! defined( 'NISHIKI_PRO_BLOCK_EDITOR_DEFAULT_COLORS' ) ) {
	$colors_array = array(
		array(
			'name'  => 'pastel-red',
			'color' => '#fde9ec',
			'slug'  => 'pastel-red',
		),
		array(
			'name'  => 'pastel-orange',
			'color' => '#ffedda',
			'slug'  => 'pastel-orange',
		),
		array(
			'name'  => 'pastel-yellow',
			'color' => '#fbf8c7',
			'slug'  => 'pastel-yellow',
		),
		array(
			'name'  => 'pastel-green',
			'color' => '#ecfbde',
			'slug'  => 'pastel-green',
		),
		array(
			'name'  => 'pastel-blue',
			'color' => '#e1f2fd',
			'slug'  => 'pastel-blue',
		),
		array(
			'name'  => 'pastel-purple',
			'color' => '#fbebfa',
			'slug'  => 'pastel-purple',
		),
		array(
			'name'  => 'pastel-pink',
			'color' => '#ff1e6b',
			'slug'  => 'pastel-pink',
		),
		array(
			'name'  => 'pale-pink',
			'color' => '#f78da7',
			'slug'  => 'pale-pink',
		),
		array(
			'name'  => 'vivid-red',
			'color' => '#cf2e2e',
			'slug'  => 'vivid-red',
		),
		array(
			'name'  => 'luminous-vivid-orange',
			'color' => '#ff6900',
			'slug'  => 'luminous-vivid-orange',
		),
		array(
			'name'  => 'luminous-vivid-amber',
			'color' => '#fcb900',
			'slug'  => 'luminous-vivid-amber',
		),
		array(
			'name'  => 'light-green-cyan',
			'color' => '#7bdcb5',
			'slug'  => 'light-green-cyan',
		),
		array(
			'name'  => 'vivid-green-cyan',
			'color' => '#00d084',
			'slug'  => 'vivid-green-cyan',
		),
		array(
			'name'  => 'pale-cyan-blue',
			'color' => '#8ed1fc',
			'slug'  => 'pale-cyan-blue',
		),
		array(
			'name'  => 'vivid-cyan-blue',
			'color' => '#0693e3',
			'slug'  => 'vivid-cyan-blue',
		),
		array(
			'name'  => 'white',
			'color' => '#ffffff',
			'slug'  => 'white',
		),
		array(
			'name'  => 'very-light-gray',
			'color' => '#eeeeee',
			'slug'  => 'very-light-gray',
		),
		array(
			'name'  => 'cyan-bluish-gray',
			'color' => '#abb8c3',
			'slug'  => 'cyan-bluish-gray',
		),
		array(
			'name'  => 'very-dark-gray',
			'color' => '#313131',
			'slug'  => 'very-dark-gray',
		),
	);
	define( 'NISHIKI_PRO_BLOCK_EDITOR_DEFAULT_COLORS', $colors_array );
}

if ( ! defined( 'NISHIKI_PRO_MAIN_COLOR_01' ) ) {
	$main_color_01_array = array(
		'name'  => 'main-01',
		'color' => get_theme_mod( 'setting_site_main_color_01', '#222222' ),
		'slug'  => 'main-01',
	);

	define( 'NISHIKI_PRO_MAIN_COLOR_01', $main_color_01_array );
}

if ( ! defined( 'NISHIKI_PRO_MAIN_COLOR_02' ) ) {
	$main_color_02_array = array(
		'name'  => 'main-02',
		'color' => get_theme_mod( 'setting_site_main_color_02', '#ffffff' ),
		'slug'  => 'main-02',
	);

	define( 'NISHIKI_PRO_MAIN_COLOR_02', $main_color_02_array );
}

if ( ! defined( 'NISHIKI_PRO_ACCENT_COLOR_01' ) ) {
	$accent_color_01_array = array(
		'name'  => 'accent-01',
		'color' => get_theme_mod( 'setting_site_accent_color_01', '#8d728f' ),
		'slug'  => 'accent-01',
	);

	define( 'NISHIKI_PRO_ACCENT_COLOR_01', $accent_color_01_array );
}

if ( ! defined( 'NISHIKI_PRO_ACCENT_COLOR_02' ) ) {
	$accent_color_02_array = array(
		'name'  => 'accent-02',
		'color' => get_theme_mod( 'setting_site_accent_color_02', '#ffffff' ),
		'slug'  => 'accent-02',
	);

	define( 'NISHIKI_PRO_ACCENT_COLOR_02', $accent_color_02_array );
}
