<?php
/**
 * スタイル/スクリプトの読み込み
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

// Style & Script
if ( ! function_exists( 'nishiki_pro_read_scripts' ) ) {
	/**
	 * スタイル＆スクリプトの読み込み
	 *
	 * @return void
	 */
	function nishiki_pro_read_scripts() {

		// Add Script
		wp_enqueue_script( 'jquery' );
		if ( is_singular() ) {
			wp_enqueue_script( 'comment-reply' );
		}

		$front_end_js = apply_filters( 'nishiki_pro_enqueue_front_end_js', get_template_directory_uri() . '/assets/js/front-end.js' );

		wp_register_script( 'nishiki-pro-main-script', $front_end_js, array(), '1.0.0', true );
		wp_enqueue_script( 'nishiki-pro-main-script' );

		nishiki_pro_enqueue_swiper();

		// Add Style
		$front_end_css = apply_filters( 'nishiki_pro_enqueue_front_end_css', get_template_directory_uri() . '/assets/css/front-end.css' );

		wp_register_style( 'nishiki-pro-main-style', $front_end_css, array(), '1.0.0', 'all' );
		wp_enqueue_style( 'nishiki-pro-main-style' );

		// Add Inline Style
		wp_add_inline_style( 'nishiki-pro-main-style', nishiki_pro_customizer_css() );
		wp_add_inline_style( 'nishiki-pro-main-style', nishiki_pro_drawer_menu_css() );

	}

	add_action( 'wp_enqueue_scripts', 'nishiki_pro_read_scripts' );

}

// Admin Style & Script
if ( ! function_exists( 'nishiki_pro_admin_read_scripts' ) ) {
	/**
	 * スタイル＆スクリプトの読み込み（管理画面）
	 *
	 * @return void
	 */
	function nishiki_pro_admin_read_scripts() {
		$current_screen = get_current_screen();

		// Add Dashboard Icons Style
		if ( is_admin() && 'appearance_page_nishiki-pro-about' === $current_screen->base ) {
			wp_register_style( 'nishiki-pro-dashboard-icons', get_template_directory_uri() . '/assets/css/dashboard-icons.css', array(), '1.0.0', 'all' );
			wp_enqueue_style( 'nishiki-pro-dashboard-icons' );
		}

		if ( is_admin() ) {
			// CSS

			// Add Admin Page Only
			wp_register_style( 'nishiki-pro-admin', get_template_directory_uri() . '/assets/css/admin-only.css', array(), '1.0.0', 'all' );
			wp_enqueue_style( 'nishiki-pro-admin' );

			// Add Customizer Style
			wp_register_style( 'nishiki-pro-customizer', get_template_directory_uri() . '/assets/css/customizer.css', array(), '1.0.0', 'all' );
			wp_enqueue_style( 'nishiki-pro-customizer' );

			// JS

			// Add Admin Page Only
			wp_enqueue_script( 'nishiki-pro-admin', get_template_directory_uri() . '/assets/js/admin-only.js', array(), '1.0.0', false );

			// Add Color Picker
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'nishiki-pro-color-picker', get_template_directory_uri() . '/assets/js/color-picker.js', array( 'wp-color-picker' ), '1.0.0', true );

			// Add Media Uploader
			if ( ! did_action( 'wp_enqueue_media' ) ) {
				wp_enqueue_media();
			}

			wp_enqueue_script( 'nishiki-pro-media-uploader', get_template_directory_uri() . '/assets/js/media-uploader.js', array( 'jquery' ), '1.0.0', true );
		}
	}

	add_action( 'admin_enqueue_scripts', 'nishiki_pro_admin_read_scripts' );

}

/*****************
 * Enqueue block editor style
 */

if ( ! function_exists( 'nishiki_pro_back_end_styles' ) ) {
	/**
	 * バックエンド用 CSS の読み込み
	 *
	 * @return void
	 */
	function nishiki_pro_back_end_styles() {
		wp_enqueue_style( 'nishiki-pro-back-end', get_theme_file_uri( '/assets/css/back-end.min.css' ), false, '1.0', 'all' );

		if( function_exists( 'nishiki_pro_customizer_css_block_editor' ) ) {
			wp_add_inline_style( 'nishiki-pro-back-end', nishiki_pro_customizer_css_block_editor() );
		}
	}

	//add_action( 'enqueue_block_editor_assets', 'nishiki_pro_back_end_styles' );
}

/*
// Editor Style
if ( ! function_exists( 'nishiki_pro_editor_styles' ) ) {
	function nishiki_pro_editor_styles(){
		// Add Style
		$front_end_css = apply_filters( 'nishiki_pro_enqueue_front_end_css', get_template_directory_uri() . '/assets/css/front-end.css' );

		wp_register_style( 'nishiki-pro-main-style', $front_end_css, array(), '1.0.0', 'all' );
		wp_enqueue_style( 'nishiki-pro-main-style' );

		// Add Inline Style
		wp_add_inline_style( 'nishiki-pro-main-style', nishiki_pro_customizer_css() );
		wp_add_inline_style( 'nishiki-pro-main-style', nishiki_pro_drawer_menu_css() );

		// Editor Only Style
		if( is_admin() ){
			// Add Back End Style
			wp_enqueue_style( 'nishiki-pro-back-end', get_theme_file_uri( '/assets/css/back-end.min.css' ), false, '1.0', 'all' );

			if( function_exists( 'nishiki_pro_customizer_css_block_editor' ) ) {
				wp_add_inline_style( 'nishiki-pro-back-end', nishiki_pro_customizer_css_block_editor() );
			}
		}
	}

	add_action( 'enqueue_block_assets', 'nishiki_pro_editor_styles' );
}
*/
// Custom Editor Style
if ( ! function_exists( 'nishiki_pro_custom_editor_settings' ) ) {
	function nishiki_pro_custom_editor_settings( $editor_settings, $editor_context ) {
		$front_end_css = file_get_contents( get_template_directory() . '/assets/css/front-end.min.css' );
		$front_end_customizer_init_css = nishiki_pro_css();
		$front_end_customizer_css = nishiki_pro_customizer_css();

		$editor_css = file_get_contents( get_template_directory() . '/assets/css/back-end.min.css' );
		if( function_exists( 'nishiki_pro_customizer_css_block_editor' ) ) {
			$editor_inline_data = nishiki_pro_customizer_css_block_editor();
		}

		$editor_settings["styles"][] = array(
			"css" => $front_end_css . $front_end_customizer_init_css . $front_end_customizer_css . $editor_css . $editor_inline_data
		);
	
		return $editor_settings;
	}
	add_filter( 'block_editor_settings_all', 'nishiki_pro_custom_editor_settings', 10, 2 );
}
