<?php
/**
 * フッター読み込み パーツ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

?>
<footer id="footer" role="contentinfo">
	<?php do_action( 'nishiki_pro_before_site_footer_content' ); ?>
	<div class="footer-inner container">
		<?php do_action( 'nishiki_pro_before_site_footer_content_inner' ); ?>
		<?php if ( is_active_sidebar( 'footer_widget' ) ) { ?>
			<?php $footer_widget_columns = get_theme_mod( 'setting_footer_widget_columns', '3' ); ?>
			<div id="footer-widget" class="footer-widget flex<?php echo ' column-' . esc_attr( $footer_widget_columns ); ?>">
				<?php dynamic_sidebar( 'footer_widget' ); ?>
			</div>
		<?php } ?>
		<?php
		if ( get_theme_mod( 'setting_footer_main_text' ) ) {
			echo '<p class="main-text">' . esc_html( get_theme_mod( 'setting_footer_main_text', __( 'Main Text', 'nishiki-pro' ) ) ) . '</p>';
		}
		if ( get_theme_mod( 'setting_footer_main_button_text' ) && get_theme_mod( 'setting_footer_main_button_link' ) ) {
			$footer_main_button_target = '';
			if ( get_theme_mod( 'setting_footer_main_button_link_target', false ) ) {
				$footer_main_button_target = 'target="_blank" rel="noopener noreferrer" ';
			}
			?>
			<p class="main-button">
				<a class="btn" <?php echo esc_attr( $footer_main_button_target ); ?>href="<?php echo esc_url( get_theme_mod( 'setting_footer_main_button_link' ) ); ?>">
					<?php echo esc_html( get_theme_mod( 'setting_footer_main_button_text', __( 'Button Text', 'nishiki-pro' ) ) ); ?>
				</a>
			</p>
			<?php
		}
		$copyright = apply_filters( 'nishiki_pro_copyright', get_theme_mod( 'setting_footer_copyright', NISHIKI_PRO_CREDIT ) );
		if ( $copyright ) {
		?>
		<p class="copyright">
			<?php echo wp_kses_post( $copyright ); ?>
		</p>
		<?php } ?>
		<?php do_action( 'nishiki_pro_after_site_footer_content_inner' ); ?>
	</div>
	<?php do_action( 'nishiki_pro_after_site_footer_content' ); ?>
</footer>
