<?php
/**
 * 404 ページ
 *
 * @author     AnimaGate, Inc.
 * @link       https://support.animagate.com/product/wp-nishiki-pro/
 */

get_header(); ?>
<main id="main" class="site-main" role="main" <?php do_action( 'nishiki_pro_main_attributes' ); ?>>
	<?php do_action( 'nishiki_pro_before_404_header' ); ?>
	<header<?php echo wp_kses_post( apply_filters( 'nishiki_pro_page_header_attributes', '' ) ); ?>>
		<div class="page-header-inner container">
			<?php do_action( 'nishiki_pro_before_404_title' ); ?>
			<h1><?php esc_html_e( 'Page Not Found', 'nishiki-pro' ); ?></h1>
			<?php do_action( 'nishiki_pro_after_404_title' ); ?>
			<div class="taxonomy-description"><p><?php esc_html_e( 'Page Not Found.', 'nishiki-pro' ); ?></p></div>
		</div>
	</header>
	<?php do_action( 'nishiki_pro_after_404_header' ); ?>
	<?php do_action( 'nishiki_pro_before_404_container' ); ?>
	<div class="container column">
		<?php do_action( 'nishiki_pro_before_404_inner_conteiner' ); ?>
		<div class="archives">
			<?php do_action( 'nishiki_pro_before_404_content' ); ?>
			<p><?php esc_html_e( 'It looks like nothing was found at the location. Maybe try a search?', 'nishiki-pro' ); ?></p>
			<?php get_search_form(); ?>
			<?php do_action( 'nishiki_pro_after_404_content' ); ?>
		</div>
		<?php do_action( 'nishiki_pro_sidebar' ); ?>
		<?php do_action( 'nishiki_pro_after_404_inner_conteiner' ); ?>
	</div>
	<?php do_action( 'nishiki_pro_after_404_container' ); ?>
</main>
<?php
get_footer();
