<?php
if ( ! class_exists( 'NISHIKI_BLOCKS_PRO_FILTER_FAQ' ) ) {
	/**
	 * ブロックフィルター
	 */
	class NISHIKI_BLOCKS_PRO_FILTER_FAQ {

		/**
		 * Constructor.
		 */
		public function __construct() {
			// add_filter( 'render_block_nishiki-blocks-pro/faq', array( $this, 'render_block' ), 10, 3 );
			add_filter( 'wp_head', array( $this, 'json' ), 10, 3 );
		}

		/**
		 * JSON-LD 出力
		 *
		 * @return void
		 */
		public function json() {
			global $post;

			if ( is_singular() ) {
				// 投稿情報を取得
				$post_object = get_post( $post->ID );
				$blocks      = nishiki_pro_parse_all_blocks( $post->ID );

				$main_entity = array();

				$allowed_html = array(
					'h1'     => array(),
					'h2'     => array(),
					'h3'     => array(),
					'h4'     => array(),
					'h5'     => array(),
					'h6'     => array(),
					'br'     => array(),
					'ol'     => array(),
					'ul'     => array(),
					'li'     => array(),
					'a'      => array(
						'href'   => array(),
						'target' => array(),
					),
					'p'      => array(),
					'div'    => array(),
					'b'      => array(),
					'strong' => array(),
					'i'      => array(),
					'em'     => array(),
				);

				if ( ! empty( $blocks ) ) {
					foreach ( $blocks as $block ) {
						// 全ブロックのコンテンツ取得
						$block_names = nishiki_pro_parse_all_block_content( $block );

						$html = '';

						foreach ( $block_names as $block_name ) {
							if ( 'nishiki-blocks-pro/faq' === $block_name['blockName'] ) {
								foreach ( $block_name['innerBlocks'] as $innerblocks ) {
									$html .= $innerblocks['innerHTML'];
								}

								$html = wp_kses( $html, $allowed_html );

								if ( ! empty( $block_name['attrs']['question'] ) && ! empty( $html ) ) {
									$main_entity[] = array(
										'@type'          => 'Question',
										'name'           => $block_name['attrs']['question'],
										'acceptedAnswer' => array(
											'@type' => 'Answer',
											'text'  => $html,
										),
									);
								}
							}
						}
					}
				}

				if ( ! empty( $main_entity ) ) {
					$json_array[] = array(
						'@context'   => 'https://schema.org',
						'@type'      => 'FAQPage',
						'mainEntity' => $main_entity,
					);

					echo "<script type='application/ld+json'>" . wp_json_encode( $json_array ) . '</script>' . "\n";
				}
			}
		}

		/**
		 * Undocumented function
		 *
		 * @param array $block_content 出力する html
		 * @param array $block ブロックコンテンツ
		 */
		public function render_block( $block_content, $block ) {

			$html = '';

			foreach ( $block['innerBlocks'] as $innerblocks ) {
				$html .= $innerblocks['innerHTML'];
			}

			// 特定のタグのみ有効にするため削除
			// https://developers.google.com/search/docs/advanced/structured-data/faqpage?hl=ja
			// 質問に対する回答の全文。
			// 回答には、リンクやリストなど、HTML コンテンツを含めることもできます。
			// Google 検索では次の HTML タグが表示され、他のすべてのタグは無視されます: <h1> から <h6>、<br>、<ol>、<ul>、<li>、<a>、<p>、<div>、<b>、<strong>、<i>、<em>。

			$allowed_html = array(
				'h1'     => array(),
				'h2'     => array(),
				'h3'     => array(),
				'h4'     => array(),
				'h5'     => array(),
				'h6'     => array(),
				'br'     => array(),
				'ol'     => array(),
				'ul'     => array(),
				'li'     => array(),
				'a'      => array(
					'href'   => array(),
					'target' => array(),
				),
				'p'      => array(),
				'div'    => array(),
				'b'      => array(),
				'strong' => array(),
				'i'      => array(),
				'em'     => array(),
			);

			$html = wp_kses( $html, $allowed_html );

			if ( ! empty( $block['attrs']['question'] ) && ! empty( $html ) ) {
				$json_array = array(
					'@context'   => 'https://schema.org',
					'@type'      => 'FAQPage',
					'mainEntity' => array(
						'@type'          => 'Question',
						'name'           => $block['attrs']['question'],
						'acceptedAnswer' => array(
							'@type' => 'Answer',
							'text'  => $html,
						),
					),
				);

				add_action(
					'wp_head',
					function() use ( $json_array ) {
						echo "<script type='application/ld+json'>" . wp_json_encode( $json_array ) . '</script>' . "\n";
					},
					100
				);
			}

			return $block_content;
		}

	}

	new NISHIKI_BLOCKS_PRO_FILTER_FAQ();
}
