<?php
if ( ! class_exists( 'NISHIKI_BLOCKS_PRO_FILTER_SLIDER' ) ) {
	/**
	 * ブロックフィルター
	 */
	class NISHIKI_BLOCKS_PRO_FILTER_SLIDER {

		/**
		 * Constructor.
		 */
		public function __construct() {
			add_filter( 'wp_enqueue_scripts', array( $this, 'enqueue_block_inline_style' ), 20 );
		}		

		public function enqueue_block_inline_style() {
			global $post;
	
			if ( empty( $post->ID ) ) {
				return false;
			}
	
			$post_object = get_post( $post->ID );
	
			$all_blocks      = nishiki_pro_parse_all_blocks( $post->ID );
	
			if ( ! empty( $all_blocks ) ) {
	
				foreach ( $all_blocks as $blocks ) {
					// 全ブロックのコンテンツ取得
					$all_block_contents = nishiki_pro_parse_all_block_content( $blocks );
	
					$style = '';
	
					foreach ( $all_block_contents as $block ) {
						if ( 'nishiki-blocks-pro/slider2' === $block['blockName'] ) {
							$custom_style = '';

							if( array_key_exists( 'paginationColor', $block['attrs'] ) ){
								$paginationcolor = $block['attrs']['paginationColor'];
				
								$custom_style .= 'background:' . $paginationcolor . ';';
							}
							
							if ( ! empty( $custom_style ) ) {
				
								$blockid = $block['attrs']['blockID'];
								$style = '.block-' . esc_html( $blockid ) . ' .swiper-pagination:not(.swiper-pagination-fraction) span{';
								$style .= esc_html( $custom_style );
								$style .= '}';
				
								wp_add_inline_style( 'nishiki-pro-main-style', $style );
							}
	
						}
					}
				}
			}
		}

	}

	new NISHIKI_BLOCKS_PRO_FILTER_SLIDER();
}
