<?php
if ( ! class_exists( 'NISHIKI_PRO_AUTH' ) ) {
	/**
	 * Auth
	 */
	class NISHIKI_PRO_AUTH {
		/**
		 * Network URL
		 *
		 * @var string
		 */
		private $network_url = 'https://support.animagate.com/wp/';

		/**
		 * Base file
		 *
		 * @var string
		 */
		private $base_file = 'nishiki_pro_reg_callback.php';

		/**
		 * Remote Check
		 *
		 * @param array $args 設定
		 * @return boolean
		 */
		public function remote_check( $args ) {
			$args = array(
				'product'   => $args['product'],
				'extension' => $args['extension'],
				'site_url'  => rawurlencode( $args['site_url'] ),
				'key'       => $args['key'],
			);

			$target_url = $this->network_url . $this->base_file . '?' . http_build_query( $args );
			$request    = wp_safe_remote_get(
				$target_url,
				array(
					'sslverify' => false,
				)
			);

			// echo $target_url;
			if ( isset( $request ) && ! empty( $request ) && ! is_wp_error( $request ) && 200 === $request['response']['code'] ) {
				return true;
			} else {
				return false;
			}

		}
	}
}
