<?php
if ( ! class_exists( 'NISHIKI_PRO_BLOCK_EDITOR_UTILITY' ) ) {
	/**
	 * UTILITY.
	 */
	class NISHIKI_PRO_BLOCK_EDITOR_UTILITY {
		/**
		 * Holds the options to be used in the fields callbacks
		 *
		 * @var array
		 */
		public $options;

		/**
		 * Holds name
		 *
		 * @var string
		 */
		public $page_name = 'nishiki_pro_block_editor';

		/**
		 * フォームの出力（全ページ）
		 */
		public function nonce_cb() {
			$nonce = wp_create_nonce( $this->page_name );
			echo '<input type="hidden" name="' . esc_attr( $this->page_name ) . '" value="' . esc_attr( $nonce ) . '" />';
		}

		/**
		 * ラベル用の配列
		 *
		 * @var array
		 */
		public $label_array = array(
			'name'             => 'クラス名',
			'label'            => 'スタイル名',
			'code'             => '高度な設定：追加 CSS',
			'h1'               => 'h1',
			'h2'               => 'h2',
			'h3'               => 'h3',
			'h4'               => 'h4',
			'h5'               => 'h5',
			'h6'               => 'h6',
			'size'             => 'font-size(サイズ)',
			'unit'             => '単位',
			'color'            => 'color(カラー)',
			'line-height'      => 'line-height(行の高さ)',
			'background-color' => '背景カラー',
			'margin'           => 'margin(マージン)',
			'top'              => '上',
			'right'            => '右',
			'bottom'           => '下',
			'left'             => '左',
			'margin-unit'      => '単位',
			'padding'          => 'padding(パディング)',
			'padding-unit'     => '単位',
			'border'           => 'border(ボーダー)',
			'border-width'     => 'ボーダーの太さ',
			'border-style'     => 'ボーダースタイル',
			'border-color'     => 'ボーダーカラー',
			'border-unit'      => '単位',
			'label_name'       => array(
				'dot01'       => 'ドット01',
				'polka-dot01' => '水玉ドット01',
				'color01'     => 'カラー01',
				'baloon01'    => 'フキダシ01',
				'accent01'    => 'アクセント01',
				'accent02'    => 'アクセント02',
				'stripe01'    => 'ストライプ01',
				'stitch01'    => 'ステッチ01',
				'bracket01'   => 'カッコ（左上/右下）',
				'bracket02'   => 'カッコ（左右）',
				'border01'    => 'ボーダー（上下）',
				'border02'    => 'ボーダー（下）',
				'border03'    => 'ボーダー',
				'border04'    => 'ボーダー（左右）',
			),
		);

		/**
		 * 見出しのテンプレート
		 *
		 * @param string $template_name テンプレート名
		 * @return $data
		 */
		public function heading_template( $template_name ) {
			// h1-h6までの共通設定を作成
			$heading_array = array();

			$name  = 'heading-' . $template_name;
			$label = $template_name;

			$label_name = $this->label_array['label_name'][ $template_name ];

			if ( empty( $label_name ) ) {
				$label_name = '見出し';
			}

			$base_array = array(
				'name'  => $name,
				'label' => $label_name,
			);

			$media_query_tablet     = '@media only screen and (max-width: 781px)';
			$media_query_smartphone = '@media only screen and (max-width:680px)';

			// CSS
			$css = '';

			$desktop_css    = '';
			$tablet_css     = '';
			$smartphone_css = '';

			$before_css = '';
			$after_css  = '';

			// h1-h6それぞれ適用したい時
			$desktop_style = array();

			// タブレット
			$tablet_style = array();

			// スマホ
			$smartphone_style = array();

			// Before
			$before_style = array();

			// After
			$after_style = array();

			$style_name = 'is-style-' . $name;

			// Font Size
			$font_size = array(
				'desktop'    => array(
					1.8,
					1.7,
					1.4,
					1.2,
					1.15,
					1.1,
				),
				'tablet'     => array(
					1.4,
					1.35,
					1.25,
					1.15,
					1.1,
					1,
				),
				'smartphone' => array(
					1.3,
					1.25,
					1.15,
					1.1,
					1,
					0.95,
				),
			);

			$generator = array();

			for ( $i = 1; $i <= 6; $i++ ) {
				$generator[ 'h' . $i ] = array(
					'font-size'        => $font_size['desktop'][ $i - 1 ],
					'color'            => '',
					'background-color' => '',
					'line-height'      => 1.86,
					'margin'           => array(
						'top'    => '',
						'right'  => '',
						'bottom' => '',
						'left'   => '',
					),
					'padding'          => array(
						'top'    => '',
						'right'  => '',
						'bottom' => '',
						'left'   => '',
					),
					'border-width'     => array(
						'top'    => '',
						'right'  => '',
						'bottom' => '',
						'left'   => '',
					),
					'border-unit'      => array(
						'top'    => 'px',
						'right'  => 'px',
						'bottom' => 'px',
						'left'   => 'px',
					),
					'border-style'     => array(
						'top'    => 'solid',
						'right'  => 'solid',
						'bottom' => 'solid',
						'left'   => 'solid',
					),
					'border-color'     => array(
						'top'    => null,
						'right'  => null,
						'bottom' => null,
						'left'   => null,
					),
				);
			}

			switch ( $template_name ) {
				case 'dot01':
					$desktop_style = array(
						'h1' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='4' height='4' viewBox='0 0 4 4'%3E%3Cpath fill='%23adadad' fill-opacity='1' d='M1 3h1v1H1V3zm2-2h1v1H3V1z'%3E%3C/path%3E%3C/svg%3E\")",
						),
						'h2' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='4' height='4' viewBox='0 0 4 4'%3E%3Cpath fill='%23adadad' fill-opacity='1' d='M1 3h1v1H1V3zm2-2h1v1H3V1z'%3E%3C/path%3E%3C/svg%3E\")",
						),
						'h3' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='4' height='4' viewBox='0 0 4 4'%3E%3Cpath fill='%23adadad' fill-opacity='1' d='M1 3h1v1H1V3zm2-2h1v1H3V1z'%3E%3C/path%3E%3C/svg%3E\")",
						),
						'h4' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='4' height='4' viewBox='0 0 4 4'%3E%3Cpath fill='%23adadad' fill-opacity='1' d='M1 3h1v1H1V3zm2-2h1v1H3V1z'%3E%3C/path%3E%3C/svg%3E\")",
						),
						'h5' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='4' height='4' viewBox='0 0 4 4'%3E%3Cpath fill='%23adadad' fill-opacity='1' d='M1 3h1v1H1V3zm2-2h1v1H3V1z'%3E%3C/path%3E%3C/svg%3E\")",
						),
						'h6' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='4' height='4' viewBox='0 0 4 4'%3E%3Cpath fill='%23adadad' fill-opacity='1' d='M1 3h1v1H1V3zm2-2h1v1H3V1z'%3E%3C/path%3E%3C/svg%3E\")",
						),
					);

					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'padding'   => '1rem',
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					break;
				case 'polka-dot01':
					$generator['h1']['color']            = '#ffffff';
					$generator['h1']['background-color'] = '#222222';

					$generator['h2']['color']            = '#ffffff';
					$generator['h2']['background-color'] = '#222222';

					$generator['h3']['color']            = '#ffffff';
					$generator['h3']['background-color'] = '#222222';

					$generator['h4']['color']            = '#ffffff';
					$generator['h4']['background-color'] = '#222222';

					$generator['h5']['color']            = '#ffffff';
					$generator['h5']['background-color'] = '#222222';

					$generator['h6']['color']            = '#ffffff';
					$generator['h6']['background-color'] = '#222222';

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					$desktop_style = array(
						'h1' => array(
							'background-image'    => 'radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%), radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%)',
							'background-size'     => '20px 20px',
							'background-position' => '0 0, 10px 10px',
						),
						'h2' => array(
							'background-image'    => 'radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%), radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%)',
							'background-size'     => '20px 20px',
							'background-position' => '0 0, 10px 10px',
						),
						'h3' => array(
							'background-image'    => 'radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%), radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%)',
							'background-size'     => '20px 20px',
							'background-position' => '0 0, 10px 10px',
						),
						'h4' => array(
							'background-image'    => 'radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%), radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%)',
							'background-size'     => '20px 20px',
							'background-position' => '0 0, 10px 10px',
						),
						'h5' => array(
							'background-image'    => 'radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%), radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%)',
							'background-size'     => '20px 20px',
							'background-position' => '0 0, 10px 10px',
						),
						'h6' => array(
							'background-image'    => 'radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%), radial-gradient(#555 10%, rgba(0, 0, 0, 0) 20%)',
							'background-size'     => '20px 20px',
							'background-position' => '0 0, 10px 10px',
						),
					);

					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'padding'   => '1rem',
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					break;
				case 'color01':
					$generator['h1']['color']            = '#ffffff';
					$generator['h1']['background-color'] = '#222222';

					$generator['h2']['color']            = '#ffffff';
					$generator['h2']['background-color'] = '#222222';

					$generator['h3']['color']            = '#ffffff';
					$generator['h3']['background-color'] = '#222222';

					$generator['h4']['color']            = '#ffffff';
					$generator['h4']['background-color'] = '#222222';

					$generator['h5']['color']            = '#ffffff';
					$generator['h5']['background-color'] = '#222222';

					$generator['h6']['color']            = '#ffffff';
					$generator['h6']['background-color'] = '#222222';

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					/*
					//追加CSS（デスクトップ）
					$desktop_style = array(
						'h1' => array(
							'border-radius' => '4px',
						),
						'h2' => array(
							'border-radius' => '4px',
						),
						'h3' => array(
							'border-radius' => '4px',
						),
						'h4' => array(
							'border-radius' => '4px',
						),
						'h5' => array(
							'border-radius' => '4px',
						),
						'h6' => array(
							'border-radius' => '4px',
						),
					);
					*/

					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'padding'   => '1rem',
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					break;
				case 'accent01':
					// Code
					$desktop_style = array(
						'h1' => array(
							'position' => 'relative',
						),
						'h2' => array(
							'position' => 'relative',
						),
						'h3' => array(
							'position' => 'relative',
						),
						'h4' => array(
							'position' => 'relative',
						),
						'h5' => array(
							'position' => 'relative',
						),
						'h6' => array(
							'position' => 'relative',
						),
					);

					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					// Before
					$before_style = array(
						'h1' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '0',
							'left'             => '1rem',
							'height'           => '0.7rem',
							'width'            => '0.7rem',
							'transform'        => 'rotate(45deg)',
						),
						'h2' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '0',
							'left'             => '1rem',
							'height'           => '0.5rem',
							'width'            => '0.5rem',
							'transform'        => 'rotate(45deg)',
						),
						'h3' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '0',
							'left'             => '1rem',
							'height'           => '0.5rem',
							'width'            => '0.5rem',
							'transform'        => 'rotate(45deg)',
						),
						'h4' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '0',
							'left'             => '1.1rem',
							'height'           => '0.4rem',
							'width'            => '0.4rem',
							'transform'        => 'rotate(45deg)',
						),
						'h5' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '0',
							'left'             => '1rem',
							'height'           => '0.3rem',
							'width'            => '0.3rem',
							'transform'        => 'rotate(45deg)',
						),
						'h6' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '0',
							'left'             => '1rem',
							'height'           => '0.3rem',
							'width'            => '0.3rem',
							'transform'        => 'rotate(45deg)',
						),
					);

					// After
					$after_style = array(
						'h1' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '1rem',
							'left'             => '0.5rem',
							'height'           => '0.5rem',
							'width'            => '0.5rem',
							'transform'        => 'rotate(15deg)',
						),
						'h2' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '1rem',
							'left'             => '0.4rem',
							'height'           => '0.4rem',
							'width'            => '0.4rem',
							'transform'        => 'rotate(15deg)',
						),
						'h3' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '1rem',
							'left'             => '0.6rem',
							'height'           => '0.3rem',
							'width'            => '0.3rem',
							'transform'        => 'rotate(15deg)',
						),
						'h4' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '1rem',
							'left'             => '0.7rem',
							'height'           => '0.2rem',
							'width'            => '0.2rem',
							'transform'        => 'rotate(15deg)',
						),
						'h5' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '1rem',
							'left'             => '0.7rem',
							'height'           => '0.2rem',
							'width'            => '0.2rem',
							'transform'        => 'rotate(15deg)',
						),
						'h6' => array(
							'content'          => '""',
							'background-color' => '#444444',
							'position'         => 'absolute',
							'top'              => '1rem',
							'left'             => '0.7rem',
							'height'           => '0.2rem',
							'width'            => '0.2rem',
							'transform'        => 'rotate(15deg)',
						),
					);

					// Padding
					$generator['h1']['padding']['left']   = 2.5;
					$generator['h1']['padding']['top']    = 0;
					$generator['h1']['padding']['bottom'] = 0;
					$generator['h2']['padding']['left']   = 2.5;
					$generator['h2']['padding']['top']    = 0;
					$generator['h2']['padding']['bottom'] = 0;
					$generator['h3']['padding']['left']   = 2.5;
					$generator['h3']['padding']['top']    = 0;
					$generator['h3']['padding']['bottom'] = 0;
					$generator['h4']['padding']['left']   = 2.5;
					$generator['h4']['padding']['top']    = 0;
					$generator['h4']['padding']['bottom'] = 0;
					$generator['h5']['padding']['left']   = 2.5;
					$generator['h5']['padding']['top']    = 0;
					$generator['h5']['padding']['bottom'] = 0;
					$generator['h6']['padding']['left']   = 2.5;
					$generator['h6']['padding']['top']    = 0;
					$generator['h6']['padding']['bottom'] = 0;

					// Border
					$generator['h1']['border-width']['bottom'] = 3;
					$generator['h1']['border-color']['bottom'] = '#444444';

					$generator['h2']['border-width']['bottom'] = 3;
					$generator['h2']['border-color']['bottom'] = '#444444';

					$generator['h3']['border-width']['bottom'] = 2;
					$generator['h3']['border-color']['bottom'] = '#444444';

					$generator['h4']['border-width']['bottom'] = 2;
					$generator['h4']['border-color']['bottom'] = '#444444';

					$generator['h5']['border-width']['bottom'] = 1;
					$generator['h5']['border-color']['bottom'] = '#444444';

					$generator['h6']['border-width']['bottom'] = 1;
					$generator['h6']['border-color']['bottom'] = '#444444';

					break;
				case 'accent02':
					// Code
					$desktop_style = array(
						'h1' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h2' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h3' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h4' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h5' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h6' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
					);

					// Before
					$before_style = array(
						'h1' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
						'h2' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
						'h3' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
						'h4' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
						'h5' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
						'h6' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
					);

					// line-height
					$generator['h1']['line-height'] = 1;
					$generator['h2']['line-height'] = 1;
					$generator['h3']['line-height'] = 1;
					$generator['h4']['line-height'] = 1;
					$generator['h5']['line-height'] = 1;
					$generator['h6']['line-height'] = 1;

					// Padding
					$generator['h1']['padding']['top']    = 1.4;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.4;
					$generator['h2']['padding']['bottom'] = 1.4;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 1.4;
					$generator['h3']['padding']['bottom'] = 1.4;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 1.4;
					$generator['h4']['padding']['bottom'] = 1.4;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 1.4;
					$generator['h5']['padding']['bottom'] = 1.4;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 1.4;
					$generator['h6']['padding']['bottom'] = 1.4;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					break;
				case 'accent02':
					// Code
					$desktop_style = array(
						'h1' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h2' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h3' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h4' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h5' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h6' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
					);

					// Before
					$before_style = array(
						'h1' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
						'h2' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
						'h3' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
						'h4' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
						'h5' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
						'h6' => array(
							'content'     => '""',
							'position'    => 'absolute',
							'top'         => '0',
							'right'       => 'auto',
							'bottom'      => 'auto',
							'left'        => '0',
							'height'      => '1rem',
							'width'       => '1rem',
							'border-top'  => '1px solid',
							'border-left' => '1px solid',
						),
					);

					// line-height
					$generator['h1']['line-height'] = 1;
					$generator['h2']['line-height'] = 1;
					$generator['h3']['line-height'] = 1;
					$generator['h4']['line-height'] = 1;
					$generator['h5']['line-height'] = 1;
					$generator['h6']['line-height'] = 1;

					// Padding
					$generator['h1']['padding']['top']    = 1.4;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.4;
					$generator['h2']['padding']['bottom'] = 1.4;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 1.4;
					$generator['h3']['padding']['bottom'] = 1.4;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 1.4;
					$generator['h4']['padding']['bottom'] = 1.4;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 1.4;
					$generator['h5']['padding']['bottom'] = 1.4;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 1.4;
					$generator['h6']['padding']['bottom'] = 1.4;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					break;

				case 'border01':
					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;

					// Border
					$generator['h1']['border-width']['top']    = 1;
					$generator['h1']['border-width']['bottom'] = 1;

					$generator['h2']['border-width']['top']    = 1;
					$generator['h2']['border-width']['bottom'] = 1;

					$generator['h3']['border-width']['top']    = 1;
					$generator['h3']['border-width']['bottom'] = 1;

					$generator['h4']['border-width']['top']    = 1;
					$generator['h4']['border-width']['bottom'] = 1;

					$generator['h5']['border-width']['top']    = 1;
					$generator['h5']['border-width']['bottom'] = 1;

					$generator['h6']['border-width']['top']    = 1;
					$generator['h6']['border-width']['bottom'] = 1;

					break;
				case 'border02':
					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;

					// Border
					$generator['h1']['border-width']['bottom'] = 1;

					$generator['h2']['border-width']['bottom'] = 1;

					$generator['h3']['border-width']['bottom'] = 1;

					$generator['h4']['border-width']['bottom'] = 1;

					$generator['h5']['border-width']['bottom'] = 1;

					$generator['h6']['border-width']['bottom'] = 1;

					break;
				case 'border03':
					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'font-size' => $font_size['tablet'][0] . 'rem',
							'padding'   => '0.7rem',
						),
						'h2' => array(
							'font-size' => $font_size['tablet'][1] . 'rem',
							'padding'   => '0.7rem',
						),
						'h3' => array(
							'font-size' => $font_size['tablet'][2] . 'rem',
							'padding'   => '0.7rem',
						),
						'h4' => array(
							'font-size' => $font_size['tablet'][3] . 'rem',
							'padding'   => '0.7rem',
						),
						'h5' => array(
							'font-size' => $font_size['tablet'][4] . 'rem',
							'padding'   => '0.7rem',
						),
						'h6' => array(
							'font-size' => $font_size['tablet'][5] . 'rem',
							'padding'   => '0.7rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					// Border
					$generator['h1']['border-width']['top']    = 1;
					$generator['h1']['border-width']['bottom'] = 1;
					$generator['h1']['border-width']['left']   = 1;
					$generator['h1']['border-width']['right']  = 1;

					$generator['h2']['border-width']['top']    = 1;
					$generator['h2']['border-width']['bottom'] = 1;
					$generator['h2']['border-width']['left']   = 1;
					$generator['h2']['border-width']['right']  = 1;

					$generator['h3']['border-width']['top']    = 1;
					$generator['h3']['border-width']['bottom'] = 1;
					$generator['h3']['border-width']['left']   = 1;
					$generator['h3']['border-width']['right']  = 1;

					$generator['h4']['border-width']['top']    = 1;
					$generator['h4']['border-width']['bottom'] = 1;
					$generator['h4']['border-width']['left']   = 1;
					$generator['h4']['border-width']['right']  = 1;

					$generator['h5']['border-width']['top']    = 1;
					$generator['h5']['border-width']['bottom'] = 1;
					$generator['h5']['border-width']['left']   = 1;
					$generator['h5']['border-width']['right']  = 1;

					$generator['h6']['border-width']['top']    = 1;
					$generator['h6']['border-width']['bottom'] = 1;
					$generator['h6']['border-width']['left']   = 1;
					$generator['h6']['border-width']['right']  = 1;

					break;
				case 'border04':
					// Code
					$desktop_style = array(
						'h1' => array(
							'display'     => 'flex',
							'align-items' => 'center',
						),
						'h2' => array(
							'display'     => 'flex',
							'align-items' => 'center',
						),
						'h3' => array(
							'display'     => 'flex',
							'align-items' => 'center',
						),
						'h4' => array(
							'display'     => 'flex',
							'align-items' => 'center',
						),
						'h5' => array(
							'display'     => 'flex',
							'align-items' => 'center',
						),
						'h6' => array(
							'display'     => 'flex',
							'align-items' => 'center',
						),
					);

					// Before
					$before_style = array(
						'h1' => array(
							'position'     => 'static',
							'content'      => '""',
							'border-top'   => '1px solid',
							'flex-grow'    => '1',
							'margin-right' => '1rem',
						),
						'h2' => array(
							'position'     => 'static',
							'content'      => '""',
							'border-top'   => '1px solid',
							'flex-grow'    => '1',
							'margin-right' => '1rem',
						),
						'h3' => array(
							'position'     => 'static',
							'content'      => '""',
							'border-top'   => '1px solid',
							'flex-grow'    => '1',
							'margin-right' => '1rem',
						),
						'h4' => array(
							'position'     => 'static',
							'content'      => '""',
							'border-top'   => '1px solid',
							'flex-grow'    => '1',
							'margin-right' => '1rem',
						),
						'h5' => array(
							'position'     => 'static',
							'content'      => '""',
							'border-top'   => '1px solid',
							'flex-grow'    => '1',
							'margin-right' => '1rem',
						),
						'h6' => array(
							'position'     => 'static',
							'content'      => '""',
							'border-top'   => '1px solid',
							'flex-grow'    => '1',
							'margin-right' => '1rem',
						),
					);

					// After
					$after_style = array(
						'h1' => array(
							'position'    => 'static',
							'content'     => '""',
							'border-top'  => '1px solid',
							'flex-grow'   => '1',
							'margin-left' => '1rem',
						),
						'h2' => array(
							'position'    => 'static',
							'content'     => '""',
							'border-top'  => '1px solid',
							'flex-grow'   => '1',
							'margin-left' => '1rem',
						),
						'h3' => array(
							'position'    => 'static',
							'content'     => '""',
							'border-top'  => '1px solid',
							'flex-grow'   => '1',
							'margin-left' => '1rem',
						),
						'h4' => array(
							'position'    => 'static',
							'content'     => '""',
							'border-top'  => '1px solid',
							'flex-grow'   => '1',
							'margin-left' => '1rem',
						),
						'h5' => array(
							'position'    => 'static',
							'content'     => '""',
							'border-top'  => '1px solid',
							'flex-grow'   => '1',
							'margin-left' => '1rem',
						),
						'h6' => array(
							'position'    => 'static',
							'content'     => '""',
							'border-top'  => '1px solid',
							'flex-grow'   => '1',
							'margin-left' => '1rem',
						),
					);

					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;

					break;
				case 'bracket01':
					// Code
					$desktop_style = array(
						'h1' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h2' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h3' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h4' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h5' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h6' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
					);

					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					// Before
					$before_style = array(
						'h1' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => 'auto',
							'left'          => '0',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-top'    => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
						'h2' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => 'auto',
							'left'          => '0',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-top'    => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
						'h3' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => 'auto',
							'left'          => '0',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-top'    => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
						'h4' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => 'auto',
							'left'          => '0',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-top'    => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
						'h5' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => 'auto',
							'left'          => '0',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-top'    => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
						'h6' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => 'auto',
							'left'          => '0',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-top'    => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
					);

					// After
					$after_style = array(
						'h1' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => 'auto',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
						'h2' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => 'auto',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
						'h3' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => 'auto',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
						'h4' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => 'auto',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
						'h5' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => 'auto',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
						'h6' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => 'auto',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '1rem',
							'width'         => '1rem',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
					);

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					break;
				case 'bracket02':
					// Code
					$desktop_style = array(
						'h1' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h2' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h3' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h4' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h5' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
						'h6' => array(
							'position' => 'relative',
							'display'  => 'table',
						),
					);

					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					// Before
					$before_style = array(
						'h1' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => '0',
							'left'          => '0',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-bottom' => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
						'h2' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => '0',
							'left'          => '0',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-bottom' => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
						'h3' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => '0',
							'left'          => '0',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-bottom' => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
						'h4' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => '0',
							'left'          => '0',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-bottom' => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
						'h5' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => '0',
							'left'          => '0',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-bottom' => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
						'h6' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => 'auto',
							'bottom'        => '0',
							'left'          => '0',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-bottom' => '1px solid',
							'border-left'   => '1px solid',
							'border-radius' => '0',
						),
					);

					// After
					$after_style = array(
						'h1' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
						'h2' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
						'h3' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
						'h4' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
						'h5' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
						'h6' => array(
							'content'       => '""',
							'position'      => 'absolute',
							'top'           => '0',
							'right'         => '0',
							'bottom'        => '0',
							'left'          => 'auto',
							'height'        => '100%',
							'width'         => '0.5rem',
							'border-top'    => '1px solid',
							'border-right'  => '1px solid',
							'border-bottom' => '1px solid',
							'border-radius' => '0',
						),
					);

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					break;
				case 'baloon01':
					$generator['h1']['color']            = '#ffffff';
					$generator['h1']['background-color'] = '#222222';

					$generator['h2']['color']            = '#ffffff';
					$generator['h2']['background-color'] = '#222222';

					$generator['h3']['color']            = '#ffffff';
					$generator['h3']['background-color'] = '#222222';

					$generator['h4']['color']            = '#ffffff';
					$generator['h4']['background-color'] = '#222222';

					$generator['h5']['color']            = '#ffffff';
					$generator['h5']['background-color'] = '#222222';

					$generator['h6']['color']            = '#ffffff';
					$generator['h6']['background-color'] = '#222222';

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					// After
					$after_style = array(
						'h1' => array(
							'content'          => "''",
							'position'         => 'absolute',
							'top'              => 'auto',
							'bottom'           => 0,
							'left'             => '2.9rem',
							'width'            => 0,
							'height'           => 0,
							'border'           => '20px solid transparent;',
							'border-top-color' => 'inherit',
							'border-bottom'    => 0,
							'margin-left'      => '-20px',
							'margin-bottom'    => '-20px',
						),
						'h2' => array(
							'content'          => "''",
							'position'         => 'absolute',
							'top'              => 'auto',
							'bottom'           => 0,
							'left'             => '2.9rem',
							'width'            => 0,
							'height'           => 0,
							'border'           => '17px solid transparent;',
							'border-top-color' => 'inherit',
							'border-bottom'    => 0,
							'margin-left'      => '-20px',
							'margin-bottom'    => '-17px',
						),
						'h3' => array(
							'content'          => "''",
							'position'         => 'absolute',
							'top'              => 'auto',
							'bottom'           => 0,
							'left'             => '2.9rem',
							'width'            => 0,
							'height'           => 0,
							'border'           => '15px solid transparent;',
							'border-top-color' => 'inherit',
							'border-bottom'    => 0,
							'margin-left'      => '-20px',
							'margin-bottom'    => '-15px',
						),
						'h4' => array(
							'content'          => "''",
							'position'         => 'absolute',
							'top'              => 'auto',
							'bottom'           => 0,
							'left'             => '2.9rem',
							'width'            => 0,
							'height'           => 0,
							'border'           => '13px solid transparent;',
							'border-top-color' => 'inherit',
							'border-bottom'    => 0,
							'margin-left'      => '-20px',
							'margin-bottom'    => '-13px',
						),
						'h5' => array(
							'content'          => "''",
							'position'         => 'absolute',
							'top'              => 'auto',
							'bottom'           => 0,
							'left'             => '2.9rem',
							'width'            => 0,
							'height'           => 0,
							'border'           => '12px solid transparent;',
							'border-top-color' => 'inherit',
							'border-bottom'    => 0,
							'margin-left'      => '-20px',
							'margin-bottom'    => '-12px',
						),
						'h6' => array(
							'content'          => "''",
							'position'         => 'absolute',
							'top'              => 'auto',
							'bottom'           => 0,
							'left'             => '2.9rem',
							'width'            => 0,
							'height'           => 0,
							'border'           => '11px solid transparent;',
							'border-top-color' => 'inherit',
							'border-bottom'    => 0,
							'margin-left'      => '-20px',
							'margin-bottom'    => '-11px',
						),
					);

					// デスクトップのスタイル
					$desktop_style = array(
						'h1' => array(
							'position'     => 'relative',
							'border-color' => '#222222',
						),
						'h2' => array(
							'position'     => 'relative',
							'border-color' => '#222222',
						),
						'h3' => array(
							'position'     => 'relative',
							'border-color' => '#222222',
						),
						'h4' => array(
							'position'     => 'relative',
							'border-color' => '#222222',
						),
						'h5' => array(
							'position'     => 'relative',
							'border-color' => '#222222',
						),
						'h6' => array(
							'position'     => 'relative',
							'border-color' => '#222222',
						),
					);

					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'padding'   => '1rem',
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					break;
				case 'stripe01':
					$generator['h1']['color']            = '#ffffff';
					$generator['h1']['background-color'] = '#444444';
					$generator['h2']['color']            = '#ffffff';
					$generator['h2']['background-color'] = '#444444';
					$generator['h3']['color']            = '#ffffff';
					$generator['h3']['background-color'] = '#444444';
					$generator['h4']['color']            = '#ffffff';
					$generator['h4']['background-color'] = '#444444';
					$generator['h5']['color']            = '#ffffff';
					$generator['h5']['background-color'] = '#444444';
					$generator['h6']['color']            = '#ffffff';
					$generator['h6']['background-color'] = '#444444';

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					// デスクトップのスタイル
					$desktop_style = array(
						'h1' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg width='40' height='40' viewBox='0 0 40 40' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='%23000000' fill-opacity='0.5' fill-rule='evenodd'%3E%3Cpath d='M0 40L40 0H20L0 20M40 40V20L20 40'/%3E%3C/g%3E%3C/svg%3E\")",
						),
						'h2' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg width='40' height='40' viewBox='0 0 40 40' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='%23000000' fill-opacity='0.5' fill-rule='evenodd'%3E%3Cpath d='M0 40L40 0H20L0 20M40 40V20L20 40'/%3E%3C/g%3E%3C/svg%3E\")",
						),
						'h3' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg width='40' height='40' viewBox='0 0 40 40' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='%23000000' fill-opacity='0.5' fill-rule='evenodd'%3E%3Cpath d='M0 40L40 0H20L0 20M40 40V20L20 40'/%3E%3C/g%3E%3C/svg%3E\")",
						),
						'h4' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg width='40' height='40' viewBox='0 0 40 40' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='%23000000' fill-opacity='0.5' fill-rule='evenodd'%3E%3Cpath d='M0 40L40 0H20L0 20M40 40V20L20 40'/%3E%3C/g%3E%3C/svg%3E\")",
						),
						'h5' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg width='40' height='40' viewBox='0 0 40 40' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='%23000000' fill-opacity='0.5' fill-rule='evenodd'%3E%3Cpath d='M0 40L40 0H20L0 20M40 40V20L20 40'/%3E%3C/g%3E%3C/svg%3E\")",
						),
						'h6' => array(
							'background-image' => "url(\"data:image/svg+xml,%3Csvg width='40' height='40' viewBox='0 0 40 40' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='%23000000' fill-opacity='0.5' fill-rule='evenodd'%3E%3Cpath d='M0 40L40 0H20L0 20M40 40V20L20 40'/%3E%3C/g%3E%3C/svg%3E\")",
						),
					);

					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'padding'   => '1rem',
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					break;
				case 'stitch01':
					$generator['h1']['color']            = '#ffffff';
					$generator['h1']['background-color'] = '#444444';

					$generator['h2']['color']            = '#ffffff';
					$generator['h2']['background-color'] = '#444444';

					$generator['h3']['color']            = '#ffffff';
					$generator['h3']['background-color'] = '#444444';

					$generator['h4']['color']            = '#ffffff';
					$generator['h4']['background-color'] = '#444444';

					$generator['h5']['color']            = '#ffffff';
					$generator['h5']['background-color'] = '#444444';

					$generator['h6']['color']            = '#ffffff';
					$generator['h6']['background-color'] = '#444444';

					// Padding
					$generator['h1']['padding']['top']    = 1.5;
					$generator['h1']['padding']['bottom'] = 1.4;
					$generator['h1']['padding']['left']   = 1.4;
					$generator['h1']['padding']['right']  = 1.4;

					$generator['h2']['padding']['top']    = 1.2;
					$generator['h2']['padding']['bottom'] = 1.1;
					$generator['h2']['padding']['left']   = 1.4;
					$generator['h2']['padding']['right']  = 1.4;

					$generator['h3']['padding']['top']    = 0.9;
					$generator['h3']['padding']['bottom'] = 0.8;
					$generator['h3']['padding']['left']   = 1.4;
					$generator['h3']['padding']['right']  = 1.4;

					$generator['h4']['padding']['top']    = 0.9;
					$generator['h4']['padding']['bottom'] = 0.8;
					$generator['h4']['padding']['left']   = 1.4;
					$generator['h4']['padding']['right']  = 1.4;

					$generator['h5']['padding']['top']    = 0.9;
					$generator['h5']['padding']['bottom'] = 0.8;
					$generator['h5']['padding']['left']   = 1.4;
					$generator['h5']['padding']['right']  = 1.4;

					$generator['h6']['padding']['top']    = 0.9;
					$generator['h6']['padding']['bottom'] = 0.8;
					$generator['h6']['padding']['left']   = 1.4;
					$generator['h6']['padding']['right']  = 1.4;

					// Border
					$generator['h1']['border-width']['top']    = 1;
					$generator['h1']['border-width']['right']  = 1;
					$generator['h1']['border-width']['bottom'] = 1;
					$generator['h1']['border-width']['left']   = 1;

					$generator['h1']['border-style']['top']    = 'dashed';
					$generator['h1']['border-style']['right']  = 'dashed';
					$generator['h1']['border-style']['bottom'] = 'dashed';
					$generator['h1']['border-style']['left']   = 'dashed';

					$generator['h1']['border-color']['top']    = '#ffffff';
					$generator['h1']['border-color']['right']  = '#ffffff';
					$generator['h1']['border-color']['bottom'] = '#ffffff';
					$generator['h1']['border-color']['left']   = '#ffffff';

					$generator['h2']['border-width']['top']    = 1;
					$generator['h2']['border-width']['right']  = 1;
					$generator['h2']['border-width']['bottom'] = 1;
					$generator['h2']['border-width']['left']   = 1;

					$generator['h2']['border-style']['top']    = 'dashed';
					$generator['h2']['border-style']['right']  = 'dashed';
					$generator['h2']['border-style']['bottom'] = 'dashed';
					$generator['h2']['border-style']['left']   = 'dashed';

					$generator['h2']['border-color']['top']    = '#ffffff';
					$generator['h2']['border-color']['right']  = '#ffffff';
					$generator['h2']['border-color']['bottom'] = '#ffffff';
					$generator['h2']['border-color']['left']   = '#ffffff';

					$generator['h3']['border-width']['top']    = 1;
					$generator['h3']['border-width']['right']  = 1;
					$generator['h3']['border-width']['bottom'] = 1;
					$generator['h3']['border-width']['left']   = 1;

					$generator['h3']['border-style']['top']    = 'dashed';
					$generator['h3']['border-style']['right']  = 'dashed';
					$generator['h3']['border-style']['bottom'] = 'dashed';
					$generator['h3']['border-style']['left']   = 'dashed';

					$generator['h3']['border-color']['top']    = '#ffffff';
					$generator['h3']['border-color']['right']  = '#ffffff';
					$generator['h3']['border-color']['bottom'] = '#ffffff';
					$generator['h3']['border-color']['left']   = '#ffffff';

					$generator['h4']['border-width']['top']    = 1;
					$generator['h4']['border-width']['right']  = 1;
					$generator['h4']['border-width']['bottom'] = 1;
					$generator['h4']['border-width']['left']   = 1;

					$generator['h4']['border-style']['top']    = 'dashed';
					$generator['h4']['border-style']['right']  = 'dashed';
					$generator['h4']['border-style']['bottom'] = 'dashed';
					$generator['h4']['border-style']['left']   = 'dashed';

					$generator['h4']['border-color']['top']    = '#ffffff';
					$generator['h4']['border-color']['right']  = '#ffffff';
					$generator['h4']['border-color']['bottom'] = '#ffffff';
					$generator['h4']['border-color']['left']   = '#ffffff';

					$generator['h5']['border-width']['top']    = 1;
					$generator['h5']['border-width']['right']  = 1;
					$generator['h5']['border-width']['bottom'] = 1;
					$generator['h5']['border-width']['left']   = 1;

					$generator['h5']['border-style']['top']    = 'dashed';
					$generator['h5']['border-style']['right']  = 'dashed';
					$generator['h5']['border-style']['bottom'] = 'dashed';
					$generator['h5']['border-style']['left']   = 'dashed';

					$generator['h5']['border-color']['top']    = '#ffffff';
					$generator['h5']['border-color']['right']  = '#ffffff';
					$generator['h5']['border-color']['bottom'] = '#ffffff';
					$generator['h5']['border-color']['left']   = '#ffffff';

					$generator['h6']['border-width']['top']    = 1;
					$generator['h6']['border-width']['right']  = 1;
					$generator['h6']['border-width']['bottom'] = 1;
					$generator['h6']['border-width']['left']   = 1;

					$generator['h6']['border-style']['top']    = 'dashed';
					$generator['h6']['border-style']['right']  = 'dashed';
					$generator['h6']['border-style']['bottom'] = 'dashed';
					$generator['h6']['border-style']['left']   = 'dashed';

					$generator['h6']['border-color']['top']    = '#ffffff';
					$generator['h6']['border-color']['right']  = '#ffffff';
					$generator['h6']['border-color']['bottom'] = '#ffffff';
					$generator['h6']['border-color']['left']   = '#ffffff';

					// デスクトップのスタイル
					$desktop_style = array(
						'h1' => array(
							'box-shadow'   => '0 0 0 6px #444444',
							'margin-right' => 'auto',
							'margin-left'  => 'auto',
							'width'        => 'auto',
						),
						'h2' => array(
							'box-shadow'   => '0 0 0 6px #444444',
							'margin-right' => 'auto',
							'margin-left'  => 'auto',
							'width'        => 'auto',
						),
						'h3' => array(
							'box-shadow'   => '0 0 0 6px #444444',
							'margin-right' => 'auto',
							'margin-left'  => 'auto',
							'width'        => 'auto',
						),
						'h4' => array(
							'box-shadow'   => '0 0 0 6px #444444',
							'margin-right' => 'auto',
							'margin-left'  => 'auto',
							'width'        => 'auto',
						),
						'h5' => array(
							'box-shadow'   => '0 0 0 6px #444444',
							'margin-right' => 'auto',
							'margin-left'  => 'auto',
							'width'        => 'auto',
						),
						'h6' => array(
							'box-shadow'   => '0 0 0 6px #444444',
							'margin-right' => 'auto',
							'margin-left'  => 'auto',
							'width'        => 'auto',
						),
					);

					// タブレットのスタイル
					$tablet_style = array(
						'h1' => array(
							'padding'   => '1rem',
							'font-size' => $font_size['tablet'][0] . 'rem',
						),
						'h2' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][1] . 'rem',
						),
						'h3' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][2] . 'rem',
						),
						'h4' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][3] . 'rem',
						),
						'h5' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][4] . 'rem',
						),
						'h6' => array(
							'padding'   => '0.7rem',
							'font-size' => $font_size['tablet'][5] . 'rem',
						),
					);

					// スマホのスタイル
					$smartphone_style = array(
						'h1' => array(
							'font-size' => $font_size['smartphone'][0] . 'rem',
						),
						'h2' => array(
							'font-size' => $font_size['smartphone'][1] . 'rem',
						),
						'h3' => array(
							'font-size' => $font_size['smartphone'][2] . 'rem',
						),
						'h4' => array(
							'font-size' => $font_size['smartphone'][3] . 'rem',
						),
						'h5' => array(
							'font-size' => $font_size['smartphone'][4] . 'rem',
						),
						'h6' => array(
							'font-size' => $font_size['smartphone'][5] . 'rem',
						),
					);

					break;
			}

			if ( ! empty( $template_name ) ) {
				for ( $i = 1; $i <= 6; $i++ ) {
					$selector = 'h' . $i . '.' . $style_name;

					// Heading
					$heading_array[ 'h' . $i ] = array(
						'font'    => array(
							'size'             => $generator[ 'h' . $i ]['font-size'],
							'unit'             => 'rem',
							'color'            => $generator[ 'h' . $i ]['color'],
							'background-color' => $generator[ 'h' . $i ]['background-color'],
							'line-height'      => $generator[ 'h' . $i ]['line-height'],
						),
						'margin'  => array(
							'top'    => array(
								$generator[ 'h' . $i ]['margin']['top'],
								'rem',
							),
							'right'  => array(
								$generator[ 'h' . $i ]['margin']['right'],
								'rem',
							),
							'bottom' => array(
								$generator[ 'h' . $i ]['margin']['bottom'],
								'rem',
							),
							'left'   => array(
								$generator[ 'h' . $i ]['margin']['left'],
								'rem',
							),
						),
						'padding' => array(
							'top'    => array(
								$generator[ 'h' . $i ]['padding']['top'],
								'rem',
							),
							'right'  => array(
								$generator[ 'h' . $i ]['padding']['right'],
								'rem',
							),
							'bottom' => array(
								$generator[ 'h' . $i ]['padding']['bottom'],
								'rem',
							),
							'left'   => array(
								$generator[ 'h' . $i ]['padding']['left'],
								'rem',
							),
						),
						'border'  => array(
							'top'    => array(
								$generator[ 'h' . $i ]['border-width']['top'],
								$generator[ 'h' . $i ]['border-unit']['top'],
								$generator[ 'h' . $i ]['border-style']['top'],
								$generator[ 'h' . $i ]['border-color']['top'],
							),
							'right'  => array(
								$generator[ 'h' . $i ]['border-width']['right'],
								$generator[ 'h' . $i ]['border-unit']['right'],
								$generator[ 'h' . $i ]['border-style']['right'],
								$generator[ 'h' . $i ]['border-color']['right'],
							),
							'bottom' => array(
								$generator[ 'h' . $i ]['border-width']['bottom'],
								$generator[ 'h' . $i ]['border-unit']['bottom'],
								$generator[ 'h' . $i ]['border-style']['bottom'],
								$generator[ 'h' . $i ]['border-color']['bottom'],
							),
							'left'   => array(
								$generator[ 'h' . $i ]['border-width']['left'],
								$generator[ 'h' . $i ]['border-unit']['left'],
								$generator[ 'h' . $i ]['border-style']['left'],
								$generator[ 'h' . $i ]['border-color']['left'],
							),
						),
					);

					/*
					// Heading
					$heading_array['h' . $i] = array(
						'font' => array(
							'size' => $font_size[ $i - 1 ],
							'unit' => 'rem',
							'color' => $color[ $i - 1 ],
							'background-color' => $background_color[ $i - 1 ],
							'line-height' => 2,
						),
						'margin' => array(
							'top' => array( '', 'rem' ),
							'right' => array( '', 'rem' ),
							'bottom' => array( '', 'rem' ),
							'left' => array( '', 'rem' ),
						),
						'padding' => array(
							'top' => array(
								$padding_top[ $i - 1 ],
								'rem'
							),
							'right' => array(
								$padding_right[ $i - 1 ],
								'rem'
							),
							'bottom' => array(
								$padding_bottom[ $i - 1 ],
								'rem'
							),
							'left' => array(
								$padding_left[ $i - 1 ],
								'rem'
							),
						),
						'border' => array(
							'top' => array(
								$border_top_width[ $i - 1 ],
								$border_top_unit[ $i - 1 ],
								$border_top_style[ $i - 1 ],
								$border_top_color[ $i - 1 ],
							),
							'right' => array(
								$border_right_width[ $i - 1 ],
								$border_right_unit[ $i - 1 ],
								$border_right_style[ $i - 1 ],
								$border_right_color[ $i - 1 ],
							),
							'bottom' => array(
								$border_bottom_width[ $i - 1 ],
								$border_bottom_unit[ $i - 1 ],
								$border_bottom_style[ $i - 1 ],
								$border_bottom_color[ $i - 1 ],
							),
							'left' =>array(
								$border_left_width[ $i - 1 ],
								$border_left_unit[ $i - 1 ],
								$border_left_style[ $i - 1 ],
								$border_left_color[ $i - 1 ],
							),
						),
					);
					 */

					// Desktop
					if ( ! empty( $desktop_style[ 'h' . $i ] ) ) {
						$desktop_styles = '';
						foreach ( $desktop_style[ 'h' . $i ] as $key => $val ) {
							$desktop_styles .= "\t" . $key . ':' . $val . ';' . "\n";
						}

						$desktop_css .=
							$selector . '{' . "\n";
						$desktop_css .= $desktop_styles;
						$desktop_css .= '}' . "\n";
					}

					// Tablet
					if ( ! empty( $tablet_style[ 'h' . $i ] ) ) {
						$tablet_styles = '';
						foreach ( $tablet_style[ 'h' . $i ] as $key => $val ) {
							$tablet_styles .= "\t\t" . $key . ':' . $val . ';' . "\n";
						}

						$tablet_css .=
							"\t" . $selector . ',' . "\n";
						$tablet_css .= $tablet_styles;
						$tablet_css .= "\t" . '}' . "\n";
					}

					// Smartphone
					if ( ! empty( $smartphone_style[ 'h' . $i ] ) ) {
						$smartphone_styles = '';
						foreach ( $smartphone_style[ 'h' . $i ] as $key => $val ) {
							$smartphone_styles .= "\t\t" . $key . ':' . $val . ';' . "\n";
						}

						$smartphone_css .=
							"\t" . $selector . ',' . "\n";
						$smartphone_css .= $smartphone_styles;
						$smartphone_css .= "\t" . '}' . "\n";
					}

					// Before
					if ( ! empty( $before_style[ 'h' . $i ] ) ) {
						$before_styles = '';

						foreach ( $before_style[ 'h' . $i ] as $key => $val ) {
							$before_styles .= "\t" . $key . ':' . $val . ';' . "\n";
						}

						$before_css .=
							$selector . '::before{' . "\n";
						$before_css .= $before_styles;
						$before_css .= '}' . "\n";
					}

					// After
					if ( ! empty( $after_style[ 'h' . $i ] ) ) {
						$after_styles = '';

						foreach ( $after_style[ 'h' . $i ] as $key => $val ) {
							$after_styles .= "\t" . $key . ':' . $val . ';' . "\n";
						}

						$after_css .=
							$selector . '::after{' . "\n";
						$after_css .= $after_styles;
						$after_css .= '}' . "\n";
					}
				}
			}

			if ( ! empty( $desktop_css ) ) {
				$css .= $desktop_css;
			}

			if ( ! empty( $before_css ) ) {
				$css .= $before_css;
			}

			if ( ! empty( $after_css ) ) {
				$css .= $after_css;
			}

			if ( ! empty( $tablet_css ) ) {
				$css .= $media_query_tablet . '{' . "\n";
				$css .= $tablet_css;
				$css .= '}' . "\n";
			}

			if ( ! empty( $smartphone_css ) ) {
				$css .= $media_query_smartphone . '{' . "\n";
				$css .= $smartphone_css;
				$css .= '}' . "\n";
			}

			$code_array = array(
				'code' => $css,
			);

			$data = array( array_merge( $base_array, $heading_array, $code_array ) );

			return $data;
		}
	}
}

